/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item.filter;

import cofh.api.energy.IEnergyContainerItem;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.network.NetworkUtil;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.item.IItemFilterGui;
import crazypants.enderio.conduit.gui.item.PowerItemFilterGui;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.NetworkedInventory;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PowerItemFilter
implements IItemFilter {
    public static final int MAX_LEVEL = 4;
    CmpMode mode = CmpMode.EQUAL;
    boolean sticky;
    int level = 4;

    @Override
    public boolean doesItemPassFilter(NetworkedInventory inv, ItemStack item) {
        if (item != null && item.func_77973_b() instanceof IEnergyContainerItem) {
            IEnergyContainerItem chargable = (IEnergyContainerItem)item.func_77973_b();
            int max = chargable.getMaxEnergyStored(item);
            int cur = chargable.getEnergyStored(item);
            int ref = (int)((long)max * (long)this.level / 4L);
            switch (this.mode) {
                case LESS: {
                    return cur < ref;
                }
                case LESS_EQUAL: {
                    return cur <= ref;
                }
                case EQUAL: {
                    return cur == ref;
                }
                case MORE_EQUAL: {
                    return cur >= ref;
                }
                case MORE: {
                    return cur > ref;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean doesFilterCaptureStack(NetworkedInventory inv, ItemStack item) {
        boolean res = this.sticky && this.doesItemPassFilter(inv, item);
        return res;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    @Override
    public void createGhostSlots(List<GhostSlot> slots, int xOffset, int yOffset, Runnable cb) {
    }

    @Override
    public int getSlotCount() {
        return 0;
    }

    public CmpMode getMode() {
        return this.mode;
    }

    public void setMode(CmpMode mode) {
        this.mode = mode;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemFilterGui getGui(GuiExternalConnection gui, IItemConduit itemConduit, boolean isInput) {
        return new PowerItemFilterGui(gui, itemConduit, isInput);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot) {
        this.readSettingsFromNBT(nbtRoot);
    }

    protected void readSettingsFromNBT(NBTTagCompound nbtRoot) {
        this.mode = CmpMode.values()[nbtRoot.func_74771_c("mode") & 0xFF];
        this.level = nbtRoot.func_74765_d("level");
        this.sticky = nbtRoot.func_74767_n("sticky");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        this.writeSettingToNBT(nbtRoot);
    }

    protected void writeSettingToNBT(NBTTagCompound nbtRoot) {
        nbtRoot.func_74774_a("mode", (byte)this.mode.ordinal());
        nbtRoot.func_74777_a("level", (short)this.level);
        nbtRoot.func_74757_a("sticky", this.sticky);
    }

    @Override
    public void writeToByteBuf(ByteBuf buf) {
        NBTTagCompound settingsTag = new NBTTagCompound();
        this.writeSettingToNBT(settingsTag);
        NetworkUtil.writeNBTTagCompound((NBTTagCompound)settingsTag, (ByteBuf)buf);
    }

    @Override
    public void readFromByteBuf(ByteBuf buf) {
        NBTTagCompound settingsTag = NetworkUtil.readNBTTagCompound((ByteBuf)buf);
        this.readSettingsFromNBT(settingsTag);
    }

    public static enum CmpMode {
        LESS,
        LESS_EQUAL,
        EQUAL,
        MORE_EQUAL,
        MORE;


        public CmpMode next() {
            CmpMode[] values = CmpMode.values();
            return values[(this.ordinal() + 1) % values.length];
        }
    }
}

