/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui;

import com.enderio.core.api.client.gui.ITabPanel;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.LiquidSettings;
import crazypants.enderio.conduit.gui.PowerSettings;
import crazypants.enderio.conduit.gui.RedstoneSettings;
import crazypants.enderio.conduit.gui.item.ItemSettings;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;

public class TabFactory {
    public static final TabFactory instance = new TabFactory();

    private TabFactory() {
    }

    public ITabPanel createPanelForConduit(GuiExternalConnection gui, IConduit con) {
        Class<? extends IConduit> baseType = con.getBaseConduitType();
        if (baseType.isAssignableFrom(IPowerConduit.class)) {
            return new PowerSettings(gui, con);
        }
        if (baseType.isAssignableFrom(ILiquidConduit.class)) {
            return new LiquidSettings(gui, con);
        }
        if (baseType.isAssignableFrom(IItemConduit.class)) {
            return new ItemSettings(gui, con);
        }
        if (baseType.isAssignableFrom(IRedstoneConduit.class)) {
            return new RedstoneSettings(gui, con);
        }
        return null;
    }
}

