/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.geom;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.VertexRotation;
import com.enderio.core.client.render.VertexTransformComposite;
import com.enderio.core.client.render.VertexTranslation;
import com.enderio.core.common.util.ForgeDirectionOffsets;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector4f;
import com.enderio.core.common.vecmath.Vertex;
import crazypants.enderio.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.conduit.geom.Offset;
import crazypants.enderio.conduit.render.BakedQuadBuilder;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;

public class ConnectionModeGeometry {
    private static final EnumMap<EnumFacing, List<Vertex>> VERTS = new EnumMap(EnumFacing.class);

    private static List<Vertex> createVerticesForDir(BoundingBox refBB, VertexTransform xform) {
        ArrayList<Vertex> result = new ArrayList<Vertex>(24);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            result.addAll(refBB.getCornersWithUvForFace(face));
        }
        for (Vertex v : result) {
            xform.apply(v.xyz);
            xform.applyToNormal(v.normal);
        }
        return result;
    }

    public static void addModeConnectorQuads(EnumFacing dir, Offset offset, TextureAtlasSprite tex, Vector4f color, List<BakedQuad> quads) {
        List<Vertex> verts = VERTS.get(dir);
        if (verts == null) {
            return;
        }
        Vector3d trans = ConduitGeometryUtil.instance.getTranslation(dir, offset);
        ArrayList<Vertex> xFormed = new ArrayList<Vertex>(verts.size());
        for (Vertex v : verts) {
            Vertex xf = new Vertex(v);
            xf.xyz.add(trans);
            xFormed.add(xf);
        }
        BakedQuadBuilder.addBakedQuads(quads, xFormed, tex, color);
    }

    static {
        float scale = 0.9f;
        BoundingBox refBB = ConduitGeometryUtil.CORE_BOUNDS;
        refBB = refBB.scale(scale, scale, scale);
        refBB = refBB.scale(scale, 1.0f, 1.0f);
        double offset = ConduitGeometryUtil.HWIDTH * scale * scale + 0.05f;
        VertexRotation vrot = new VertexRotation(1.5707963267948966, new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.5, 0.5, 0.5));
        VertexTranslation vtrans = new VertexTranslation(0.0f, 0.0f, 0.0f);
        VertexTransformComposite xform = new VertexTransformComposite(new VertexTransform[]{vrot, vtrans});
        EnumFacing dir = EnumFacing.SOUTH;
        Vector3d trans = ForgeDirectionOffsets.offsetScaled((EnumFacing)dir, (double)0.5);
        trans.sub(ForgeDirectionOffsets.offsetScaled((EnumFacing)dir, (double)offset));
        vtrans.set(trans);
        VERTS.put(dir, ConnectionModeGeometry.createVerticesForDir(refBB, (VertexTransform)xform));
        dir = EnumFacing.NORTH;
        vrot.setAngle(4.71238898038469);
        trans = ForgeDirectionOffsets.offsetScaled((EnumFacing)dir, (double)0.5);
        trans.sub(ForgeDirectionOffsets.offsetScaled((EnumFacing)dir, (double)offset));
        vtrans.set(trans);
        VERTS.put(dir, ConnectionModeGeometry.createVerticesForDir(refBB, (VertexTransform)xform));
        dir = EnumFacing.EAST;
        vrot.setAngle(Math.PI);
        trans = ForgeDirectionOffsets.offsetScaled((EnumFacing)dir, (double)0.5);
        trans.sub(ForgeDirectionOffsets.offsetScaled((EnumFacing)dir, (double)offset));
        vtrans.set(trans);
        VERTS.put(dir, ConnectionModeGeometry.createVerticesForDir(refBB, (VertexTransform)xform));
        dir = EnumFacing.WEST;
        vrot.setAngle(0.0);
        trans = ForgeDirectionOffsets.offsetScaled((EnumFacing)dir, (double)0.5);
        trans.sub(ForgeDirectionOffsets.offsetScaled((EnumFacing)dir, (double)offset));
        vtrans.set(trans);
        VERTS.put(dir, ConnectionModeGeometry.createVerticesForDir(refBB, (VertexTransform)xform));
        vrot.setAxis(new Vector3d(0.0, 0.0, 1.0));
        dir = EnumFacing.UP;
        vrot.setAngle(-1.5707963267948966);
        trans = ForgeDirectionOffsets.offsetScaled((EnumFacing)dir, (double)0.5);
        trans.sub(ForgeDirectionOffsets.offsetScaled((EnumFacing)dir, (double)offset));
        vtrans.set(trans);
        VERTS.put(dir, ConnectionModeGeometry.createVerticesForDir(refBB, (VertexTransform)xform));
        dir = EnumFacing.DOWN;
        vrot.setAngle(1.5707963267948966);
        trans = ForgeDirectionOffsets.offsetScaled((EnumFacing)dir, (double)0.5);
        trans.sub(ForgeDirectionOffsets.offsetScaled((EnumFacing)dir, (double)offset));
        vtrans.set(trans);
        VERTS.put(dir, ConnectionModeGeometry.createVerticesForDir(refBB, (VertexTransform)xform));
    }
}

