/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.EnderIO;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.conduit.ConduitDisplayMode;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.facade.EnumFacadeType;
import crazypants.enderio.conduit.geom.CollidableCache;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.geom.ConduitConnectorType;
import crazypants.enderio.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.conduit.geom.Offset;
import crazypants.enderio.conduit.geom.Offsets;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.config.Config;
import crazypants.enderio.paint.PainterUtil2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileConduitBundle
extends TileEntityEio
implements IConduitBundle {
    public static final short NBT_VERSION = 1;
    private final List<IConduit> conduits = new CopyOnWriteArrayList<IConduit>();
    private IBlockState facade = null;
    private EnumFacadeType facadeType = EnumFacadeType.BASIC;
    private boolean facadeChanged;
    private final List<CollidableComponent> cachedCollidables = new CopyOnWriteArrayList<CollidableComponent>();
    private final List<CollidableComponent> cachedConnectors = new CopyOnWriteArrayList<CollidableComponent>();
    private boolean conduitsDirty = true;
    private boolean collidablesDirty = true;
    private boolean connectorsDirty = true;
    private boolean clientUpdated = false;
    private int lightOpacity = -1;
    @SideOnly(value=Side.CLIENT)
    private IConduitBundle.FacadeRenderState facadeRenderAs;
    private ConduitDisplayMode lastMode = ConduitDisplayMode.ALL;
    Object covers;

    public TileConduitBundle() {
        this.field_145854_h = EnderIO.blockConduitBundle;
    }

    @Override
    public void dirty() {
        this.conduitsDirty = true;
        this.collidablesDirty = true;
    }

    public boolean shouldRenderInPass(int arg0) {
        if (this.facade != null && this.facade.func_177230_c().func_149662_c() && !ConduitUtil.isFacadeHidden(this, EnderIO.proxy.getClientPlayer())) {
            return false;
        }
        return super.shouldRenderInPass(arg0);
    }

    @Override
    public World getBundleWorldObj() {
        return this.func_145831_w();
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        NBTTagList conduitTags = new NBTTagList();
        for (IConduit conduit : this.conduits) {
            NBTTagCompound conduitRoot = new NBTTagCompound();
            ConduitUtil.writeToNBT(conduit, conduitRoot);
            conduitTags.func_74742_a((NBTBase)conduitRoot);
        }
        nbtRoot.func_74782_a("conduits", (NBTBase)conduitTags);
        if (this.facade != null) {
            PainterUtil2.writeNbt(nbtRoot, this.facade);
            nbtRoot.func_74778_a("facadeType", this.facadeType.name());
        }
        nbtRoot.func_74777_a("nbtVersion", (short)1);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtRoot) {
        short nbtVersion = nbtRoot.func_74765_d("nbtVersion");
        this.conduits.clear();
        this.cachedCollidables.clear();
        NBTTagList conduitTags = (NBTTagList)nbtRoot.func_74781_a("conduits");
        if (conduitTags != null) {
            for (int i = 0; i < conduitTags.func_74745_c(); ++i) {
                NBTTagCompound conduitTag = conduitTags.func_150305_b(i);
                IConduit conduit = ConduitUtil.readConduitFromNBT(conduitTag, nbtVersion);
                if (conduit == null) continue;
                conduit.setBundle(this);
                this.conduits.add(conduit);
            }
        }
        this.facade = PainterUtil2.readNbt(nbtRoot);
        if (this.facade != null) {
            this.facadeType = nbtRoot.func_74764_b("facadeType") ? EnumFacadeType.valueOf(nbtRoot.func_74779_i("facadeType")) : EnumFacadeType.BASIC;
        } else {
            this.facade = null;
            this.facadeType = EnumFacadeType.BASIC;
        }
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.clientUpdated = true;
        }
    }

    @Override
    public boolean hasFacade() {
        return this.facade != null;
    }

    public void setFacadeNoUpdate(IBlockState paintSource) {
        this.facade = paintSource;
    }

    @Override
    public void setPaintSource(IBlockState paintSource) {
        this.facade = paintSource;
        this.facadeChanged = true;
        this.func_70296_d();
        this.updateBlock();
    }

    @Override
    public IBlockState getPaintSource() {
        return this.facade;
    }

    @Override
    public void setFacadeType(EnumFacadeType type) {
        this.facadeType = type;
        this.func_70296_d();
    }

    @Override
    public EnumFacadeType getFacadeType() {
        return this.facadeType;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IConduitBundle.FacadeRenderState getFacadeRenderedAs() {
        if (this.facadeRenderAs == null) {
            this.facadeRenderAs = IConduitBundle.FacadeRenderState.NONE;
        }
        return this.facadeRenderAs;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setFacadeRenderAs(IConduitBundle.FacadeRenderState state) {
        this.facadeRenderAs = state;
    }

    @Override
    public int getLightOpacity() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K || this.lightOpacity == -1) {
            return this.facade != null ? this.facade.func_177230_c().func_149717_k() : 0;
        }
        return this.lightOpacity;
    }

    @Override
    public void setLightOpacity(int opacity) {
        this.lightOpacity = opacity;
    }

    public void onChunkUnload() {
        for (IConduit conduit : this.conduits) {
            conduit.onChunkUnload(this.field_145850_b);
        }
    }

    public void doUpdate() {
        for (IConduit conduit : this.conduits) {
            conduit.updateEntity(this.field_145850_b);
        }
        if (this.conduitsDirty) {
            this.doConduitsDirty();
        }
        if (this.facadeChanged) {
            this.doFacadeChanged();
        }
        if (this.field_145850_b.field_72995_K) {
            this.updateEntityClient();
        }
    }

    private void doConduitsDirty() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175689_h(this.func_174877_v());
            this.func_70296_d();
        }
        this.conduitsDirty = false;
    }

    private void doFacadeChanged() {
        ConduitUtil.forceSkylightRecalculation(this.field_145850_b, this.func_174877_v());
        this.field_145850_b.func_175664_x(this.func_174877_v());
        this.field_145850_b.func_175689_h(this.func_174877_v());
        this.field_145850_b.func_175685_c(this.func_174877_v(), (Block)EnderIO.blockConduitBundle);
        this.facadeChanged = false;
    }

    private void updateEntityClient() {
        boolean markForUpdate = false;
        if (this.clientUpdated) {
            markForUpdate = true;
            this.clientUpdated = false;
        }
        IConduitBundle.FacadeRenderState curRS = this.getFacadeRenderedAs();
        IConduitBundle.FacadeRenderState rs = ConduitUtil.getRequiredFacadeRenderState(this, EnderIO.proxy.getClientPlayer());
        if (Config.updateLightingWhenHidingFacades) {
            int shouldBeLO;
            int curLO = this.getLightOpacity();
            int n = shouldBeLO = rs == IConduitBundle.FacadeRenderState.FULL ? 255 : 0;
            if (curLO != shouldBeLO) {
                this.setLightOpacity(shouldBeLO);
                this.field_145850_b.func_175664_x(this.func_174877_v());
            }
        }
        if (curRS != rs) {
            this.setFacadeRenderAs(rs);
            if (!ConduitUtil.forceSkylightRecalculation(this.field_145850_b, this.func_174877_v())) {
                markForUpdate = true;
            }
        } else {
            ConduitDisplayMode curMode = ConduitDisplayMode.getDisplayMode(EnderIO.proxy.getClientPlayer().func_71045_bC());
            if (curMode != this.lastMode) {
                markForUpdate = true;
                this.lastMode = curMode;
            }
        }
        if (markForUpdate) {
            this.field_145850_b.func_175689_h(this.func_174877_v());
        }
    }

    @Override
    public void onNeighborBlockChange(Block blockId) {
        boolean needsUpdate = false;
        for (IConduit conduit : this.conduits) {
            needsUpdate |= conduit.onNeighborBlockChange(blockId);
        }
        if (needsUpdate) {
            this.dirty();
        }
    }

    @Override
    public void onNeighborChange(IBlockAccess world, BlockPos posIn, BlockPos neighbor) {
        boolean needsUpdate = false;
        for (IConduit conduit : this.conduits) {
            needsUpdate |= conduit.onNeighborChange(world, posIn, neighbor);
        }
        if (needsUpdate) {
            this.dirty();
        }
    }

    public TileConduitBundle getEntity() {
        return this;
    }

    @Override
    public boolean hasType(Class<? extends IConduit> type) {
        return this.getConduit(type) != null;
    }

    @Override
    public <T extends IConduit> T getConduit(Class<T> type) {
        if (type == null) {
            return null;
        }
        for (IConduit conduit : this.conduits) {
            if (!type.isInstance(conduit)) continue;
            return (T)conduit;
        }
        return null;
    }

    @Override
    public void addConduit(IConduit conduit) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.conduits.add(conduit);
        conduit.setBundle(this);
        conduit.onAddedToBundle();
        this.dirty();
    }

    @Override
    public void removeConduit(IConduit conduit) {
        if (conduit != null) {
            this.removeConduit(conduit, true);
        }
    }

    public void removeConduit(IConduit conduit, boolean notify) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        conduit.onRemovedFromBundle();
        this.conduits.remove(conduit);
        conduit.setBundle(null);
        if (notify) {
            this.dirty();
        }
    }

    @Override
    public void onBlockRemoved() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ArrayList<IConduit> copy = new ArrayList<IConduit>(this.conduits);
        for (IConduit con : copy) {
            this.removeConduit(con, false);
        }
        this.dirty();
    }

    @Override
    public Collection<IConduit> getConduits() {
        return this.conduits;
    }

    @Override
    public Set<EnumFacing> getConnections(Class<? extends IConduit> type) {
        IConduit con = this.getConduit(type);
        if (con != null) {
            return con.getConduitConnections();
        }
        return null;
    }

    @Override
    public boolean containsConnection(Class<? extends IConduit> type, EnumFacing dir) {
        IConduit con = this.getConduit(type);
        if (con != null) {
            return con.containsConduitConnection(dir);
        }
        return false;
    }

    @Override
    public boolean containsConnection(EnumFacing dir) {
        for (IConduit con : this.conduits) {
            if (!con.containsConduitConnection(dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<EnumFacing> getAllConnections() {
        EnumSet<EnumFacing> result = EnumSet.noneOf(EnumFacing.class);
        for (IConduit con : this.conduits) {
            result.addAll(con.getConduitConnections());
        }
        return result;
    }

    @Override
    public Offset getOffset(Class<? extends IConduit> type, EnumFacing dir) {
        if (this.getConnectionCount(dir) < 2) {
            return Offset.NONE;
        }
        return Offsets.get(type, dir);
    }

    @Override
    public List<CollidableComponent> getCollidableComponents() {
        for (IConduit con : this.conduits) {
            this.collidablesDirty = this.collidablesDirty || con.haveCollidablesChangedSinceLastCall();
        }
        if (this.collidablesDirty) {
            this.connectorsDirty = true;
        }
        if (!this.collidablesDirty && !this.cachedCollidables.isEmpty()) {
            return this.cachedCollidables;
        }
        this.cachedCollidables.clear();
        for (IConduit conduit : this.conduits) {
            this.cachedCollidables.addAll(conduit.getCollidableComponents());
        }
        this.addConnectors(this.cachedCollidables);
        this.collidablesDirty = false;
        return this.cachedCollidables;
    }

    @Override
    public List<CollidableComponent> getConnectors() {
        ArrayList<CollidableComponent> result = new ArrayList<CollidableComponent>();
        this.addConnectors(result);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void addConnectors(List<CollidableComponent> result) {
        void var5_15;
        void var6_29;
        Object cc;
        if (this.conduits.isEmpty()) {
            return;
        }
        for (IConduit iConduit : this.conduits) {
            boolean b = iConduit.haveCollidablesChangedSinceLastCall();
            this.collidablesDirty = this.collidablesDirty || b;
            this.connectorsDirty = this.connectorsDirty || b;
        }
        if (!this.connectorsDirty && !this.cachedConnectors.isEmpty()) {
            result.addAll(this.cachedConnectors);
            return;
        }
        this.cachedConnectors.clear();
        ArrayList<CollidableComponent> coreBounds = new ArrayList<CollidableComponent>();
        for (IConduit con : this.conduits) {
            this.addConduitCores(coreBounds, con);
        }
        this.cachedConnectors.addAll(coreBounds);
        result.addAll(coreBounds);
        ArrayList<CollidableComponent> arrayList = new ArrayList<CollidableComponent>();
        for (IConduit iConduit : this.conduits) {
            arrayList.addAll(iConduit.getCollidableComponents());
            this.addConduitCores(arrayList, iConduit);
        }
        HashSet<Class<? extends IConduit>> collidingTypes = new HashSet<Class<? extends IConduit>>();
        for (CollidableComponent collidableComponent : arrayList) {
            for (CollidableComponent collidableComponent2 : arrayList) {
                if ("ColorController".equals(collidableComponent2.data) || "ColorController".equals(collidableComponent.data) || collidableComponent == collidableComponent2 || !collidableComponent.bound.intersects(collidableComponent2.bound)) continue;
                collidingTypes.add(collidableComponent.conduitType);
            }
        }
        if (!collidingTypes.isEmpty()) {
            void var6_20;
            ArrayList<CollidableComponent> arrayList2 = new ArrayList<CollidableComponent>();
            for (Class clazz : collidingTypes) {
                Object t = this.getConduit(clazz);
                if (t == null) continue;
                this.addConduitCores((List<CollidableComponent>)arrayList2, (IConduit)t);
            }
            Object var6_19 = null;
            for (CollidableComponent collidableComponent : arrayList2) {
                if (var6_20 == null) {
                    BoundingBox boundingBox = collidableComponent.bound;
                    continue;
                }
                BoundingBox boundingBox = var6_20.expandBy(collidableComponent.bound);
            }
            if (var6_20 != null) {
                BoundingBox boundingBox = var6_20.scale(1.05, 1.05, 1.05);
                CollidableComponent collidableComponent = new CollidableComponent(null, boundingBox, null, (Object)ConduitConnectorType.INTERNAL);
                result.add(collidableComponent);
                this.cachedConnectors.add(collidableComponent);
            }
        }
        for (IConduit iConduit : this.conduits) {
            void var8_51;
            if (!iConduit.hasConnections()) continue;
            ArrayList<CollidableComponent> arrayList3 = new ArrayList<CollidableComponent>();
            this.addConduitCores(arrayList3, iConduit);
            if (arrayList3.size() <= 1) continue;
            BoundingBox boundingBox = ((CollidableComponent)arrayList3.get((int)0)).bound;
            float area = boundingBox.getArea();
            for (CollidableComponent cc3 : arrayList3) {
                BoundingBox boundingBox2 = var8_51.expandBy(cc3.bound);
            }
            if (!(var8_51.getArea() > area * 1.5f)) continue;
            BoundingBox boundingBox3 = var8_51.scale(1.05, 1.05, 1.05);
            cc = new CollidableComponent(null, boundingBox3, null, (Object)ConduitConnectorType.INTERNAL);
            result.add((CollidableComponent)cc);
            this.cachedConnectors.add((CollidableComponent)cc);
        }
        Object var5_14 = null;
        boolean bl = false;
        while (var6_29 < result.size()) {
            CollidableComponent collidableComponent = result.get((int)var6_29);
            if (collidableComponent.conduitType == null && collidableComponent.data == ConduitConnectorType.INTERNAL) {
                BoundingBox boundingBox = var5_15 == null ? collidableComponent.bound : var5_15.expandBy(collidableComponent.bound);
                result.remove((int)var6_29);
                --var6_29;
                this.cachedConnectors.remove(collidableComponent);
            }
            ++var6_29;
        }
        if (var5_15 != null) {
            CollidableComponent collidableComponent = new CollidableComponent(null, (BoundingBox)var5_15, null, (Object)ConduitConnectorType.INTERNAL);
            result.add(collidableComponent);
            this.cachedConnectors.add(collidableComponent);
        }
        EnumSet<EnumFacing> enumSet = EnumSet.noneOf(EnumFacing.class);
        for (IConduit iConduit : this.conduits) {
            Set<EnumFacing> extCons = iConduit.getExternalConnections();
            if (extCons == null) continue;
            for (EnumFacing dir : extCons) {
                if (iConduit.getConnectionMode(dir) == ConnectionMode.DISABLED) continue;
                enumSet.add(dir);
            }
        }
        for (EnumFacing enumFacing : enumSet) {
            BoundingBox bb = ConduitGeometryUtil.instance.getExternalConnectorBoundingBox(enumFacing);
            cc = new CollidableComponent(null, bb, enumFacing, (Object)ConduitConnectorType.EXTERNAL);
            result.add((CollidableComponent)cc);
            this.cachedConnectors.add((CollidableComponent)cc);
        }
        this.connectorsDirty = false;
    }

    private void addConduitCores(List<CollidableComponent> result, IConduit con) {
        CollidableCache cc = CollidableCache.instance;
        Class<? extends IConduit> type = con.getCollidableType();
        if (con.hasConnections()) {
            for (EnumFacing dir : con.getExternalConnections()) {
                result.addAll(cc.getCollidables(cc.createKey(type, this.getOffset(con.getBaseConduitType(), dir), null, false), con));
            }
            for (EnumFacing dir : con.getConduitConnections()) {
                result.addAll(cc.getCollidables(cc.createKey(type, this.getOffset(con.getBaseConduitType(), dir), null, false), con));
            }
        } else {
            result.addAll(cc.getCollidables(cc.createKey(type, this.getOffset(con.getBaseConduitType(), null), null, false), con));
        }
    }

    private int getConnectionCount(EnumFacing dir) {
        if (dir == null) {
            return this.conduits.size();
        }
        int result = 0;
        for (IConduit con : this.conduits) {
            if (!con.containsConduitConnection(dir) && !con.containsExternalConnection(dir)) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.receiveEnergy(from, maxReceive, simulate);
        }
        return 0;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.canConnectEnergy(from);
        }
        return false;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.getEnergyStored(from);
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.getMaxEnergyStored(from);
        }
        return 0;
    }

    @Override
    public int getMaxEnergyRecieved(EnumFacing dir) {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.getMaxEnergyRecieved(dir);
        }
        return 0;
    }

    @Override
    public int getEnergyStored() {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.getEnergyStored();
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored() {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.getMaxEnergyStored();
        }
        return 0;
    }

    @Override
    public void setEnergyStored(int stored) {
        IPowerConduit pc = this.getConduit(IPowerConduit.class);
        if (pc != null) {
            pc.setEnergyStored(stored);
        }
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        ILiquidConduit lc = this.getConduit(ILiquidConduit.class);
        if (lc != null) {
            return lc.fill(from, resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        ILiquidConduit lc = this.getConduit(ILiquidConduit.class);
        if (lc != null) {
            return lc.drain(from, resource, doDrain);
        }
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        ILiquidConduit lc = this.getConduit(ILiquidConduit.class);
        if (lc != null) {
            return lc.drain(from, maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        ILiquidConduit lc = this.getConduit(ILiquidConduit.class);
        if (lc != null) {
            return lc.canFill(from, fluid);
        }
        return false;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        ILiquidConduit lc = this.getConduit(ILiquidConduit.class);
        if (lc != null) {
            return lc.canDrain(from, fluid);
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        ILiquidConduit lc = this.getConduit(ILiquidConduit.class);
        if (lc != null) {
            return lc.getTankInfo(from);
        }
        return null;
    }

    @Override
    public boolean displayPower() {
        return true;
    }

    @Override
    public BlockCoord getLocation() {
        return new BlockCoord(this.func_174877_v());
    }
}

