/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.tool.ITool;
import crazypants.enderio.conduit.ConduitDisplayMode;
import crazypants.enderio.conduit.ConduitNetworkTickHandler;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.IConduitItem;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.TileConduitBundle;
import crazypants.enderio.conduit.facade.EnumFacadeType;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.geom.ConduitConnectorType;
import crazypants.enderio.conduit.gui.ExternalConnectionContainer;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.GuiExternalConnectionSelector;
import crazypants.enderio.conduit.gui.PacketFluidFilter;
import crazypants.enderio.conduit.gui.PacketOpenConduitUI;
import crazypants.enderio.conduit.gui.PacketSlotVisibility;
import crazypants.enderio.conduit.gui.item.PacketExistingItemFilterSnapshot;
import crazypants.enderio.conduit.gui.item.PacketModItemFilter;
import crazypants.enderio.conduit.liquid.PacketFluidLevel;
import crazypants.enderio.conduit.packet.PacketConnectionMode;
import crazypants.enderio.conduit.packet.PacketExtractMode;
import crazypants.enderio.conduit.packet.PacketItemConduitFilter;
import crazypants.enderio.conduit.packet.PacketRedstoneConduitOutputStrength;
import crazypants.enderio.conduit.packet.PacketRedstoneConduitSignalColor;
import crazypants.enderio.conduit.redstone.IInsulatedRedstoneConduit;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduit.render.ConduitRenderMapper;
import crazypants.enderio.item.ItemConduitProbe;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.enderio.render.SmartModelAttacher;
import crazypants.enderio.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.tool.ToolUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.sound.PlaySoundSourceEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(iface="powercrystals.minefactoryreloaded.api.rednet.IRedNetOmniNode", modid="MineFactoryReloaded"), @Optional.Interface(iface="mods.immibis.core.api.multipart.IMultipartRenderingBlockMarker", modid="ImmibisMicroblocks")})
public class BlockConduitBundle
extends BlockEio<TileConduitBundle>
implements IGuiHandler,
IPaintable.IBlockPaintableBlock,
IPaintable.IWrenchHideablePaint {
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite lastRemovedComponetIcon;
    private final Random rand = new Random();

    public static BlockConduitBundle create() {
        MinecraftForge.EVENT_BUS.register((Object)ConduitNetworkTickHandler.instance);
        PacketHandler.INSTANCE.registerMessage(PacketFluidLevel.class, PacketFluidLevel.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketExtractMode.class, PacketExtractMode.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketConnectionMode.class, PacketConnectionMode.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketItemConduitFilter.class, PacketItemConduitFilter.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketExistingItemFilterSnapshot.class, PacketExistingItemFilterSnapshot.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketModItemFilter.class, PacketModItemFilter.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketFluidFilter.class, PacketFluidFilter.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketRedstoneConduitSignalColor.class, PacketRedstoneConduitSignalColor.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketRedstoneConduitOutputStrength.class, PacketRedstoneConduitOutputStrength.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketOpenConduitUI.class, PacketOpenConduitUI.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketSlotVisibility.class, PacketSlotVisibility.class, PacketHandler.nextID(), Side.SERVER);
        BlockConduitBundle result = new BlockConduitBundle();
        result.init();
        MinecraftForge.EVENT_BUS.register((Object)result);
        return result;
    }

    protected BlockConduitBundle() {
        super(ModObject.blockConduitBundle.getUnlocalisedName(), TileConduitBundle.class);
        this.func_149676_a(0.334f, 0.334f, 0.334f, 0.667f, 0.667f, 0.667f);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149647_a(null);
        this.field_149762_H = new Block.SoundType("silence", 0.0f, 0.0f){

            public String func_150495_a() {
                return "EnderIO:" + this.field_150501_a + ".dig";
            }

            public String func_150498_e() {
                return "EnderIO:" + this.field_150501_a + ".step";
            }
        };
        this.func_180632_j(this.field_176227_L.func_177621_b());
    }

    protected void init() {
        super.init();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            EnderIO.guiHandler.registerGuiHandler(9 + dir.ordinal(), this);
        }
        EnderIO.guiHandler.registerGuiHandler(16, this);
        SmartModelAttacher.registerNoProps((Block)this);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state != null && world != null && pos != null) {
            BlockStateWrapperBase blockStateWrapper = new BlockStateWrapperBase(state, world, pos, ConduitRenderMapper.instance);
            blockStateWrapper.bakeModel();
            return blockStateWrapper;
        }
        return state;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        TextureAtlasSprite tex = null;
        TileConduitBundle cb = (TileConduitBundle)world.func_175625_s(target.func_178782_a());
        if (ConduitUtil.isSolidFacadeRendered(cb, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            IBlockState paintSource = cb.getPaintSource();
            if (paintSource != null) {
                tex = RenderUtil.getTexture((IBlockState)paintSource);
            }
        } else if (target.hitInfo instanceof CollidableComponent) {
            CollidableComponent cc = (CollidableComponent)target.hitInfo;
            IConduit con = cb.getConduit(cc.conduitType);
            if (con != null) {
                tex = con.getTextureForState(cc);
            }
        }
        if (tex == null) {
            tex = IconUtil.instance.whiteTexture;
        }
        this.lastRemovedComponetIcon = tex;
        BlockPos p = target.func_178782_a();
        this.addBlockHitEffects(world, effectRenderer, p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), target.field_178784_b, tex);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, EffectRenderer effectRenderer) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        TextureAtlasSprite tex = this.lastRemovedComponetIcon;
        int b0 = 4;
        for (int j1 = 0; j1 < b0; ++j1) {
            for (int k1 = 0; k1 < b0; ++k1) {
                for (int l1 = 0; l1 < b0; ++l1) {
                    double d0 = (double)x + ((double)j1 + 0.5) / (double)b0;
                    double d1 = (double)y + ((double)k1 + 0.5) / (double)b0;
                    double d2 = (double)z + ((double)l1 + 0.5) / (double)b0;
                    EntityDiggingFX fx = (EntityDiggingFX)Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), d0, d1, d2, d0 - (double)x - 0.5, d1 - (double)y - 0.5, d2 - (double)z - 0.5, new int[]{0});
                    fx.func_174845_l();
                    fx.func_180435_a(tex);
                    effectRenderer.func_78873_a((EntityFX)fx);
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void addBlockHitEffects(World world, EffectRenderer effectRenderer, int x, int y, int z, EnumFacing sideEnum, TextureAtlasSprite tex) {
        float f = 0.1f;
        double d0 = (double)x + this.rand.nextDouble() * (this.func_149753_y() - this.func_149704_x() - (double)(f * 2.0f)) + (double)f + this.func_149704_x();
        double d1 = (double)y + this.rand.nextDouble() * (this.func_149669_A() - this.func_149665_z() - (double)(f * 2.0f)) + (double)f + this.func_149665_z();
        double d2 = (double)z + this.rand.nextDouble() * (this.func_149693_C() - this.func_149706_B() - (double)(f * 2.0f)) + (double)f + this.func_149706_B();
        int side = sideEnum.ordinal();
        if (side == 0) {
            d1 = (double)y + this.func_149665_z() - (double)f;
        } else if (side == 1) {
            d1 = (double)y + this.func_149669_A() + (double)f;
        } else if (side == 2) {
            d2 = (double)z + this.func_149706_B() - (double)f;
        } else if (side == 3) {
            d2 = (double)z + this.func_149693_C() + (double)f;
        } else if (side == 4) {
            d0 = (double)x + this.func_149704_x() - (double)f;
        } else if (side == 5) {
            d0 = (double)x + this.func_149753_y() + (double)f;
        }
        EntityDiggingFX digFX = (EntityDiggingFX)Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), d0, d1, d2, 0.0, 0.0, 0.0, new int[]{0});
        digFX.func_174845_l().func_70543_e(0.2f).func_70541_f(0.6f);
        digFX.func_180435_a(tex);
        effectRenderer.func_78873_a((EntityFX)digFX);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlaySound(PlaySoundSourceEvent event) {
        String path = event.sound.func_147650_b().toString();
        if (path != null && path.contains("silence.step")) {
            ISound snd = event.sound;
            World world = EnderIO.proxy.getClientWorld();
            BlockCoord bc = new BlockCoord((double)snd.func_147649_g(), (double)snd.func_147654_h(), (double)snd.func_147651_i());
            TileEntity te = bc.getTileEntity((IBlockAccess)world);
            if (te != null && te instanceof TileConduitBundle && ((TileConduitBundle)te).hasFacade()) {
                IBlockState facade = ((TileConduitBundle)te).getPaintSource();
                ConduitUtil.playHitSound(facade.func_177230_c().field_149762_H, world, bc.x, bc.y, bc.z);
            } else {
                ConduitUtil.playHitSound(Block.field_149777_j, world, bc.x, bc.y, bc.z);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlaySoundAtEntity(PlaySoundAtEntityEvent event) {
        String path = event.name;
        World world = event.entity.field_70170_p;
        if ("EnderIO:silence.step".equals(path) && world.field_72995_K) {
            BlockCoord bc = new BlockCoord(event.entity.field_70165_t, event.entity.field_70163_u - 2.0, event.entity.field_70161_v);
            TileEntity te = bc.getTileEntity((IBlockAccess)world);
            if (te != null && te instanceof TileConduitBundle && ((TileConduitBundle)te).hasFacade()) {
                IBlockState facade = ((TileConduitBundle)te).getPaintSource();
                ConduitUtil.playStepSound(facade.func_177230_c().field_149762_H, world, bc.x, bc.y, bc.z);
            } else {
                ConduitUtil.playStepSound(Block.field_149777_j, world, bc.x, bc.y, bc.z);
            }
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack ret = null;
        if (target != null && target.hitInfo instanceof CollidableComponent) {
            CollidableComponent cc = (CollidableComponent)target.hitInfo;
            TileConduitBundle bundle = (TileConduitBundle)world.func_175625_s(pos);
            IConduit conduit = bundle.getConduit(cc.conduitType);
            if (conduit != null) {
                ret = conduit.createItem();
            } else if (cc.conduitType == null && bundle.hasFacade()) {
                ret = new ItemStack((Block)EnderIO.blockConduitFacade, 1, 0);
                PainterUtil2.setSourceBlock(ret, bundle.getPaintSource());
            }
        }
        return ret;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos) {
        return this.getPickBlock(target, world, pos, null);
    }

    public int func_176222_j(World world, BlockPos pos) {
        IBlockState f = this.getPaintSource(null, (IBlockAccess)world, pos);
        return f == null ? 0 : f.func_177230_c().func_176201_c(f);
    }

    public int func_149745_a(Random r) {
        return 0;
    }

    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof IConduitBundle)) {
            return false;
        }
        IConduitBundle con = (IConduitBundle)te;
        return con.hasFacade();
    }

    public boolean func_176193_a(World worldIn, BlockPos pos, EnumFacing side, ItemStack stack) {
        return super.func_176193_a(worldIn, pos, side, stack);
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149717_k() {
        return 0;
    }

    public int getLightOpacity(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof IConduitBundle)) {
            return super.getLightOpacity(world, pos);
        }
        IConduitBundle con = (IConduitBundle)te;
        return con.getLightOpacity();
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof IConduitBundle)) {
            return super.getLightValue(world, pos);
        }
        IConduitBundle con = (IConduitBundle)te;
        int result = 0;
        if (con.hasFacade()) {
            IBlockState paintSource = con.getPaintSource();
            result = paintSource.func_177230_c().func_149750_m();
            if (paintSource.func_177230_c().func_149662_c()) {
                return result;
            }
        }
        Collection<IConduit> conduits = con.getConduits();
        for (IConduit conduit : conduits) {
            result += conduit.getLightValue();
        }
        return result > 15 ? 15 : result;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_176207_c(IBlockAccess worldIn, BlockPos pos) {
        IConduitBundle te = (IConduitBundle)this.getTileEntity(worldIn, pos);
        if (te != null && te.hasFacade()) {
            if (te.getFacadeRenderedAs() == IConduitBundle.FacadeRenderState.WIRE_FRAME) {
                return 255;
            }
            return this.getMixedBrightnessForFacade(worldIn, pos, te.getPaintSource().func_177230_c());
        }
        return super.func_176207_c(worldIn, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public int getMixedBrightnessForFacade(IBlockAccess worldIn, BlockPos pos, Block facadeBlock) {
        int i = worldIn.func_175626_b(pos, this.getLightValue(worldIn, pos));
        if (i == 0 && facadeBlock instanceof BlockSlab) {
            pos = pos.func_177977_b();
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            return worldIn.func_175626_b(pos, block.getLightValue(worldIn, pos));
        }
        if (facadeBlock.func_149710_n()) {
            return this.getNeightbourBrightness(worldIn, pos);
        }
        return i;
    }

    private int getNeightbourBrightness(IBlockAccess worldIn, BlockPos pos) {
        int result = worldIn.func_175626_b(pos.func_177984_a(), 0);
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            int val = worldIn.func_175626_b(pos.func_177972_a(dir), 0);
            if (val <= result) continue;
            result = val;
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180662_a(IBlockAccess worldIn, BlockPos pos, int renderPass) {
        IConduitBundle te = (IConduitBundle)this.getTileEntity(worldIn, pos);
        if (te == null) {
            return super.func_176202_d(worldIn, pos);
        }
        IBlockState ps = te.getPaintSource();
        if (pos == null) {
            return super.func_176202_d(worldIn, pos);
        }
        try {
            return ps.func_177230_c().func_180662_a(worldIn, pos, renderPass);
        }
        catch (Exception e) {
            e.printStackTrace();
            return super.func_180662_a(worldIn, pos, renderPass);
        }
    }

    public float func_176195_g(World world, BlockPos pos) {
        IConduitBundle te = (IConduitBundle)this.getTileEntity((IBlockAccess)world, pos);
        if (te == null) {
            return super.func_176195_g(world, pos);
        }
        return te.getFacadeType() == EnumFacadeType.HARDENED ? this.field_149782_v * 10.0f : this.field_149782_v;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity par1Entity, Explosion explosion) {
        float resist = this.func_149638_a(par1Entity);
        IConduitBundle te = (IConduitBundle)world.func_175625_s(pos);
        return te != null && te.getFacadeType() == EnumFacadeType.HARDENED ? resist * 10.0f : resist;
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.state.func_177230_c() == this) {
            IConduitBundle te;
            ItemStack held = event.entityPlayer.func_71045_bC();
            if (held == null || held.func_77973_b().getHarvestLevel(held, "pickaxe") == -1) {
                event.newSpeed += 2.0f;
            }
            if ((te = (IConduitBundle)event.entity.field_70170_p.func_175625_s(event.pos)) != null && te.getFacadeType() == EnumFacadeType.HARDENED) {
                event.newSpeed = !ConduitUtil.isSolidFacadeRendered(te, event.entityPlayer) ? (event.newSpeed *= 6.0f) : (event.newSpeed *= 2.0f);
            }
        }
    }

    public int func_176211_b(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side) {
        IRedstoneConduit con = BlockConduitBundle.getRedstoneConduit(world, pos);
        if (con == null) {
            return 0;
        }
        return con.isProvidingStrongPower(side);
    }

    public int func_180656_a(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side) {
        IRedstoneConduit con = BlockConduitBundle.getRedstoneConduit(world, pos);
        if (con == null) {
            return 0;
        }
        return con.isProvidingWeakPower(side);
    }

    public boolean func_149744_f() {
        return true;
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        IConduitBundle te = (IConduitBundle)world.func_175625_s(pos);
        if (te == null) {
            return true;
        }
        boolean breakBlock = true;
        ArrayList<ItemStack> drop = new ArrayList<ItemStack>();
        if (ConduitUtil.isSolidFacadeRendered(te, player)) {
            breakBlock = false;
            ItemStack fac = new ItemStack((Block)EnderIO.blockConduitFacade, 1, te.getFacadeType().ordinal());
            PainterUtil2.setSourceBlock(fac, te.getPaintSource());
            drop.add(fac);
            ConduitUtil.playBreakSound(te.getPaintSource().func_177230_c().field_149762_H, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            te.setPaintSource(null);
            te.setFacadeType(EnumFacadeType.BASIC);
        }
        if (breakBlock) {
            List<RaytraceResult> results = this.doRayTraceAll(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), player);
            RaytraceResult.sort(Util.getEyePosition((EntityPlayer)player), results);
            for (RaytraceResult rt : results) {
                if (this.breakConduit(te, drop, rt, player)) break;
            }
        }
        boolean bl = breakBlock = te.getConduits().isEmpty() && !te.hasFacade();
        if (!breakBlock) {
            world.func_175689_h(pos);
        }
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d) {
            for (ItemStack st : drop) {
                Util.dropItems((World)world, (ItemStack)st, (BlockPos)pos, (boolean)false);
            }
        }
        if (breakBlock) {
            world.func_175698_g(pos);
            return true;
        }
        return false;
    }

    private boolean breakConduit(IConduitBundle te, List<ItemStack> drop, RaytraceResult rt, EntityPlayer player) {
        if (rt == null || rt.component == null) {
            return false;
        }
        Class<? extends IConduit> type = rt.component.conduitType;
        if (!ConduitUtil.renderConduit(player, type)) {
            return false;
        }
        if (type == null) {
            ArrayList<IConduit> cons = new ArrayList<IConduit>(te.getConduits());
            boolean droppedUnconected = false;
            for (IConduit con : cons) {
                if (!con.getConduitConnections().isEmpty() || !con.getExternalConnections().isEmpty() || !ConduitUtil.renderConduit(player, con)) continue;
                te.removeConduit(con);
                drop.addAll(con.getDrops());
                droppedUnconected = true;
            }
            if (!droppedUnconected) {
                for (IConduit con : cons) {
                    if (!ConduitUtil.renderConduit(player, con)) continue;
                    te.removeConduit(con);
                    drop.addAll(con.getDrops());
                }
            }
        } else {
            IConduit con = te.getConduit(type);
            if (con != null) {
                te.removeConduit(con);
                drop.addAll(con.getDrops());
            }
        }
        BlockCoord bc = te.getLocation();
        ConduitUtil.playBreakSound(Block.field_149777_j, te.getBundleWorldObj(), bc.x, bc.y, bc.z);
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof IConduitBundle)) {
            return;
        }
        IConduitBundle te = (IConduitBundle)tile;
        te.onBlockRemoved();
        world.func_175713_t(pos);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        ItemStack equipped = player.func_71045_bC();
        if (!player.func_70093_af() || equipped == null || equipped.func_77973_b() != EnderIO.itemYetaWench) {
            return;
        }
        ConduitUtil.openConduitGui(world, pos, player);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        IConduitBundle bundle = (IConduitBundle)world.func_175625_s(pos);
        if (bundle == null) {
            return false;
        }
        ItemStack stack = player.func_71045_bC();
        if (stack != null && Block.func_149634_a((Item)stack.func_77973_b()) == EnderIO.blockConduitFacade) {
            return this.handleFacadeClick(world, pos, player, side, bundle, stack);
        }
        if (ConduitUtil.isConduitEquipped(player)) {
            if (player.func_70093_af()) {
                return false;
            }
            if (this.handleConduitClick(world, x, y, z, player, bundle, stack)) {
                return true;
            }
        } else if (ConduitUtil.isProbeEquipped(player) ? this.handleConduitProbeClick(world, x, y, z, player, bundle, stack) : ToolUtil.isToolEquipped(player) && player.func_70093_af() && this.handleWrenchClick(world, x, y, z, player)) {
            return true;
        }
        RaytraceResult closest = this.doRayTrace(world, x, y, z, player);
        List<RaytraceResult> all = null;
        if (closest != null) {
            all = this.doRayTraceAll(world, x, y, z, player);
        }
        if (closest != null && closest.component != null && closest.component.data instanceof ConduitConnectorType) {
            Object conType = (ConduitConnectorType)((Object)closest.component.data);
            if (conType == ConduitConnectorType.INTERNAL) {
                boolean result = false;
                for (IConduit con : bundle.getConduits()) {
                    if (!ConduitUtil.renderConduit(player, con.getCollidableType()) || !con.onBlockActivated(player, this.getHitForConduitType(all, con.getCollidableType()), all)) continue;
                    bundle.getEntity().func_70296_d();
                    result = true;
                }
                if (result) {
                    return true;
                }
            } else {
                if (!world.field_72995_K) {
                    player.openGui((Object)EnderIO.instance, 9 + closest.component.dir.ordinal(), world, x, y, z);
                }
                return true;
            }
        }
        if (closest == null || closest.component == null || closest.component.conduitType == null && all == null) {
            return false;
        }
        if (all != null) {
            RaytraceResult.sort(Util.getEyePosition((EntityPlayer)player), all);
            for (RaytraceResult rr : all) {
                IConduit con;
                if (!ConduitUtil.renderConduit(player, rr.component.conduitType) || rr.component.data instanceof ConduitConnectorType || (con = bundle.getConduit(rr.component.conduitType)) == null || !con.onBlockActivated(player, rr, all)) continue;
                bundle.getEntity().func_70296_d();
                return true;
            }
        } else {
            IConduit closestConduit = bundle.getConduit(closest.component.conduitType);
            if (closestConduit != null && ConduitUtil.renderConduit(player, closestConduit) && closestConduit.onBlockActivated(player, closest, all)) {
                bundle.getEntity().func_70296_d();
                return true;
            }
        }
        return false;
    }

    private boolean handleWrenchClick(World world, int x, int y, int z, EntityPlayer player) {
        ITool tool = ToolUtil.getEquippedTool(player);
        if (tool != null && tool.canUse(player.func_71045_bC(), player, new BlockPos(x, y, z))) {
            if (!world.field_72995_K) {
                this.removedByPlayer(world, new BlockPos(x, y, z), player, true);
                tool.used(player.func_71045_bC(), player, new BlockPos(x, y, z));
            }
            return true;
        }
        return false;
    }

    private boolean handleConduitProbeClick(World world, int x, int y, int z, EntityPlayer player, IConduitBundle bundle, ItemStack stack) {
        if (stack.func_77952_i() != 1) {
            return false;
        }
        RaytraceResult rr = this.doRayTrace(world, x, y, z, player);
        if (rr == null || rr.component == null) {
            return false;
        }
        return ItemConduitProbe.copyPasteSettings(player, stack, bundle, rr.component.dir);
    }

    private boolean handleConduitClick(World world, int x, int y, int z, EntityPlayer player, IConduitBundle bundle, ItemStack stack) {
        IConduitItem equipped = (IConduitItem)stack.func_77973_b();
        if (!bundle.hasType(equipped.getBaseConduitType())) {
            if (!world.field_72995_K) {
                bundle.addConduit(equipped.createConduit(stack, player));
                ConduitUtil.playBreakSound(field_149777_j, world, x, y, z);
                if (!player.field_71075_bZ.field_75098_d) {
                    --player.func_71045_bC().field_77994_a;
                }
            }
            return true;
        }
        return false;
    }

    public boolean handleFacadeClick(World world, BlockPos pos, EntityPlayer player, EnumFacing side, IConduitBundle bundle, ItemStack stack) {
        if (player.func_70093_af()) {
            return false;
        }
        IBlockState facadeID = PainterUtil2.getSourceBlock(player.func_71045_bC());
        if (facadeID == null) {
            return false;
        }
        int facadeType = player.func_71045_bC().func_77952_i();
        if (bundle.hasFacade()) {
            if (!ConduitUtil.isSolidFacadeRendered(bundle, player) || this.facadeEquals(bundle, facadeID, facadeType)) {
                return false;
            }
            if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                ItemStack fac = new ItemStack((Block)EnderIO.blockConduitFacade, 1, bundle.getFacadeType().ordinal());
                PainterUtil2.setSourceBlock(fac, bundle.getPaintSource());
                Util.dropItems((World)world, (ItemStack)fac, (BlockPos)pos, (boolean)false);
            }
        }
        bundle.setPaintSource(facadeID);
        bundle.setFacadeType(EnumFacadeType.getTypeFromMeta(facadeType));
        if (!world.field_72995_K) {
            ConduitUtil.playPlaceSound(facadeID.func_177230_c().field_149762_H, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
        world.func_175689_h(pos);
        bundle.getEntity().func_70296_d();
        return true;
    }

    private boolean facadeEquals(IConduitBundle bundle, IBlockState b, int facadeType) {
        IBlockState a = bundle.getPaintSource();
        if (a == null) {
            return false;
        }
        if (a.func_177230_c() != b.func_177230_c()) {
            return false;
        }
        return a.func_177230_c().func_176201_c(a) == b.func_177230_c().func_176201_c(b);
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id == 16) {
            return null;
        }
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof IConduitBundle) {
            return new ExternalConnectionContainer(player.field_71071_by, (IConduitBundle)te, EnumFacing.values()[id - 9]);
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof IConduitBundle) {
            if (id == 16) {
                return new GuiExternalConnectionSelector((IConduitBundle)te);
            }
            return new GuiExternalConnection(player.field_71071_by, (IConduitBundle)te, EnumFacing.values()[id - 9]);
        }
        return null;
    }

    private RaytraceResult getHitForConduitType(List<RaytraceResult> all, Class<? extends IConduit> collidableType) {
        for (RaytraceResult rr : all) {
            if (rr.component == null || rr.component.conduitType != collidableType) continue;
            return rr;
        }
        return null;
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IConduitBundle) {
            ((IConduitBundle)tile).onNeighborBlockChange(neighborBlock);
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity conduit = world.func_175625_s(pos);
        if (conduit instanceof IConduitBundle) {
            ((IConduitBundle)conduit).onNeighborChange(world, null, null);
        }
    }

    public void func_180638_a(World world, BlockPos pos, IBlockState state, AxisAlignedBB axisalignedbb, List<AxisAlignedBB> arraylist, Entity par7Entity) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof IConduitBundle)) {
            return;
        }
        IConduitBundle con = (IConduitBundle)te;
        if (con.hasFacade()) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            super.func_180638_a(world, pos, state, axisalignedbb, arraylist, par7Entity);
        } else {
            List<CollidableComponent> bounds = con.getCollidableComponents();
            for (CollidableComponent bnd : bounds) {
                this.func_149676_a(bnd.bound.minX, bnd.bound.minY, bnd.bound.minZ, bnd.bound.maxX, bnd.bound.maxY, bnd.bound.maxZ);
                super.func_180638_a(world, pos, state, axisalignedbb, arraylist, par7Entity);
            }
            if (con.getConduits().isEmpty()) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                super.func_180638_a(world, pos, state, axisalignedbb, arraylist, par7Entity);
            }
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180646_a(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (!(te instanceof IConduitBundle)) {
            return null;
        }
        IConduitBundle con = (IConduitBundle)te;
        BoundingBox minBB = new BoundingBox(1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        if (!ConduitUtil.isSolidFacadeRendered(con, EnderIO.proxy.getClientPlayer())) {
            RaytraceResult hit;
            List<RaytraceResult> results = this.doRayTraceAll(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (EntityPlayer)player);
            Iterator<RaytraceResult> iter = results.iterator();
            while (iter.hasNext()) {
                CollidableComponent component = iter.next().component;
                if (component != null && (component.conduitType != null || component.data == ConduitConnectorType.EXTERNAL)) continue;
                iter.remove();
            }
            for (RaytraceResult hit2 : results) {
                IInsulatedRedstoneConduit cond = con.getConduit(IInsulatedRedstoneConduit.class);
                if (cond == null || hit2.component == null || !cond.getExternalConnections().contains(hit2.component.dir) || cond.isSpecialConnection(hit2.component.dir) || hit2.component.data != "ColorController") continue;
                minBB = hit2.component.bound;
            }
            if (!minBB.isValid() && (hit = RaytraceResult.getClosestHit(Util.getEyePosition((EntityPlayer)player), results)) != null && hit.component != null && hit.component.bound != null) {
                minBB = hit.component.bound;
                if (hit.component.conduitType == null) {
                    EnumFacing dir = hit.component.dir.func_176734_d();
                    float trans = 0.0125f;
                    minBB = minBB.translate((float)dir.func_82601_c() * trans, (float)dir.func_96559_d() * trans, (float)dir.func_82599_e() * trans);
                    float scale = 0.7f;
                    minBB = minBB.scale(1.0f + (float)Math.abs(dir.func_82601_c()) * scale, 1.0f + (float)Math.abs(dir.func_96559_d()) * scale, 1.0f + (float)Math.abs(dir.func_82599_e()) * scale);
                } else {
                    minBB = minBB.scale(1.09, 1.09, 1.09);
                }
            }
        } else {
            minBB = new BoundingBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        if (!minBB.isValid()) {
            minBB = new BoundingBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        return new AxisAlignedBB((double)((float)pos.func_177958_n() + minBB.minX), (double)((float)pos.func_177956_o() + minBB.minY), (double)((float)pos.func_177952_p() + minBB.minZ), (double)((float)pos.func_177958_n() + minBB.maxX), (double)((float)pos.func_177956_o() + minBB.maxY), (double)((float)pos.func_177952_p() + minBB.maxZ));
    }

    public MovingObjectPosition func_180636_a(World world, BlockPos pos, Vec3 origin, Vec3 direction) {
        RaytraceResult raytraceResult = this.doRayTrace(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), origin, direction, null);
        MovingObjectPosition ret = null;
        if (raytraceResult != null && (ret = raytraceResult.movingObjectPosition) != null) {
            ret.hitInfo = raytraceResult.component;
        }
        return ret;
    }

    public RaytraceResult doRayTrace(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        List<RaytraceResult> allHits = this.doRayTraceAll(world, x, y, z, entityPlayer);
        if (allHits == null) {
            return null;
        }
        Vec3 origin = Util.getEyePosition((EntityPlayer)entityPlayer);
        return RaytraceResult.getClosestHit(origin, allHits);
    }

    public List<RaytraceResult> doRayTraceAll(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        double pitch = Math.toRadians(entityPlayer.field_70125_A);
        double yaw = Math.toRadians(entityPlayer.field_70177_z);
        double dirX = -Math.sin(yaw) * Math.cos(pitch);
        double dirY = -Math.sin(pitch);
        double dirZ = Math.cos(yaw) * Math.cos(pitch);
        double reachDistance = EnderIO.proxy.getReachDistanceForPlayer(entityPlayer);
        Vec3 origin = Util.getEyePosition((EntityPlayer)entityPlayer);
        Vec3 direction = origin.func_72441_c(dirX * reachDistance, dirY * reachDistance, dirZ * reachDistance);
        return this.doRayTraceAll(world, x, y, z, origin, direction, entityPlayer);
    }

    private RaytraceResult doRayTrace(World world, int x, int y, int z, Vec3 origin, Vec3 direction, EntityPlayer entityPlayer) {
        List<RaytraceResult> allHits = this.doRayTraceAll(world, x, y, z, origin, direction, entityPlayer);
        if (allHits == null) {
            return null;
        }
        return RaytraceResult.getClosestHit(origin, allHits);
    }

    protected List<RaytraceResult> doRayTraceAll(World world, int x, int y, int z, Vec3 origin, Vec3 direction, EntityPlayer player) {
        BlockPos pos = new BlockPos(x, y, z);
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof IConduitBundle)) {
            return null;
        }
        IConduitBundle bundle = (IConduitBundle)te;
        ArrayList<RaytraceResult> hits = new ArrayList<RaytraceResult>();
        if (player == null) {
            player = EnderIO.proxy.getClientPlayer();
        }
        if (ConduitUtil.isSolidFacadeRendered(bundle, player)) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            MovingObjectPosition hitPos = super.func_180636_a(world, pos, origin, direction);
            if (hitPos != null) {
                hits.add(new RaytraceResult(new CollidableComponent(null, BoundingBox.UNIT_CUBE, null, null), hitPos));
            }
        } else {
            ConduitDisplayMode mode = ConduitUtil.getDisplayMode(player);
            ArrayList<CollidableComponent> components = new ArrayList<CollidableComponent>(bundle.getCollidableComponents());
            for (CollidableComponent component : components) {
                if (component.conduitType == null && mode != ConduitDisplayMode.ALL || !ConduitUtil.renderConduit(player, component.conduitType)) continue;
                this.func_149676_a(component.bound.minX, component.bound.minY, component.bound.minZ, component.bound.maxX, component.bound.maxY, component.bound.maxZ);
                MovingObjectPosition hitPos = super.func_180636_a(world, pos, origin, direction);
                if (hitPos == null) continue;
                hits.add(new RaytraceResult(component, hitPos));
            }
            if (bundle.getConduits().isEmpty() && !ConduitUtil.isFacadeHidden(bundle, player)) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                MovingObjectPosition hitPos = super.func_180636_a(world, pos, origin, direction);
                if (hitPos != null) {
                    hits.add(new RaytraceResult(null, hitPos));
                }
            }
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return hits;
    }

    private static IRedstoneConduit getRedstoneConduit(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof IConduitBundle)) {
            return null;
        }
        IConduitBundle bundle = (IConduitBundle)te;
        return bundle.getConduit(IRedstoneConduit.class);
    }

    @Override
    public void setPaintSource(IBlockState state, IBlockAccess world, BlockPos pos, IBlockState paintSource) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            ((IPaintable.IPaintableTileEntity)te).setPaintSource(paintSource);
        }
    }

    @Override
    public void setPaintSource(Block block, ItemStack stack, IBlockState paintSource) {
        PainterUtil2.setSourceBlock(stack, paintSource);
    }

    @Override
    public IBlockState getPaintSource(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            return ((IPaintable.IPaintableTileEntity)te).getPaintSource();
        }
        return null;
    }

    @Override
    public IBlockState getPaintSource(Block block, ItemStack stack) {
        return PainterUtil2.getSourceBlock(stack);
    }

    @Override
    public IBlockState getFacade(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.getPaintSource(this.func_176223_P(), world, pos);
    }

    public boolean canRenderInLayer(EnumWorldBlockLayer layer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        if (tab != null) {
            super.func_149666_a(itemIn, tab, list);
        }
    }
}

