/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.Util;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.IHaveRenderers;
import crazypants.enderio.IModObject;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.IConduitItem;
import crazypants.enderio.conduit.ItemConduitSubtype;
import crazypants.util.ClientUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractItemConduit
extends Item
implements IConduitItem,
IHaveRenderers {
    protected IModObject modObj;
    protected ItemConduitSubtype[] subtypes;

    protected AbstractItemConduit(IModObject modObj, ItemConduitSubtype ... subtypes) {
        this.modObj = modObj;
        this.subtypes = subtypes;
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.func_77655_b(modObj.getUnlocalisedName());
        this.func_77625_d(64);
        this.func_77627_a(true);
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)this.modObj.getUnlocalisedName());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers() {
        for (int i = 0; i < this.subtypes.length; ++i) {
            ClientUtil.regRenderer((Item)this, i, new ResourceLocation(this.subtypes[i].modelLocation));
        }
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        BlockCoord placeAt = Util.canPlaceItem((ItemStack)stack, (Block)EnderIO.blockConduitBundle, (EntityPlayer)player, (World)world, (BlockPos)pos, (EnumFacing)side);
        if (placeAt != null) {
            TileEntity te;
            if (!world.field_72995_K && world.func_180501_a(placeAt.getBlockPos(), EnderIO.blockConduitBundle.func_176223_P(), 1) && (te = world.func_175625_s(placeAt.getBlockPos())) instanceof IConduitBundle) {
                IConduitBundle bundle = (IConduitBundle)te;
                bundle.addConduit(this.createConduit(stack, player));
                ConduitUtil.playBreakSound(Block.field_149777_j, world, placeAt.x, placeAt.y, placeAt.z);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return true;
        }
        BlockPos place = pos.func_177972_a(side);
        if (world.func_180495_p(place).func_177230_c() == EnderIO.blockConduitBundle) {
            IConduitBundle bundle = (IConduitBundle)world.func_175625_s(place);
            if (bundle == null) {
                System.out.println("AbstractItemConduit.onItemUse: Bundle null");
                return false;
            }
            if (!bundle.hasType(this.getBaseConduitType())) {
                if (!world.field_72995_K) {
                    IConduit con = this.createConduit(stack, player);
                    if (con == null) {
                        System.out.println("AbstractItemConduit.onItemUse: Conduit null.");
                        return false;
                    }
                    bundle.addConduit(con);
                    ConduitUtil.playBreakSound(Block.field_149777_j, world, place.func_177958_n(), place.func_177956_o(), place.func_177952_p());
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof IConduitBundle)) {
            return false;
        }
        IConduitBundle bundle = (IConduitBundle)te;
        Object existingConduit = bundle.getConduit(this.getBaseConduitType());
        if (existingConduit == null) {
            return false;
        }
        ItemStack existingConduitAsItemStack = existingConduit.createItem();
        if (!ItemUtil.areStacksEqual((ItemStack)existingConduitAsItemStack, (ItemStack)stack)) {
            if (!world.field_72995_K) {
                IConduit newConduit = this.createConduit(stack, player);
                if (newConduit == null) {
                    System.out.println("AbstractItemConduit.onItemUse: Conduit null.");
                    return false;
                }
                bundle.removeConduit((IConduit)existingConduit);
                bundle.addConduit(newConduit);
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                    for (ItemStack drop : existingConduit.getDrops()) {
                        if (player.field_71071_by.func_70441_a(drop)) continue;
                        ItemUtil.spawnItemInWorldWithRandomMotion((World)world, (ItemStack)drop, (BlockPos)pos);
                    }
                    player.field_71069_bz.func_75142_b();
                }
                return true;
            }
            player.func_71038_i();
        }
        return false;
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        int i = MathHelper.func_76125_a((int)par1ItemStack.func_77952_i(), (int)0, (int)(this.subtypes.length - 1));
        return this.subtypes[i].unlocalisedName;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int j = 0; j < this.subtypes.length; ++j) {
            par3List.add(new ItemStack((Item)this, 1, j));
        }
    }
}

