/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.capacitor;

import crazypants.enderio.EnderIO;
import crazypants.enderio.capacitor.ICapacitorData;
import crazypants.enderio.capacitor.ICapacitorKey;
import net.minecraft.util.ResourceLocation;

public enum DefaultCapacitorData implements ICapacitorData
{
    BASIC_CAPACITOR("basicCapacitor", 1),
    ACTIVATED_CAPACITOR("activatedCapacitor", 2),
    ENDER_CAPACITOR("enderCapacitor", 3);

    private final String unlocalizedName;
    private final int baselevel;

    private DefaultCapacitorData(String unlocalizedName, int baselevel) {
        this.unlocalizedName = unlocalizedName;
        this.baselevel = baselevel;
    }

    @Override
    public String getUnlocalizedName() {
        return EnderIO.DOMAIN + "." + this.unlocalizedName;
    }

    @Override
    public String getLocalizedName() {
        return EnderIO.lang.localize(this.unlocalizedName + ".name");
    }

    @Override
    public float getUnscaledValue(ICapacitorKey key) {
        return this.baselevel;
    }

    public static ResourceLocation[] getResourceLocations() {
        ResourceLocation[] result = new ResourceLocation[DefaultCapacitorData.values().length];
        for (int i = 0; i < DefaultCapacitorData.values().length; ++i) {
            result[i] = new ResourceLocation(EnderIO.DOMAIN, DefaultCapacitorData.values()[i].unlocalizedName);
        }
        return result;
    }

    @Override
    public int getBaseLevel() {
        return this.baselevel;
    }
}

