/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.capacitor;

import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.capacitor.ICapacitorData;
import crazypants.enderio.capacitor.ICapacitorDataItem;
import crazypants.enderio.capacitor.NBTCapacitorData;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class CapacitorHelper {
    private CapacitorHelper() {
    }

    public static ICapacitorData getCapacitorDataFromItemStack(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        Item item = stack.func_77973_b();
        if (item == null) {
            return null;
        }
        ICapacitorData capData = CapacitorHelper.getNBTCapacitorDataFromItemStack(stack, item);
        if (capData != null) {
            return capData;
        }
        if (item instanceof ICapacitorDataItem) {
            return ((ICapacitorDataItem)item).getCapacitorData(stack);
        }
        return null;
    }

    protected static ICapacitorData getNBTCapacitorDataFromItemStack(ItemStack stack, Item item) {
        if (!stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound nbtRoot = stack.func_77978_p();
        if (!nbtRoot.func_150297_b("eiocap", 10)) {
            return null;
        }
        NBTTagCompound nbtTag = nbtRoot.func_74775_l("eiocap");
        if (!nbtTag.func_150297_b("level", 99)) {
            return null;
        }
        int capLevel = nbtTag.func_74762_e("level");
        if (capLevel <= 0 || capLevel > 99) {
            return null;
        }
        return new NBTCapacitorData(item.func_77667_c(stack), capLevel, nbtTag);
    }

    public static ItemStack addCapData(ItemStack stack, CapacitorKey key, float value) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound root = stack.func_77978_p();
        NBTTagCompound tag = root.func_74775_l("eiocap");
        root.func_74782_a("eiocap", (NBTBase)tag);
        if (key == null) {
            tag.func_74768_a("level", (int)value);
        } else {
            tag.func_74776_a(key.getName(), value);
        }
        return stack;
    }
}

