/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.statements;

import buildcraft.api.gates.IGate;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.transport.PipeWire;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.core.statements.BCStatement;
import buildcraft.transport.Pipe;
import buildcraft.transport.statements.TriggerParameterSignal;
import java.util.Locale;

public class TriggerPipeSignal
extends BCStatement
implements ITriggerInternal {
    boolean active;
    PipeWire color;

    public TriggerPipeSignal(boolean active, PipeWire color) {
        super("buildcraft:pipe.wire.input." + color.name().toLowerCase(Locale.ENGLISH) + (active ? ".active" : ".inactive"), "buildcraft.pipe.wire.input." + color.name().toLowerCase(Locale.ENGLISH) + (active ? ".active" : ".inactive"));
        this.setBuildCraftLocation("transport", "triggers/trigger_pipesignal_" + color.name().toLowerCase() + "_" + (active ? "active" : "inactive"));
        this.active = active;
        this.color = color;
    }

    @Override
    public int maxParameters() {
        return 3;
    }

    @Override
    public String getDescription() {
        return String.format(BCStringUtils.localize("gate.trigger.pipe.wire." + (this.active ? "active" : "inactive")), BCStringUtils.localize("color." + this.color.name().toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public boolean isTriggerActive(IStatementContainer container, IStatementParameter[] parameters) {
        if (!(container instanceof IGate)) {
            return false;
        }
        Pipe pipe = (Pipe)((IGate)container).getPipe();
        if (this.active ? pipe.signalStrength[this.color.ordinal()] == 0 : pipe.signalStrength[this.color.ordinal()] > 0) {
            return false;
        }
        for (IStatementParameter param : parameters) {
            if (param == null || !(param instanceof TriggerParameterSignal)) continue;
            TriggerParameterSignal signal = (TriggerParameterSignal)param;
            if (signal.color == null || !(signal.active ? pipe.signalStrength[signal.color.ordinal()] == 0 : pipe.signalStrength[signal.color.ordinal()] > 0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return new TriggerParameterSignal();
    }
}

