/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.statements;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.core.statements.BCStatement;
import java.util.Locale;

public class TriggerClockTimer
extends BCStatement
implements ITriggerInternal {
    public final Time time;

    public TriggerClockTimer(Time time) {
        super("buildcraft:timer." + time.name().toLowerCase(Locale.ENGLISH));
        this.setBuildCraftLocation("transport", "triggers/trigger_timer_" + time.name().toLowerCase(Locale.ENGLISH));
        this.time = time;
    }

    @Override
    public String getDescription() {
        return String.format(BCStringUtils.localize("gate.trigger.timer"), this.time.delay);
    }

    @Override
    public boolean isTriggerActive(IStatementContainer source, IStatementParameter[] parameters) {
        return false;
    }

    public static enum Time {
        SHORT(5),
        MEDIUM(10),
        LONG(15);

        public static final Time[] VALUES;
        public final int delay;

        private Time(int delay) {
            this.delay = delay;
        }

        static {
            VALUES = Time.values();
        }
    }
}

