/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pluggable;

import buildcraft.BuildCraftTransport;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.lib.utils.MatrixTranformations;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.client.model.ModelKeyLens;
import buildcraft.transport.pipes.events.PipeEventItem;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LensPluggable
extends PipePluggable {
    public EnumDyeColor dyeColor;
    public boolean isFilter;
    protected IPipeTile container;
    private EnumFacing side;

    public LensPluggable() {
    }

    public LensPluggable(ItemStack stack) {
        this.dyeColor = EnumDyeColor.func_176764_b((int)(stack.func_77952_i() & 0xF));
        boolean bl = this.isFilter = stack.func_77952_i() >= 16;
        if (stack.func_77952_i() >= 32) {
            this.isFilter = stack.func_77952_i() == 33;
            this.dyeColor = null;
        }
    }

    @Override
    public void validate(IPipeTile pipe, EnumFacing direction) {
        this.container = pipe;
        this.side = direction;
    }

    @Override
    public void invalidate() {
        this.container = null;
        this.side = null;
    }

    @Override
    public ItemStack[] getDropItems(IPipeTile pipe) {
        int colourMeta = this.dyeColor == null ? (this.isFilter ? 33 : 32) : this.dyeColor.func_176765_a() | (this.isFilter ? 16 : 0);
        return new ItemStack[]{new ItemStack((Item)BuildCraftTransport.lensItem, 1, colourMeta)};
    }

    @Override
    public boolean isBlocking(IPipeTile pipe, EnumFacing direction) {
        return false;
    }

    @Override
    public AxisAlignedBB getBoundingBox(EnumFacing side) {
        float[][] bounds = new float[3][2];
        bounds[0][0] = 0.1875f;
        bounds[0][1] = 0.8125f;
        bounds[1][0] = 0.0f;
        bounds[1][1] = 0.125f;
        bounds[2][0] = 0.1875f;
        bounds[2][1] = 0.8125f;
        MatrixTranformations.transform(bounds, side);
        return new AxisAlignedBB((double)bounds[0][0], (double)bounds[1][0], (double)bounds[2][0], (double)bounds[0][1], (double)bounds[1][1], (double)bounds[2][1]);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelKeyLens getModelRenderKey(EnumWorldBlockLayer layer, EnumFacing side) {
        if (layer == EnumWorldBlockLayer.CUTOUT) {
            return new ModelKeyLens.Cutout(side, this.isFilter);
        }
        if (layer == EnumWorldBlockLayer.TRANSLUCENT) {
            return new ModelKeyLens.Translucent(side, this.isFilter, this.dyeColor);
        }
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.dyeColor = tag.func_74764_b("colour") ? NBTUtils.readEnum(tag.func_74781_a("colour"), EnumDyeColor.class) : EnumDyeColor.func_176764_b((int)tag.func_74771_c("c"));
        this.isFilter = tag.func_74767_n("f");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74782_a("colour", NBTUtils.writeEnum(this.dyeColor));
        tag.func_74757_a("f", this.isFilter);
    }

    @Override
    public void writeData(ByteBuf data) {
        int col = this.dyeColor == null ? 0 : this.dyeColor.func_176765_a() + 1;
        data.writeByte(col & 0x1F | (this.isFilter ? 32 : 0));
    }

    @Override
    public void readData(ByteBuf data) {
        short flags = data.readUnsignedByte();
        int col = flags & 0x1F;
        this.dyeColor = col == 0 ? null : EnumDyeColor.func_176764_b((int)(col - 1));
        this.isFilter = (flags & 0x20) > 0;
    }

    @Override
    public boolean requiresRenderUpdate(PipePluggable o) {
        LensPluggable other = (LensPluggable)o;
        return other.dyeColor != this.dyeColor || other.isFilter != this.isFilter;
    }

    private void color(TravelingItem item) {
        if (item.toCenter && item.input.func_176734_d() == this.side || !item.toCenter && item.output == this.side) {
            item.color = this.dyeColor;
        }
    }

    public void eventHandler(PipeEventItem.ReachedEnd event) {
        if (!this.isFilter) {
            this.color(event.item);
        }
    }

    public void eventHandler(PipeEventItem.Entered event) {
        if (!this.isFilter) {
            this.color(event.item);
        }
    }

    public EnumDyeColor getColour() {
        return this.dyeColor;
    }
}

