/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.properties.BuildCraftProperties;
import buildcraft.api.tools.IToolWrench;
import buildcraft.core.lib.TileBuffer;
import buildcraft.transport.Pipe;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public abstract class PipeLogicIron {
    protected final Pipe<?> pipe;
    private boolean lastPower = false;

    public PipeLogicIron(Pipe<?> pipe) {
        this.pipe = pipe;
    }

    public void switchOnRedstone() {
        boolean currentPower;
        boolean bl = currentPower = this.pipe.container.func_145831_w().func_175687_A(this.pipe.container.func_174877_v()) > 0;
        if (currentPower != this.lastPower) {
            this.switchPosition();
            this.lastPower = currentPower;
        }
    }

    private void switchPosition() {
        int meta = this.pipe.container.func_145832_p();
        for (int i = meta + 1; i <= meta + 6; ++i) {
            EnumFacing facing = EnumFacing.func_82600_a((int)(i % 6));
            if (!this.setFacing(facing)) continue;
            return;
        }
    }

    private boolean isValidFacing(EnumFacing side) {
        if (!this.pipe.container.isPipeConnected(side)) {
            return false;
        }
        if (side == null) {
            return true;
        }
        TileBuffer[] tileBuffer = this.pipe.container.getTileCache();
        if (tileBuffer == null) {
            return true;
        }
        if (!tileBuffer[side.ordinal()].exists()) {
            return true;
        }
        TileEntity tile = tileBuffer[side.ordinal()].getTile();
        return this.isValidOutputTile(tile);
    }

    protected boolean isValidOutputTile(TileEntity tile) {
        return (!(tile instanceof IInventory) || ((IInventory)tile).func_70297_j_() != 0) && this.isValidConnectingTile(tile);
    }

    protected abstract boolean isValidConnectingTile(TileEntity var1);

    public void initialize() {
        this.lastPower = this.pipe.container.func_145831_w().func_175687_A(this.pipe.container.func_174877_v()) > 0;
    }

    public void onBlockPlaced() {
        this.setFacing(null);
        this.switchPosition();
    }

    public boolean setFacing(EnumFacing facing) {
        IBlockState state;
        int oldOrdinal;
        int ordinal = facing == null ? 6 : facing.ordinal();
        if (ordinal != (oldOrdinal = ((Integer)(state = this.pipe.container.func_145831_w().func_180495_p(this.pipe.container.func_174877_v())).func_177229_b(BuildCraftProperties.GENERIC_PIPE_DATA)).intValue()) && this.isValidFacing(facing)) {
            this.pipe.container.func_145831_w().func_175656_a(this.pipe.container.func_174877_v(), state.func_177226_a(BuildCraftProperties.GENERIC_PIPE_DATA, (Comparable)Integer.valueOf(ordinal)));
            this.pipe.container.scheduleRenderUpdate();
            return true;
        }
        return false;
    }

    public boolean blockActivated(EntityPlayer entityplayer, EnumPipePart side) {
        Item equipped;
        Item item = equipped = entityplayer.func_71045_bC() != null ? entityplayer.func_71045_bC().func_77973_b() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(entityplayer, this.pipe.container.func_174877_v())) {
            if (side == EnumPipePart.CENTER || !this.pipe.getContainer().isPipeConnected(side.face)) {
                this.switchPosition();
            } else {
                this.setFacing(side.face);
            }
            this.pipe.container.scheduleRenderUpdate();
            ((IToolWrench)equipped).wrenchUsed(entityplayer, this.pipe.container.func_174877_v());
            return true;
        }
        return false;
    }

    public EnumFacing getOutputDirection() {
        return EnumFacing.func_82600_a((int)this.pipe.container.func_145832_p());
    }

    public boolean outputOpen(EnumFacing to) {
        return to.ordinal() == this.pipe.container.func_145832_p();
    }
}

