/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.StatementSlot;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.IStripesHandler;
import buildcraft.api.transport.IStripesPipe;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.core.lib.utils.BlockUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.pipes.events.PipeEventItem;
import buildcraft.transport.statements.ActionPipeDirection;
import buildcraft.transport.utils.TransportUtils;
import cofh.api.energy.IEnergyReceiver;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.IFluidBlock;

public class PipeItemsStripes
extends Pipe<PipeTransportItems>
implements IEnergyReceiver,
IStripesPipe {
    private RFBattery battery = new RFBattery(16000, 640, 0);
    private EnumPipePart actionDir = EnumPipePart.CENTER;

    public PipeItemsStripes(Item item) {
        super(new PipeTransportItems(), item);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.container.func_145831_w().field_72995_K) {
            return;
        }
        if (this.battery.getEnergyStored() >= 10) {
            EnumPipePart o = this.actionDir;
            if (o == EnumPipePart.CENTER) {
                o = EnumPipePart.fromFacing(this.getOpenOrientation());
            }
            if (o != EnumPipePart.CENTER) {
                Vec3 vec = Utils.convert((Vec3i)this.container.func_174877_v()).func_178787_e(Utils.convert(o.face));
                BlockPos veci = Utils.convertFloor(vec);
                if (!BlockUtils.isUnbreakableBlock(this.getWorld(), Utils.convertFloor(vec))) {
                    IBlockState state = this.getWorld().func_180495_p(Utils.convertFloor(vec));
                    Block block = state.func_177230_c();
                    if (block instanceof BlockLiquid || block instanceof IFluidBlock) {
                        return;
                    }
                    ItemStack stack = new ItemStack(block, 1, block.func_176201_c(state));
                    EntityPlayer player = (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.getWorld(), veci).get();
                    if (this.battery.useEnergy(10, 10, false) != 10) {
                        return;
                    }
                    for (IStripesHandler handler : PipeManager.stripesHandlers) {
                        if (handler.getType() != IStripesHandler.StripesHandlerType.BLOCK_BREAK || !handler.shouldHandle(stack) || !handler.handle(this.getWorld(), veci, o.face, stack, player, this)) continue;
                        return;
                    }
                    List stacks = block.getDrops((IBlockAccess)this.getWorld(), veci, state, 0);
                    if (stacks != null) {
                        for (ItemStack s : stacks) {
                            if (s == null) continue;
                            this.sendItem(s, o.opposite().face);
                        }
                    }
                    this.getWorld().func_175698_g(veci);
                }
            }
            return;
        }
    }

    public void eventHandler(PipeEventItem.DropItem event) {
        if (this.container.func_145831_w().field_72995_K) {
            return;
        }
        EnumFacing direction = this.actionDir.face;
        if (direction == null) {
            direction = event.direction;
        }
        Vec3 p = Utils.convert((Vec3i)this.container.func_174877_v()).func_178787_e(Utils.convert(direction));
        ItemStack stack = event.entity.func_92059_d();
        EntityPlayer player = (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.getWorld(), Utils.convertFloor(p)).get();
        switch (direction) {
            case DOWN: {
                player.field_70125_A = 90.0f;
                player.field_70177_z = 0.0f;
                break;
            }
            case UP: {
                player.field_70125_A = 270.0f;
                player.field_70177_z = 0.0f;
                break;
            }
            case NORTH: {
                player.field_70125_A = 0.0f;
                player.field_70177_z = 180.0f;
                break;
            }
            case SOUTH: {
                player.field_70125_A = 0.0f;
                player.field_70177_z = 0.0f;
                break;
            }
            case WEST: {
                player.field_70125_A = 0.0f;
                player.field_70177_z = 90.0f;
                break;
            }
            case EAST: {
                player.field_70125_A = 0.0f;
                player.field_70177_z = 270.0f;
            }
        }
        for (IStripesHandler handler : PipeManager.stripesHandlers) {
            if (handler.getType() != IStripesHandler.StripesHandlerType.ITEM_USE || !handler.shouldHandle(stack) || !handler.handle(this.getWorld(), Utils.convertFloor(p), direction, stack, player, this)) continue;
            event.entity = null;
            return;
        }
    }

    @Override
    public void dropItem(ItemStack itemStack, EnumFacing direction) {
        Vec3 p = Utils.convert((Vec3i)this.container.func_174877_v()).func_178787_e(Utils.convert(direction));
        InvUtils.dropItems(this.getWorld(), itemStack, Utils.convertFloor(p));
    }

    @Override
    public LinkedList<IActionInternal> getActions() {
        LinkedList<IActionInternal> action = super.getActions();
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            if (this.container.isPipeConnected(direction)) continue;
            action.add(BuildCraftTransport.actionPipeDirection[direction.ordinal()]);
        }
        return action;
    }

    @Override
    protected void actionsActivated(Collection<StatementSlot> actions) {
        super.actionsActivated(actions);
        this.actionDir = EnumPipePart.CENTER;
        for (StatementSlot action : actions) {
            if (!(action.statement instanceof ActionPipeDirection)) continue;
            this.actionDir = EnumPipePart.fromFacing(((ActionPipeDirection)action.statement).direction);
            break;
        }
    }

    @Override
    public void sendItem(ItemStack stack, EnumFacing direction) {
        Vec3 pos = Utils.convertMiddle((Vec3i)this.container.func_174877_v()).func_72441_c(0.0, (double)TransportUtils.getPipeFloorOf(stack) - 0.5, 0.0);
        pos = pos.func_178787_e(Utils.convert(direction, 0.25));
        TravelingItem newItem = TravelingItem.make(pos, stack);
        ((PipeTransportItems)this.transport).injectItem(newItem, direction);
    }

    @Override
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(EnumFacing direction) {
        return PipeIconProvider.TYPE.PipeItemsStripes.ordinal();
    }

    @Override
    public boolean canPipeConnect(TileEntity tile, EnumFacing side) {
        IPipeTile tilePipe;
        if (tile instanceof IPipeTile && (tilePipe = (IPipeTile)tile).getPipe() instanceof PipeItemsStripes) {
            return false;
        }
        return super.canPipeConnect(tile, side);
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.battery.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return 0;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return 10;
    }
}

