/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.properties.BuildCraftProperties;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.StatementSlot;
import buildcraft.api.tools.IToolWrench;
import buildcraft.core.lib.utils.ColorUtils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.events.PipeEventItem;
import buildcraft.transport.statements.ActionPipeColor;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PipeItemsLapis
extends Pipe<PipeTransportItems> {
    public PipeItemsLapis(Item item) {
        super(new PipeTransportItems(), item);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(EnumFacing direction) {
        if (this.container == null) {
            return PipeIconProvider.TYPE.PipeItemsLapis_Black.ordinal();
        }
        return PipeIconProvider.TYPE.PipeItemsLapis_Black.ordinal() + this.container.func_145832_p();
    }

    @Override
    public boolean blockActivated(EntityPlayer player, EnumFacing direction) {
        Item equipped;
        Item item = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(player, this.container.func_174877_v())) {
            if (player.func_70093_af()) {
                this.setColor(ColorUtils.previous(this.getColor()));
            } else {
                this.setColor(ColorUtils.next(this.getColor()));
            }
            ((IToolWrench)equipped).wrenchUsed(player, this.container.func_174877_v());
            return true;
        }
        EnumDyeColor color = ColorUtils.getColorFromDye(player.func_71045_bC());
        if (color != null) {
            this.setColor(color);
        }
        return false;
    }

    public EnumDyeColor getColor() {
        return EnumDyeColor.func_176764_b((int)this.container.func_145832_p());
    }

    public void setColor(EnumDyeColor color) {
        IBlockState state = this.container.func_145831_w().func_180495_p(this.container.func_174877_v());
        if (color.ordinal() != ((Integer)state.func_177229_b(BuildCraftProperties.GENERIC_PIPE_DATA)).intValue()) {
            this.container.func_145831_w().func_175656_a(this.container.func_174877_v(), state.func_177226_a(BuildCraftProperties.GENERIC_PIPE_DATA, (Comparable)Integer.valueOf(color.ordinal())));
            this.container.scheduleRenderUpdate();
        }
    }

    public void eventHandler(PipeEventItem.ReachedCenter event) {
        event.item.color = this.getColor();
    }

    public void eventHandler(PipeEventItem.AdjustSpeed event) {
        event.slowdownAmount /= 4.0f;
    }

    @Override
    protected void actionsActivated(Collection<StatementSlot> actions) {
        super.actionsActivated(actions);
        for (StatementSlot action : actions) {
            if (!(action.statement instanceof ActionPipeColor)) continue;
            this.setColor(((ActionPipeColor)action.statement).color);
            break;
        }
    }

    @Override
    public LinkedList<IActionInternal> getActions() {
        LinkedList<IActionInternal> result = super.getActions();
        result.addAll(Arrays.asList(BuildCraftTransport.actionPipeColor));
        return result;
    }
}

