/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.EnumColor;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.ISerializable;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.StatementSlot;
import buildcraft.api.tools.IToolWrench;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.lib.utils.ColorUtils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.PipeItemsWood;
import buildcraft.transport.pipes.PipeLogicIron;
import buildcraft.transport.pipes.events.PipeEventItem;
import buildcraft.transport.statements.ActionPipeColor;
import buildcraft.transport.statements.ActionPipeDirection;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PipeItemsDaizuli
extends Pipe<PipeTransportItems>
implements ISerializable {
    private int standardIconIndex = PipeIconProvider.TYPE.PipeItemsDaizuli_Black.ordinal();
    private int solidIconIndex = PipeIconProvider.TYPE.PipeItemsDaizuli_Solid.ordinal();
    private int color = EnumColor.BLACK.ordinal();
    private PipeLogicIron logic = new PipeLogicIron(this){

        @Override
        protected boolean isValidConnectingTile(TileEntity tile) {
            if (tile instanceof IPipeTile) {
                Pipe otherPipe = (Pipe)((IPipeTile)tile).getPipe();
                if (otherPipe instanceof PipeItemsWood) {
                    return false;
                }
                return otherPipe.transport instanceof PipeTransportItems;
            }
            return tile instanceof IInventory;
        }
    };

    public PipeItemsDaizuli(Item item) {
        super(new PipeTransportItems(), item);
        ((PipeTransportItems)this.transport).allowBouncing = true;
    }

    public EnumDyeColor getColor() {
        return EnumDyeColor.func_176764_b((int)this.color);
    }

    public void setColor(EnumDyeColor c) {
        if (this.color != c.ordinal()) {
            this.color = c.ordinal();
            this.container.scheduleRenderUpdate();
        }
    }

    @Override
    public boolean blockActivated(EntityPlayer player, EnumFacing side) {
        EnumDyeColor color;
        if (player.func_70093_af()) {
            Item equipped;
            Item item = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
            if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(player, this.container.func_174877_v())) {
                this.setColor(ColorUtils.next(this.getColor()));
                ((IToolWrench)equipped).wrenchUsed(player, this.container.func_174877_v());
                return true;
            }
        }
        if ((color = ColorUtils.getColorFromDye(player.func_71045_bC())) != null) {
            this.setColor(color);
            return true;
        }
        return this.logic.blockActivated(player, EnumPipePart.fromFacing(side));
    }

    @Override
    public void onBlockPlaced() {
        this.logic.onBlockPlaced();
        super.onBlockPlaced();
    }

    @Override
    public void initialize() {
        this.logic.initialize();
        super.initialize();
    }

    @Override
    public int getIconIndexForItem() {
        return PipeIconProvider.TYPE.PipeItemsDaizuli_Solid.ordinal();
    }

    @Override
    public int getIconIndex(EnumFacing direction) {
        if (direction == null) {
            return PipeIconProvider.dazuliPipe.get(this.getColor()).ordinal();
        }
        if (this.container != null && this.container.func_145832_p() == direction.ordinal()) {
            return PipeIconProvider.dazuliPipe.get(this.getColor()).ordinal();
        }
        return PipeIconProvider.TYPE.PipeItemsDaizuli_Solid.ordinal();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    public void eventHandler(PipeEventItem.FindDest event) {
        EnumFacing output = EnumFacing.func_82600_a((int)this.container.func_145832_p());
        if (event.item.color == this.getColor() && event.destinations.contains(output)) {
            event.destinations.clear();
            event.destinations.add(output);
            return;
        }
        event.destinations.remove(output);
    }

    public void eventHandler(PipeEventItem.AdjustSpeed event) {
        event.slowdownAmount /= 4.0f;
    }

    @Override
    protected void actionsActivated(Collection<StatementSlot> actions) {
        super.actionsActivated(actions);
        for (StatementSlot action : actions) {
            if (!(action.statement instanceof ActionPipeColor)) continue;
            this.setColor(((ActionPipeColor)action.statement).color);
            break;
        }
        for (StatementSlot action : actions) {
            if (!(action.statement instanceof ActionPipeDirection)) continue;
            this.logic.setFacing(((ActionPipeDirection)action.statement).direction);
            break;
        }
    }

    @Override
    public LinkedList<IActionInternal> getActions() {
        LinkedList<IActionInternal> action = super.getActions();
        action.addAll(Arrays.asList(BuildCraftTransport.actionPipeColor));
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            if (!this.container.isPipeConnected(direction)) continue;
            action.add(BuildCraftTransport.actionPipeDirection[direction.ordinal()]);
        }
        return action;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74774_a("color", (byte)this.color);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.color = data.func_74771_c("color");
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeByte(this.color);
    }

    @Override
    public void readData(ByteBuf data) {
        this.color = data.readByte();
    }
}

