/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.network;

import buildcraft.core.lib.network.base.Packet;
import buildcraft.core.lib.utils.Utils;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TravelingItem;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class PacketPipeTransportTraveler
extends Packet {
    public BlockPos pos;
    private TravelingItem item;
    private boolean forceStackRefresh;
    private int entityId;
    private EnumFacing input;
    private EnumFacing output;
    private EnumDyeColor color;
    private Vec3 itemPos;
    private float speed;

    public PacketPipeTransportTraveler() {
    }

    public PacketPipeTransportTraveler(TileEntity tile, TravelingItem item, boolean forceStackRefresh) {
        super(tile.func_145831_w());
        this.item = item;
        this.forceStackRefresh = forceStackRefresh;
    }

    @Override
    public void writeData(ByteBuf data) {
        super.writeData(data);
        data.writeFloat((float)this.item.pos.field_72450_a);
        data.writeFloat((float)this.item.pos.field_72448_b);
        data.writeFloat((float)this.item.pos.field_72449_c);
        data.writeShort(this.item.id);
        int out = this.item.output == null ? 6 : this.item.output.ordinal();
        int in = this.item.input == null ? 6 : this.item.input.ordinal();
        byte flags = (byte)(out & 7 | (in & 7) << 3 | (this.forceStackRefresh ? 64 : 0));
        data.writeByte((int)flags);
        data.writeByte(this.item.color != null ? this.item.color.ordinal() : -1);
        data.writeFloat(this.item.getSpeed());
    }

    @Override
    public void readData(ByteBuf data) {
        super.readData(data);
        this.itemPos = new Vec3((double)data.readFloat(), (double)data.readFloat(), (double)data.readFloat());
        this.pos = Utils.convertFloor(this.itemPos);
        this.entityId = data.readShort();
        short flags = data.readUnsignedByte();
        int in = flags >> 3 & 7;
        this.input = in == 6 ? null : EnumFacing.func_82600_a((int)in);
        int out = flags & 7;
        this.output = out == 6 ? null : EnumFacing.func_82600_a((int)out);
        byte c = data.readByte();
        if (c != -1) {
            this.color = EnumDyeColor.func_176764_b((int)c);
        }
        this.speed = data.readFloat();
        this.forceStackRefresh = (flags & 0x40) > 0;
    }

    public int getTravelingEntityId() {
        return this.entityId;
    }

    public EnumFacing getInputOrientation() {
        return this.input;
    }

    public EnumFacing getOutputOrientation() {
        return this.output;
    }

    public EnumDyeColor getColor() {
        return this.color;
    }

    public Vec3 getItemPos() {
        return this.itemPos;
    }

    public float getSpeed() {
        return this.speed;
    }

    public boolean forceStackRefresh() {
        return this.forceStackRefresh;
    }

    @Override
    public void applyData(World world, EntityPlayer player) {
        if (!world.func_175667_e(this.pos)) {
            return;
        }
        TileEntity entity = world.func_175625_s(this.pos);
        if (!(entity instanceof TileGenericPipe)) {
            return;
        }
        TileGenericPipe pipe = (TileGenericPipe)entity;
        if (pipe.pipe == null) {
            return;
        }
        if (!(pipe.pipe.transport instanceof PipeTransportItems)) {
            return;
        }
        ((PipeTransportItems)pipe.pipe.transport).handleTravelerPacket(this);
    }
}

