/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.network;

import buildcraft.core.lib.network.base.Packet;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.transport.TravelingItem;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class PacketPipeTransportItemStack
extends Packet {
    private ItemStack stack;
    private int entityId;

    public PacketPipeTransportItemStack() {
    }

    public PacketPipeTransportItemStack(World world, int entityId, ItemStack stack) {
        super(world);
        this.entityId = entityId;
        this.stack = stack;
    }

    @Override
    public void writeData(ByteBuf data) {
        super.writeData(data);
        data.writeInt(this.entityId);
        NetworkUtils.writeStack(data, this.stack);
    }

    @Override
    public void readData(ByteBuf data) {
        super.readData(data);
        this.entityId = data.readInt();
        this.stack = NetworkUtils.readStack(data);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    @Override
    public void applyData(World world, EntityPlayer player) {
        TravelingItem item = TravelingItem.clientCache.get(this.entityId);
        if (item != null) {
            item.setItemStack(this.stack);
        }
    }
}

