/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gui;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.api.transport.IPipe;
import buildcraft.core.client.CoreIconProvider;
import buildcraft.core.lib.config.DetailedConfigOption;
import buildcraft.core.lib.config.OverridableConfigOption;
import buildcraft.core.lib.gui.AdvancedSlot;
import buildcraft.core.lib.gui.GuiAdvancedInterface;
import buildcraft.core.lib.gui.StatementParameterSlot;
import buildcraft.core.lib.gui.StatementSlot;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.transport.ActionActiveState;
import buildcraft.transport.Gate;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gui.ContainerGateInterface;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiGateInterface
extends GuiAdvancedInterface {
    public static final DetailedConfigOption OPTION_TRIGGERS_WIDE = new OverridableConfigOption("gui.gate", "picker.triggers.wide", "6");
    public static final DetailedConfigOption OPTION_ACTIONS_WIDE = new OverridableConfigOption("gui.gate", "picker.actions.wide", "6");
    public static final DetailedConfigOption OPTION_TRIGGERS_Y = new OverridableConfigOption("gui.gate", "picker.triggers.y", "8");
    public static final DetailedConfigOption OPTION_ACTIONS_Y = new OverridableConfigOption("gui.gate", "picker.actions.y", "8");
    IInventory playerInventory;
    private final ContainerGateInterface container = (ContainerGateInterface)this.field_147002_h;
    private final GuiGateInterface instance;
    private final IPipe pipe;
    private Gate gate;
    private boolean trigger;
    private int index = -1;
    private String tooltip = null;
    public int actionRows;
    public int triggerRows;
    public int lastActionRowSize;
    public int lastTriggerRowSize;

    public GuiGateInterface(EntityPlayer player, IPipe pipe) {
        super(new ContainerGateInterface(player, pipe), null, null);
        this.container.gateCallback = this;
        this.pipe = pipe;
        this.playerInventory = player.field_71071_by;
        this.instance = this;
    }

    public void setGate(Gate gate) {
        this.gate = gate;
        this.init();
    }

    public void init() {
        if (this.gate == null) {
            return;
        }
        this.field_146999_f = 176;
        this.field_147000_g = this.gate.material.guiHeight;
        int position = 0;
        this.slots.clear();
        if (this.gate.material == GateDefinition.GateMaterial.REDSTONE) {
            this.slots.add(new TriggerSlot(62, 26, this.pipe, 0));
            this.slots.add(new ActionSlot(98, 26, this.pipe, 0));
        } else if (this.gate.material == GateDefinition.GateMaterial.IRON) {
            this.slots.add(new TriggerSlot(62, 26, this.pipe, 0));
            this.slots.add(new TriggerSlot(62, 44, this.pipe, 1));
            this.slots.add(new ActionSlot(98, 26, this.pipe, 0));
            this.slots.add(new ActionSlot(98, 44, this.pipe, 1));
        } else if (this.gate.material == GateDefinition.GateMaterial.QUARTZ) {
            for (int i = 0; i < 2; ++i) {
                TriggerSlot ts = new TriggerSlot(44, 26 + i * 18, this.pipe, i);
                ActionSlot as = new ActionSlot(98, 26 + i * 18, this.pipe, i);
                this.slots.add(ts);
                this.slots.add(as);
                this.slots.add(new TriggerParameterSlot(62, 26 + i * 18, this.pipe, 0, ts));
                this.slots.add(new ActionParameterSlot(116, 26 + i * 18, this.pipe, 0, as));
            }
        } else if (this.gate.material == GateDefinition.GateMaterial.GOLD) {
            int k;
            for (k = 0; k < 4; ++k) {
                this.slots.add(new TriggerSlot(53, 26 + 18 * k, this.pipe, position));
                ++position;
            }
            for (k = 0; k < 4; ++k) {
                this.slots.add(new ActionSlot(107, 26 + 18 * k, this.pipe, position - 4));
                ++position;
            }
            for (k = 0; k < 4; ++k) {
                this.slots.add(new TriggerParameterSlot(71, 26 + 18 * k, this.pipe, 0, (TriggerSlot)this.slots.get(k)));
                ++position;
            }
        } else if (this.gate.material == GateDefinition.GateMaterial.DIAMOND) {
            int k;
            for (k = 0; k < 4; ++k) {
                this.slots.add(new TriggerSlot(8, 26 + 18 * k, this.pipe, position));
                this.slots.add(new TriggerSlot(98, 26 + 18 * k, this.pipe, ++position));
                ++position;
            }
            for (k = 0; k < 4; ++k) {
                this.slots.add(new ActionSlot(62, 26 + 18 * k, this.pipe, position - 8));
                this.slots.add(new ActionSlot(152, 26 + 18 * k, this.pipe, ++position - 8));
                ++position;
            }
            for (k = 0; k < 4; ++k) {
                this.slots.add(new TriggerParameterSlot(26, 26 + 18 * k, this.pipe, 0, (TriggerSlot)this.slots.get(position - 16)));
                this.slots.add(new TriggerParameterSlot(116, 26 + 18 * k, this.pipe, 0, (TriggerSlot)this.slots.get(++position - 16)));
                ++position;
            }
        } else if (this.gate.material == GateDefinition.GateMaterial.EMERALD) {
            for (int y = 0; y < 4; ++y) {
                int x;
                this.slots.add(new TriggerSlot(8, 26 + 18 * y, this.pipe, y));
                int lastPos = position++;
                for (x = 0; x < 3; ++x) {
                    this.slots.add(new TriggerParameterSlot(8 + 18 * (x + 1), 26 + 18 * y, this.pipe, x, (TriggerSlot)this.slots.get(lastPos)));
                    ++position;
                }
                this.slots.add(new ActionSlot(98, 26 + 18 * y, this.pipe, y));
                lastPos = position++;
                for (x = 0; x < 3; ++x) {
                    this.slots.add(new ActionParameterSlot(98 + 18 * (x + 1), 26 + 18 * y, this.pipe, x, (ActionSlot)this.slots.get(lastPos)));
                    ++position;
                }
            }
        }
        this.func_73866_w_();
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        if (this.gate == null) {
            return;
        }
        String name = this.container.getGateName();
        this.field_146289_q.func_78276_b(name, this.getCenteredOffset(name), 10, 0x404040);
        this.field_146289_q.func_78276_b(BCStringUtils.localize("gui.inventory"), 8, this.field_147000_g - 97, 0x404040);
        if (this.index == -1) {
            this.drawTooltipForSlotAt(mouseX, mouseY);
        }
        if (this.tooltip != null) {
            this.drawTooltip(this.tooltip, mouseX, mouseY);
        }
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        String desc;
        int pY;
        int pX;
        this.container.synchronize();
        if (this.gate == null) {
            return;
        }
        ResourceLocation texture = this.container.getGateGuiFile();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        for (AdvancedSlot slot : this.slots) {
            if (slot instanceof TriggerSlot) {
                boolean halfWidth;
                boolean bl = halfWidth = this.container.actionsState[((TriggerSlot)slot).slot] == ActionActiveState.Partial;
                if (this.container.actionsState[((TriggerSlot)slot).slot] == ActionActiveState.Deactivated) continue;
                this.field_146297_k.field_71446_o.func_110577_a(texture);
                this.func_73729_b(this.field_147003_i + slot.x + 17 + 18 * this.gate.material.numTriggerParameters, this.field_147009_r + slot.y + 6, 176, 18, halfWidth ? 9 : 18, 4);
                continue;
            }
            if (!(slot instanceof StatementParameterSlot)) continue;
            StatementParameterSlot paramSlot = (StatementParameterSlot)slot;
            Iterator<IStatement> statement = paramSlot.statementSlot;
            this.field_146297_k.field_71446_o.func_110577_a(texture);
            if (((StatementSlot)((Object)statement)).isDefined()) {
                if (!paramSlot.isAllowed()) {
                    this.func_73729_b(this.field_147003_i + slot.x - 1, this.field_147009_r + slot.y - 1, 176, 0, 18, 18);
                    continue;
                }
                if (!paramSlot.isRequired() || paramSlot.getParameter() != null) continue;
                this.func_73729_b(this.field_147003_i + slot.x - 1, this.field_147009_r + slot.y - 1, 176, 22, 18, 18);
                continue;
            }
            this.func_73729_b(this.field_147003_i + slot.x - 1, this.field_147009_r + slot.y - 1, 176, 0, 18, 18);
        }
        this.drawBackgroundSlots(x, y);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GL11.glDisable((int)2896);
        GlStateManager.func_179140_f();
        GL11.glEnable((int)3008);
        GlStateManager.func_179141_d();
        GL11.glEnable((int)3042);
        GlStateManager.func_179147_l();
        this.tooltip = null;
        int sX = 18;
        int sY = OPTION_TRIGGERS_Y.getAsInt();
        int width = OPTION_TRIGGERS_WIDE.getAsInt() * 18;
        this.triggerRows = 1;
        for (IStatement statement : this.container.getTriggerCollection(false)) {
            pX = this.field_147003_i - sX;
            pY = this.field_147009_r + sY;
            if (x > pX & x < pX + 16 && y > pY && y < pY + 16) {
                desc = statement.getDescription();
                this.tooltip = StatCollector.func_74838_a((String)desc);
            }
            this.drawStatement(pX, pY, statement);
            if (sX >= width) {
                sX = 18;
                sY += 18;
                ++this.triggerRows;
                continue;
            }
            this.lastTriggerRowSize = sX += 18;
        }
        width = OPTION_ACTIONS_WIDE.getAsInt() * 18;
        sX = 0;
        sY = OPTION_ACTIONS_Y.getAsInt();
        this.actionRows = 1;
        for (IStatement statement : this.container.getActionCollection(false)) {
            pX = this.field_147003_i + this.xSize() + sX;
            pY = this.field_147009_r + sY;
            this.drawStatement(pX, pY, statement);
            if (x > pX & x < pX + 16 && y > pY && y < pY + 16) {
                desc = statement.getDescription();
                this.tooltip = StatCollector.func_74838_a((String)desc);
            }
            if (sX >= width - 18) {
                sX = 0;
                sY += 18;
                ++this.actionRows;
                continue;
            }
            this.lastActionRowSize = sX += 18;
        }
        if (this.index != -1) {
            boolean isValid;
            Collection<IStatement> collect = this.trigger ? this.container.getTriggerCollection(false) : this.container.getActionCollection(false);
            IStatement state = null;
            Iterator<IStatement> it = collect.iterator();
            for (int i = this.index; i >= 0; --i) {
                state = it.next();
            }
            AdvancedSlot hoverSlot = this.getSlotAtLocation(x, y);
            boolean bl = isValid = this.trigger && hoverSlot instanceof TriggerSlot || !this.trigger && hoverSlot instanceof ActionSlot;
            if (!isValid) {
                GlStateManager.func_179124_c((float)0.95f, (float)0.6f, (float)0.6f);
            }
            this.drawStatement(x - 8, y - 8, state);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
    }

    private void drawStatement(int x, int y, IStatement state) {
        this.func_175175_a(x - 8, y - 8, CoreIconProvider.SLOT.getSprite(), 32, 32);
        this.func_175175_a(x, y, state.getGuiSprite(), 16, 16);
    }

    private void doSlotClick(AdvancedSlot slot, int k) {
        if (slot instanceof TriggerSlot && this.container.hasTriggers()) {
            TriggerSlot triggerSlot = (TriggerSlot)slot;
            IStatement changed = null;
            if (!GuiGateInterface.func_146272_n()) {
                if (triggerSlot.getStatement() == null) {
                    changed = k == 0 ? this.container.getFirstTrigger() : this.container.getLastTrigger();
                } else {
                    Iterator<IStatement> it = this.container.getTriggerIterator(k != 0);
                    while (it.hasNext()) {
                        IStatement trigger = it.next();
                        if (!it.hasNext()) break;
                        if (trigger != triggerSlot.getStatement()) continue;
                        changed = it.next();
                        break;
                    }
                }
            }
            if (changed == null) {
                this.container.setTrigger(triggerSlot.slot, null, true);
            } else {
                this.container.setTrigger(triggerSlot.slot, changed.getUniqueTag(), true);
            }
            for (StatementParameterSlot p : triggerSlot.parameters) {
                IStatementParameter parameter = null;
                if (changed != null && p.slot < changed.minParameters()) {
                    parameter = changed.createParameter(p.slot);
                }
                this.container.setTriggerParameter(triggerSlot.slot, p.slot, parameter, true);
            }
        } else if (slot instanceof ActionSlot) {
            ActionSlot actionSlot = (ActionSlot)slot;
            IStatement changed = null;
            if (!GuiGateInterface.func_146272_n()) {
                if (actionSlot.getStatement() == null) {
                    changed = k == 0 ? this.container.getFirstAction() : this.container.getLastAction();
                } else {
                    Iterator<IStatement> it = this.container.getActionIterator(k != 0);
                    while (it.hasNext()) {
                        IStatement action = it.next();
                        if (!it.hasNext()) break;
                        if (action != actionSlot.getStatement()) continue;
                        changed = it.next();
                        break;
                    }
                }
            }
            if (changed == null) {
                this.container.setAction(actionSlot.slot, null, true);
            } else {
                this.container.setAction(actionSlot.slot, changed.getUniqueTag(), true);
            }
            for (StatementParameterSlot p : actionSlot.parameters) {
                IStatementParameter parameter = null;
                if (changed != null && p.slot < changed.minParameters()) {
                    parameter = changed.createParameter(p.slot);
                }
                this.container.setActionParameter(actionSlot.slot, p.slot, parameter, true);
            }
        } else if (slot instanceof StatementParameterSlot) {
            StatementParameterSlot paramSlot = (StatementParameterSlot)slot;
            StatementSlot statement = paramSlot.statementSlot;
            if (statement.isDefined() && statement.getStatement().maxParameters() > paramSlot.slot) {
                IStatementParameter param = paramSlot.getParameter();
                if (param == null) {
                    param = statement.getStatement().createParameter(paramSlot.slot);
                }
                if (param != null) {
                    param.onClick(this.gate, statement.getStatement(), this.field_146297_k.field_71439_g.field_71071_by.func_70445_o(), new StatementMouseClick(k, GuiGateInterface.func_146272_n()));
                    paramSlot.setParameter(param, true);
                }
            }
        }
        this.container.markDirty();
    }

    @Override
    protected void func_73864_a(int x, int y, int type) throws IOException {
        int pY;
        int pX;
        int i;
        if (this.gate == null) {
            return;
        }
        super.func_73864_a(x, y, type);
        AdvancedSlot slot = this.getSlotAtLocation(x, y);
        if (slot != null) {
            this.doSlotClick(slot, type);
            return;
        }
        int sX = 18;
        int sY = 6;
        Collection<IStatement> collect = this.container.getTriggerCollection(false);
        for (i = 0; i < collect.size(); ++i) {
            pX = this.field_147003_i - sX;
            pY = this.field_147009_r + sY;
            if (x > pX & x < pX + 16 && y > pY && y < pY + 16) {
                this.trigger = true;
                this.index = i;
                return;
            }
            if (sX > 90) {
                sX = 18;
                sY += 18;
                continue;
            }
            sX += 18;
        }
        sX = 0;
        sY = 6;
        collect = this.container.getActionCollection(false);
        for (i = 0; i < collect.size(); ++i) {
            pX = this.field_147003_i + this.xSize() + sX;
            pY = this.field_147009_r + sY;
            if (x > pX & x < pX + 16 && y > pY && y < pY + 16) {
                this.trigger = false;
                this.index = i;
                return;
            }
            if (sX > 72) {
                sX = 0;
                sY += 18;
                continue;
            }
            sX += 18;
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int wheel = Mouse.getEventDWheel();
        if (wheel != 0) {
            int i = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int j = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            this.doSlotClick(this.getSlotAtLocation(i, j), wheel > 0 ? 0 : 1);
        }
    }

    @Override
    protected void func_146286_b(int mouseX, int mouseY, int eventType) {
        super.func_146286_b(mouseX, mouseY, eventType);
        if (this.index >= 0) {
            IStatementParameter parameter;
            StatementSlot trig;
            IStatement changeTo;
            int i = this.index;
            this.index = -1;
            Iterator<IStatement> it = this.trigger ? this.container.getTriggerIterator(false) : this.container.getActionIterator(false);
            do {
                changeTo = it.next();
            } while (--i >= 0);
            AdvancedSlot slot = this.getSlotAtLocation(mouseX, mouseY);
            if (slot == null) {
                return;
            }
            if (this.trigger && slot instanceof TriggerSlot) {
                trig = (TriggerSlot)slot;
                this.container.setTrigger(trig.slot, changeTo.getUniqueTag(), true);
                for (StatementParameterSlot p : trig.parameters) {
                    parameter = null;
                    if (p.slot < changeTo.minParameters()) {
                        parameter = changeTo.createParameter(p.slot);
                    }
                    this.container.setTriggerParameter(trig.slot, p.slot, parameter, true);
                }
            }
            if (!this.trigger && slot instanceof ActionSlot) {
                trig = (ActionSlot)slot;
                this.container.setAction(((ActionSlot)trig).slot, changeTo.getUniqueTag(), true);
                for (StatementParameterSlot p : ((ActionSlot)trig).parameters) {
                    parameter = null;
                    if (p.slot < changeTo.minParameters()) {
                        parameter = changeTo.createParameter(p.slot);
                    }
                    this.container.setActionParameter(((ActionSlot)trig).slot, p.slot, parameter, true);
                }
            }
        }
    }

    class ActionParameterSlot
    extends StatementParameterSlot {
        public ActionParameterSlot(int x, int y, IPipe pipe, int slot, StatementSlot iStatementSlot) {
            super(GuiGateInterface.this.instance, x, y, slot, iStatementSlot);
        }

        @Override
        public IStatementParameter getParameter() {
            return GuiGateInterface.this.gate.getActionParameter(this.statementSlot.slot, this.slot);
        }

        @Override
        public void setParameter(IStatementParameter param, boolean notifyServer) {
            GuiGateInterface.this.container.setActionParameter(this.statementSlot.slot, this.slot, param, notifyServer);
        }
    }

    class TriggerParameterSlot
    extends StatementParameterSlot {
        public TriggerParameterSlot(int x, int y, IPipe pipe, int slot, StatementSlot iStatementSlot) {
            super(GuiGateInterface.this.instance, x, y, slot, iStatementSlot);
        }

        @Override
        public IStatementParameter getParameter() {
            return GuiGateInterface.this.gate.getTriggerParameter(this.statementSlot.slot, this.slot);
        }

        @Override
        public void setParameter(IStatementParameter param, boolean notifyServer) {
            GuiGateInterface.this.container.setTriggerParameter(this.statementSlot.slot, this.slot, param, notifyServer);
        }
    }

    private class ActionSlot
    extends StatementSlot {
        public ActionSlot(int x, int y, IPipe pipe, int slot) {
            super(GuiGateInterface.this.instance, x, y, slot);
        }

        @Override
        public IStatement getStatement() {
            return GuiGateInterface.this.gate.getAction(this.slot);
        }
    }

    private class TriggerSlot
    extends StatementSlot {
        public TriggerSlot(int x, int y, IPipe pipe, int slot) {
            super(GuiGateInterface.this.instance, x, y, slot);
        }

        @Override
        public IStatement getStatement() {
            return GuiGateInterface.this.gate.getTrigger(this.slot);
        }
    }
}

