/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.render;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.BCLog;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.transport.PipeRenderState;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.client.model.PipeModelCacheWire;
import buildcraft.transport.client.render.PipeTransportRenderer;
import com.google.common.base.Throwables;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import org.lwjgl.opengl.GL11;

public class PipeRendererTESR
extends TileEntitySpecialRenderer<TileGenericPipe> {
    public void renderTileEntityAt(TileGenericPipe pipe, double x, double y, double z, float f, int argumentthatisalwaysminusone) {
        if (BuildCraftCore.render == BuildCraftCore.RenderMode.NoDynamic) {
            return;
        }
        if (pipe.pipe == null) {
            return;
        }
        if (pipe.pipe.container == null) {
            return;
        }
        Minecraft.func_71410_x().field_71424_I.func_76320_a("bc");
        Minecraft.func_71410_x().field_71424_I.func_76320_a("pipe");
        Minecraft.func_71410_x().field_71424_I.func_76320_a("wire");
        PipeRendererTESR.renderWire(pipe, x, y, z);
        Minecraft.func_71410_x().field_71424_I.func_76318_c("pluggable");
        this.renderPluggables(pipe, x, y, z);
        Minecraft.func_71410_x().field_71424_I.func_76318_c("contents");
        if (pipe.pipe.transport != null) {
            try {
                PipeTransportRenderer renderer = PipeTransportRenderer.RENDERER_MAP.get(pipe.pipe.transport.getClass());
                if (renderer != null) {
                    renderer.render(pipe.pipe, x, y, z, f);
                }
            }
            catch (Throwable t) {
                BCLog.logger.warn("A crash! Oh no!", t);
                throw Throwables.propagate((Throwable)t);
            }
            finally {
                Minecraft.func_71410_x().field_71424_I.func_76319_b();
                Minecraft.func_71410_x().field_71424_I.func_76319_b();
                Minecraft.func_71410_x().field_71424_I.func_76319_b();
            }
        }
    }

    private static void renderWire(TileGenericPipe pipe, double x, double y, double z) {
        PipeModelCacheWire.PipeWireKey key = new PipeModelCacheWire.PipeWireKey(pipe.renderState);
        RenderHelper.func_74518_a();
        TileEntityRendererDispatcher.field_147556_a.field_147553_e.func_110577_a(TextureMap.field_110575_b);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        PipeModelCacheWire.cacheAll.renderDisplayList(key);
        GL11.glPopMatrix();
        RenderHelper.func_74519_b();
    }

    private void renderPluggables(TileGenericPipe pipe, double x, double y, double z) {
        TileEntityRendererDispatcher.field_147556_a.field_147553_e.func_110577_a(TextureMap.field_110575_b);
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            PipePluggable pluggable = pipe.getPipePluggable(direction);
            if (pluggable == null || pluggable.getDynamicRenderer() == null) continue;
            pluggable.getDynamicRenderer().renderDynamicPluggable(pipe.getPipe(), direction, pluggable, x, y, z);
        }
    }

    public boolean isOpenOrientation(PipeRenderState state, EnumFacing direction) {
        int connections = 0;
        EnumFacing targetOrientation = null;
        for (EnumFacing o : EnumFacing.field_82609_l) {
            if (!state.pipeConnectionMatrix.isConnected(o) || ++connections != 1) continue;
            targetOrientation = o;
        }
        if (connections > 1 || targetOrientation == null) {
            return false;
        }
        return targetOrientation.func_176734_d() == direction;
    }
}

