/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.model;

import buildcraft.BuildCraftTransport;
import buildcraft.api.transport.PipeWire;
import buildcraft.core.lib.client.model.BCModelHelper;
import buildcraft.core.lib.client.model.IModelCache;
import buildcraft.core.lib.client.model.ModelCache;
import buildcraft.core.lib.client.model.ModelCacheBuilder;
import buildcraft.core.lib.client.model.ModelCacheMultipleSame;
import buildcraft.core.lib.client.model.MutableQuad;
import buildcraft.core.lib.utils.Utils;
import buildcraft.transport.PipeRenderState;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;

public class PipeModelCacheWire {
    public static final IModelCache<PipeWireKey> cacheAll;
    public static final ModelCache<PipeWireKeySingle> cacheSingle;
    private static EnumMap<PipeWire, Vec3> wirePosMap;
    private static EnumMap<PipeWire, EnumFacing.AxisDirection[]> wireDirectionMap;
    private static final double WIRE_WIDTH = 0.05;
    private static final double WIRE_OFFSET = 0.001;

    private static Vec3 getOffset(PipeWire wire) {
        double min = 0.2;
        double max = 0.75;
        int multiple = wire.ordinal() + 1;
        double offset = 0.001 * (double)multiple;
        double inset = -offset;
        EnumFacing.AxisDirection[] axis = wireDirectionMap.get((Object)wire);
        boolean[] axisPos = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            axisPos[i] = axis[i] == EnumFacing.AxisDirection.POSITIVE;
        }
        Vec3 base = new Vec3(axisPos[0] ? max : min, axisPos[1] ? max : min, axisPos[2] ? max : min);
        return base.func_72441_c(axisPos[0] ? inset : offset, axisPos[1] ? inset : offset, axisPos[2] ? inset : offset);
    }

    private static ImmutableList<MutableQuad> generate(PipeWireKeySingle key) {
        PipeWire wire = key.type;
        Vec3 pos = wirePosMap.get((Object)wire);
        boolean isLit = key.on;
        TextureAtlasSprite sprite = BuildCraftTransport.instance.wireIconProvider.getIcon(wire, isLit);
        ArrayList<MutableQuad> unprocessed = new ArrayList<MutableQuad>();
        Vec3 center = pos;
        Vec3 centerSize = new Vec3(0.05, 0.05, 0.05);
        EnumFacing.AxisDirection[] directions = wireDirectionMap.get((Object)wire);
        int numFaces = 0;
        for (EnumFacing face : EnumFacing.values()) {
            boolean positive = face.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
            EnumFacing.Axis axis = face.func_176740_k();
            EnumFacing.AxisDirection wireCenter = directions[axis.ordinal()];
            if (key.connections.contains(face)) {
                if (wireCenter == face.func_176743_c()) {
                    ++numFaces;
                }
                ++numFaces;
                Vec3 start = pos;
                Vec3 end = pos.func_178787_e(centerSize);
                if (positive) {
                    start = Utils.withValue(start, axis, Utils.getValue(start, axis) + 0.05);
                    end = Utils.withValue(end, axis, 1.0);
                } else {
                    start = Utils.withValue(start, axis, 0.0);
                    end = Utils.withValue(end, axis, Utils.getValue(end, axis) - 0.05);
                }
                PipeModelCacheWire.renderCuboid(unprocessed, start, end.func_178788_d(start), sprite);
                continue;
            }
            boolean anyOther = false;
            for (Vec3 face2 : EnumFacing.values()) {
                if (face2.func_176734_d() == face) continue;
                anyOther |= key.connections.contains(face2);
            }
            if (anyOther) continue;
            Vec3 start = pos;
            Vec3 end = pos.func_178787_e(centerSize);
            if (positive) {
                start = Utils.withValue(start, axis, Utils.getValue(start, axis) + 0.05);
                end = Utils.withValue(end, axis, 0.75);
            } else {
                start = Utils.withValue(start, axis, 0.25);
                end = Utils.withValue(end, axis, Utils.getValue(end, axis) - 0.05);
            }
            Vec3 size = end.func_178788_d(start);
            if (!(size.func_72433_c() > 0.1)) continue;
            PipeModelCacheWire.renderCuboid(unprocessed, start, size, sprite);
        }
        if (numFaces != 1) {
            PipeModelCacheWire.renderCuboid(unprocessed, center, centerSize, sprite);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MutableQuad quad : unprocessed) {
            if (isLit) {
                quad.lightf(1.0f, 0.0f);
            }
            quad.colourf(1.0f, 1.0f, 1.0f, 1.0f);
            builder.add((Object)quad);
        }
        return builder.build();
    }

    private static void renderCuboid(List<MutableQuad> quads, Vec3 min, Vec3 size, TextureAtlasSprite sprite) {
        Vec3 radius = Utils.multiply(size, 0.5);
        Vector3f radiusF = Utils.convertFloat(radius);
        Vector3f center = Utils.convertFloat(min.func_178787_e(radius));
        for (EnumFacing face : EnumFacing.values()) {
            float[] uvs = new float[4];
            int neg = (face.ordinal() - 2) % 6;
            if (neg < 0) {
                neg += 6;
            }
            EnumFacing uFace = EnumFacing.field_82609_l[neg];
            EnumFacing vFace = EnumFacing.field_82609_l[(face.ordinal() + 2) % 6];
            if (face.func_176740_k() == EnumFacing.Axis.Z) {
                EnumFacing holder = uFace;
                uFace = vFace;
                vFace = holder;
            }
            uvs[0] = sprite.func_94209_e();
            uvs[1] = sprite.func_94214_a(Utils.getValue(size, uFace.func_176740_k()) * 16.0);
            uvs[2] = sprite.func_94206_g();
            uvs[3] = sprite.func_94207_b(Utils.getValue(size, vFace.func_176740_k()) * 16.0);
            BCModelHelper.appendQuads(quads, BCModelHelper.createFace(face, (Tuple3f)center, (Tuple3f)radiusF, uvs));
        }
    }

    static {
        wirePosMap = Maps.newEnumMap(PipeWire.class);
        wireDirectionMap = Maps.newEnumMap(PipeWire.class);
        EnumFacing.AxisDirection neg = EnumFacing.AxisDirection.NEGATIVE;
        EnumFacing.AxisDirection pos = EnumFacing.AxisDirection.POSITIVE;
        wireDirectionMap.put(PipeWire.RED, new EnumFacing.AxisDirection[]{neg, pos, neg});
        wireDirectionMap.put(PipeWire.BLUE, new EnumFacing.AxisDirection[]{pos, pos, pos});
        wireDirectionMap.put(PipeWire.GREEN, new EnumFacing.AxisDirection[]{pos, neg, neg});
        wireDirectionMap.put(PipeWire.YELLOW, new EnumFacing.AxisDirection[]{neg, neg, pos});
        wirePosMap.put(PipeWire.RED, PipeModelCacheWire.getOffset(PipeWire.RED));
        wirePosMap.put(PipeWire.BLUE, PipeModelCacheWire.getOffset(PipeWire.BLUE));
        wirePosMap.put(PipeWire.GREEN, PipeModelCacheWire.getOffset(PipeWire.GREEN));
        wirePosMap.put(PipeWire.YELLOW, PipeModelCacheWire.getOffset(PipeWire.YELLOW));
        cacheSingle = new ModelCacheBuilder<PipeWireKeySingle>("pipe.wire.single", PipeModelCacheWire::generate).setMaxSize(1003).enableGL(DefaultVertexFormats.field_181707_g).setKeepMutable(false).build();
        cacheAll = new ModelCacheMultipleSame<PipeWireKey, PipeWireKeySingle>("pipe.wire.all", PipeWireKey::getKeys, cacheSingle);
    }

    public static final class PipeWireKeySingle {
        public final PipeWire type;
        public final boolean on;
        public final EnumSet<EnumFacing> connections;
        private final int hash;

        public PipeWireKeySingle(PipeWire type, boolean on, EnumSet<EnumFacing> connections) {
            this.type = type;
            this.on = on;
            this.connections = connections;
            this.hash = Objects.hash(new Object[]{type, on, connections});
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PipeWireKeySingle other = (PipeWireKeySingle)obj;
            if (this.on != other.on) {
                return false;
            }
            if (this.type != other.type) {
                return false;
            }
            return this.connections.containsAll(other.connections) && other.connections.containsAll(this.connections);
        }
    }

    public static final class PipeWireKey {
        public final ImmutableSet<PipeWireKeySingle> keys;
        private final int hash;

        public PipeWireKey(PipeRenderState state) {
            ImmutableSet.Builder set = ImmutableSet.builder();
            for (PipeWire wire : PipeWire.VALUES) {
                if (!state.wireMatrix.hasWire(wire)) continue;
                EnumSet<EnumFacing> connections = EnumSet.noneOf(EnumFacing.class);
                for (EnumFacing face : EnumFacing.values()) {
                    if (!state.wireMatrix.isWireConnected(wire, face)) continue;
                    connections.add(face);
                }
                set.add((Object)new PipeWireKeySingle(wire, state.wireMatrix.isWireLit(wire), connections));
            }
            this.keys = set.build();
            this.hash = this.keys.hashCode();
        }

        public static ImmutableSet<PipeWireKeySingle> getKeys(PipeWireKey key) {
            return key.keys;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PipeWireKey other = (PipeWireKey)obj;
            return !(this.keys == null ? other.keys != null : !this.keys.equals(other.keys));
        }
    }
}

