/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.model;

import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.api.transport.pluggable.PluggableModelKey;
import buildcraft.core.lib.client.model.IModelCache;
import buildcraft.core.lib.client.model.ModelCache;
import buildcraft.core.lib.client.model.ModelCacheMultipleSame;
import buildcraft.core.lib.client.model.MutableQuad;
import buildcraft.transport.PipePluggableState;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;

public class PipeModelCachePluggable {
    public static final IModelCache<PluggableKey> cacheCutoutAll;
    public static final IModelCache<PluggableKey> cacheTranslucentAll;
    public static final ModelCache<PluggableModelKey<?>> cacheCutoutSingle;
    public static final ModelCache<PluggableModelKey<?>> cacheTranslucentSingle;

    private static <K extends PluggableModelKey<K>> ImmutableList<MutableQuad> generate(PluggableModelKey<K> key) {
        if (key == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        VertexFormat format = key.baker.getVertexFormat();
        for (BakedQuad bq : key.baker.bake(key)) {
            builder.add((Object)MutableQuad.create(bq, format));
        }
        return builder.build();
    }

    static {
        cacheCutoutSingle = new ModelCache<PluggableModelKey>("pipe.pluggable.cutout.single", PipeModelCachePluggable::generate);
        cacheCutoutAll = new ModelCacheMultipleSame("pipe.pluggable.cutout.all", PluggableKey::getKeys, cacheCutoutSingle);
        cacheTranslucentSingle = new ModelCache<PluggableModelKey>("pipe.pluggable.translucent.single", PipeModelCachePluggable::generate);
        cacheTranslucentAll = new ModelCacheMultipleSame("pipe.pluggable.translucent.all", PluggableKey::getKeys, cacheTranslucentSingle);
    }

    public static class PluggableKey {
        private final ImmutableSet<PluggableModelKey<?>> pluggables;
        private final int hash;

        public PluggableKey(EnumWorldBlockLayer layer, PipePluggableState state) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (EnumFacing side : EnumFacing.values()) {
                PluggableModelKey<?> key;
                PipePluggable pluggable = state.getPluggable(side);
                if (pluggable == null || (key = pluggable.getModelRenderKey(layer, side)) == null || key.baker == null) continue;
                builder.add(key);
            }
            this.pluggables = builder.build();
            this.hash = this.pluggables.hashCode();
        }

        public ImmutableSet<PluggableModelKey<?>> getKeys() {
            return this.pluggables;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PluggableKey other = (PluggableKey)obj;
            return this.pluggables.equals(other.pluggables);
        }
    }
}

