/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.model;

import buildcraft.core.lib.EntityResizableCuboid;
import buildcraft.core.lib.client.model.BCModelHelper;
import buildcraft.core.lib.client.model.IModelCache;
import buildcraft.core.lib.client.model.ModelCache;
import buildcraft.core.lib.client.model.MutableQuad;
import buildcraft.core.lib.client.render.RenderResizableCuboid;
import buildcraft.core.lib.config.DetailedConfigOption;
import buildcraft.core.lib.utils.ColorUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeRenderState;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;

public class PipeModelCacheBase {
    private static final DetailedConfigOption OPTION_INSIDE_COLOUR_MULT = new DetailedConfigOption("render.pipe.misc.inside.shade", "0.67");
    static final IModelCache<PipeBaseCutoutKey> cacheCutout = new ModelCache<PipeBaseCutoutKey>("pipe.base.cutout", PipeModelCacheBase::generateCutout);
    static final IModelCache<PipeBaseTransclucentKey> cacheTranslucent = new ModelCache<PipeBaseTransclucentKey>("pipe.base.transclucent", PipeModelCacheBase::generateTranslucent);

    private static List<MutableQuad> generateCutout(PipeBaseCutoutKey key) {
        TextureAtlasSprite center = key.center;
        float min = 0.25f;
        float max = 0.75f;
        float minUV = min * 16.0f;
        float maxUV = max * 16.0f;
        float[] centerUV = new float[]{center.func_94214_a((double)minUV), center.func_94214_a((double)maxUV), center.func_94207_b((double)minUV), center.func_94207_b((double)maxUV)};
        ArrayList<MutableQuad> mutable = new ArrayList<MutableQuad>();
        ArrayList<MutableQuad> mutableIn = new ArrayList<MutableQuad>();
        for (EnumFacing face : EnumFacing.values()) {
            float size = key.connections[face.ordinal()];
            if (size <= 0.0f) {
                PipeModelCacheBase.renderPipeCenterFace(centerUV, face, false, mutable, mutableIn);
                continue;
            }
            PipeModelCacheBase.renderPipeConnection(size, face, key.sides[face.ordinal()], false, mutable, mutableIn);
        }
        float mult = OPTION_INSIDE_COLOUR_MULT.getAsFloatCapped(0.0f, 1.0f);
        for (MutableQuad q : mutableIn) {
            q.colourf(mult, mult, mult, 1.0f);
            mutable.add(q);
        }
        return mutable;
    }

    private static List<MutableQuad> generateTranslucent(PipeBaseTransclucentKey key) {
        if (!key.shouldRender()) {
            return ImmutableList.of();
        }
        TextureAtlasSprite sprite = PipeIconProvider.TYPE.PipeStainedOverlay.getIcon();
        float min = 0.25f;
        float max = 0.75f;
        float minUV = min * 16.0f;
        float maxUV = max * 16.0f;
        float[] centerUV = new float[]{sprite.func_94214_a((double)minUV), sprite.func_94214_a((double)maxUV), sprite.func_94207_b((double)minUV), sprite.func_94207_b((double)maxUV)};
        ArrayList<MutableQuad> mutable = new ArrayList<MutableQuad>();
        ArrayList<MutableQuad> mutableIn = new ArrayList<MutableQuad>();
        for (EnumFacing face : EnumFacing.values()) {
            float size = key.connections[face.ordinal()];
            if (size <= 0.0f) {
                PipeModelCacheBase.renderPipeCenterFace(centerUV, face, true, mutable, mutableIn);
                continue;
            }
            PipeModelCacheBase.renderPipeConnection(size, face, sprite, true, mutable, mutableIn);
        }
        float mult = OPTION_INSIDE_COLOUR_MULT.getAsFloatCapped(0.0f, 1.0f);
        for (MutableQuad q : mutableIn) {
            q.colourf(mult, mult, mult, 1.0f);
            mutable.add(q);
        }
        int colour = ColorUtils.getRGBColor(key.colour);
        for (MutableQuad q : mutable) {
            q.setTint(colour);
        }
        return mutable;
    }

    private static void renderPipeCenterFace(float[] uvs, EnumFacing face, boolean smaller, List<MutableQuad> mutable, List<MutableQuad> mutableIn) {
        Vec3 radius = Utils.vec3(0.25);
        if (smaller) {
            double smallerValue = Utils.getValue(radius, face.func_176740_k()) - (double)0.01f;
            radius = Utils.withValue(radius, face.func_176740_k(), smallerValue);
        }
        Vector3f center = Utils.vec3f(0.5f);
        Vector3f radiusf = Utils.convertFloat(radius);
        BCModelHelper.appendQuads(mutable, BCModelHelper.createFace(face, (Tuple3f)center, (Tuple3f)radiusf, uvs));
        BCModelHelper.appendQuads(mutableIn, BCModelHelper.createInverseFace(face, (Tuple3f)center, (Tuple3f)radiusf, uvs).setFace(face.func_176734_d()));
    }

    private static void renderPipeConnection(float extension, EnumFacing face, TextureAtlasSprite sprite, boolean smaller, List<MutableQuad> mutable, List<MutableQuad> mutableIn) {
        Vec3 actualCenter = Utils.convert(face, 0.25 + (double)(extension / 2.0f)).func_178787_e(Utils.VEC_HALF);
        EnumFacing positive = Utils.convertPositive(face);
        Vec3 actualSize = Utils.convert(positive, extension);
        actualSize = actualSize.func_178787_e(Utils.convertExcept(positive, 0.5));
        if (smaller) {
            Vec3 allSmaller = actualSize.func_178788_d(Utils.vec3(0.02));
            actualSize = allSmaller.func_178787_e(Utils.convert(positive, 0.02));
        }
        Vec3 pos = actualCenter.func_178788_d(Utils.multiply(actualSize, 0.5));
        EntityResizableCuboid cuboid = new EntityResizableCuboid(null);
        cuboid.texture = sprite;
        cuboid.makeClient();
        double start = face.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 12.0 : 0.0;
        cuboid.textureStartX = face.func_176740_k() == EnumFacing.Axis.X ? start : 4.0;
        cuboid.textureStartY = face.func_176740_k() == EnumFacing.Axis.Y ? start : 4.0;
        cuboid.textureStartZ = face.func_176740_k() == EnumFacing.Axis.Z ? start : 4.0;
        cuboid.textureSizeX = face.func_176740_k() == EnumFacing.Axis.X ? 4.0 : 8.0;
        cuboid.textureSizeY = face.func_176740_k() == EnumFacing.Axis.Y ? 4.0 : 8.0;
        cuboid.textureSizeZ = face.func_176740_k() == EnumFacing.Axis.Z ? 4.0 : 8.0;
        cuboid.textures[face.ordinal()] = null;
        cuboid.textures[face.func_176734_d().ordinal()] = null;
        cuboid.setSize(actualSize);
        cuboid.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        RenderResizableCuboid.bakeCube(mutable, cuboid, true, false);
        RenderResizableCuboid.bakeCube(mutableIn, cuboid, false, true);
    }

    private static float[] computeConnections(PipeRenderState state) {
        float[] f = new float[6];
        for (EnumFacing face : EnumFacing.values()) {
            int i = face.ordinal();
            if (state.pipeConnectionMatrix.isConnected(face)) {
                if (state.pipeConnectionExtensions.isConnected(face)) {
                    f[i] = 0.25f + state.customConnections[i];
                    continue;
                }
                f[i] = 0.25f;
                continue;
            }
            f[i] = -100.0f;
        }
        return f;
    }

    public static final class PipeBaseTransclucentKey {
        public final byte colour;
        public final float[] connections;
        private final int hashCode;

        public PipeBaseTransclucentKey(PipeRenderState render) {
            this.colour = render.getGlassColor();
            if (this.shouldRender()) {
                this.connections = PipeModelCacheBase.computeConnections(render);
                this.hashCode = Objects.hash(this.colour, Arrays.hashCode(this.connections));
            } else {
                this.hashCode = 0;
                this.connections = null;
            }
        }

        public boolean shouldRender() {
            return this.colour >= 0 && this.colour < 16;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PipeBaseTransclucentKey)) {
                return false;
            }
            PipeBaseTransclucentKey other = (PipeBaseTransclucentKey)obj;
            if (!this.shouldRender() && !other.shouldRender()) {
                return true;
            }
            if (!Arrays.equals(this.connections, other.connections)) {
                return false;
            }
            return this.colour == other.colour;
        }

        public String toString() {
            return "PipeBaseTransclucentKey [colour=" + this.colour + ", connections=" + Arrays.toString(this.connections) + "]";
        }
    }

    public static final class PipeBaseCutoutKey {
        public final TextureAtlasSprite center;
        public final TextureAtlasSprite[] sides;
        public final float[] connections;
        private final int hashCode;

        public PipeBaseCutoutKey(Pipe<?> pipe, PipeRenderState render) {
            this(render, PipeBaseCutoutKey.getSprites(pipe, render));
        }

        private static Map<EnumFacing, TextureAtlasSprite> getSprites(Pipe<?> pipe, PipeRenderState render) {
            HashMap spriteMap = Maps.newHashMap();
            for (EnumFacing face : EnumFacing.values()) {
                spriteMap.put(face, pipe.getIconProvider().getIcon(render.textureMatrix.getTextureIndex(face)));
            }
            spriteMap.put(null, pipe.getIconProvider().getIcon(render.textureMatrix.getTextureIndex(null)));
            return spriteMap;
        }

        public PipeBaseCutoutKey(PipeRenderState render, Map<EnumFacing, TextureAtlasSprite> sprites) {
            this.center = sprites.get(null);
            this.sides = new TextureAtlasSprite[6];
            for (EnumFacing face : EnumFacing.values()) {
                this.sides[face.ordinal()] = sprites.get(face);
            }
            this.connections = PipeModelCacheBase.computeConnections(render);
            this.hashCode = Objects.hash(this.center, Arrays.hashCode(this.sides), Arrays.hashCode(this.connections));
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PipeBaseCutoutKey other = (PipeBaseCutoutKey)obj;
            if (this.center != other.center) {
                return false;
            }
            if (!Arrays.equals(this.connections, other.connections)) {
                return false;
            }
            return Arrays.equals(this.sides, other.sides);
        }

        public String toString() {
            return "PipeBaseCutoutKey [center=" + this.center.func_94215_i() + ", sides=" + this.sidesToString() + ", connections=" + Arrays.toString(this.connections) + "]";
        }

        private String sidesToString() {
            String s = "[";
            for (int i = 0; i < this.sides.length; ++i) {
                TextureAtlasSprite sprite;
                if (i != 0) {
                    s = s + ", ";
                }
                s = (sprite = this.sides[i]) == null ? s + "null" : s + sprite.func_94215_i();
            }
            return s + "]";
        }
    }
}

