/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.model;

import buildcraft.core.lib.EntityResizableCuboid;
import buildcraft.core.lib.client.model.BCModelHelper;
import buildcraft.core.lib.client.model.BuildCraftBakedModel;
import buildcraft.core.lib.client.model.MutableQuad;
import buildcraft.core.lib.client.render.RenderResizableCuboid;
import buildcraft.core.lib.utils.ColorUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.PipeIconProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.Vec3;

public class PipeItemModel
extends BuildCraftBakedModel {
    protected PipeItemModel(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle) {
        super(quads, particle, DefaultVertexFormats.field_176599_b, PipeItemModel.getBlockTransforms());
    }

    @Override
    public boolean func_177556_c() {
        return true;
    }

    public static PipeItemModel create(ItemPipe item, int colorIndex) {
        TextureAtlasSprite sprite = item.getSprite();
        if (sprite == null) {
            sprite = Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        Vec3 center = Utils.VEC_HALF;
        Vec3 radius = new Vec3(0.25, 0.5, 0.25);
        EntityResizableCuboid cuboid = new EntityResizableCuboid(null);
        cuboid.texture = sprite;
        cuboid.setTextureOffset(new Vec3(4.0, 0.0, 4.0));
        cuboid.setPosition(center.func_178788_d(radius));
        cuboid.setSize(Utils.multiply(radius, 2.0));
        ArrayList unprocessed = Lists.newArrayList();
        ArrayList quads = Lists.newArrayList();
        RenderResizableCuboid.bakeCube(unprocessed, cuboid, true, false);
        for (MutableQuad quad : unprocessed) {
            quad.normalf(0.0f, 1.0f, 0.0f);
            BCModelHelper.appendBakeQuads((List<BakedQuad>)quads, DefaultVertexFormats.field_176599_b, quad);
        }
        unprocessed.clear();
        if (colorIndex != 0) {
            radius = new Vec3(0.249, 0.499, 0.249);
            cuboid = new EntityResizableCuboid(null);
            cuboid.setTextureOffset(new Vec3(4.0, 0.0, 4.0));
            cuboid.texture = PipeIconProvider.TYPE.PipeStainedOverlay.getIcon();
            cuboid.setPosition(center.func_178788_d(radius));
            cuboid.setSize(Utils.multiply(radius, 2.0));
            RenderResizableCuboid.bakeCube(unprocessed, cuboid, true, false);
            EnumDyeColor dye = EnumDyeColor.func_176766_a((int)(colorIndex - 1));
            int quadColor = ColorUtils.getLightHex(dye);
            for (MutableQuad quad : unprocessed) {
                quad.normalf(0.0f, 1.0f, 0.0f);
                quad.setTint(quadColor);
                BCModelHelper.appendBakeQuads((List<BakedQuad>)quads, DefaultVertexFormats.field_176599_b, quad);
            }
            unprocessed.clear();
        }
        return new PipeItemModel((ImmutableList<BakedQuad>)ImmutableList.copyOf((Collection)quads), sprite);
    }
}

