/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.model;

import buildcraft.api.gates.GateExpansionModelKey;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.api.transport.pluggable.PluggableModelKey;
import buildcraft.transport.client.model.GatePluggableModel;
import buildcraft.transport.gates.GateDefinition;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;

public class ModelKeyGate
extends PluggableModelKey<ModelKeyGate> {
    public final GateDefinition.GateMaterial material;
    public final GateDefinition.GateLogic logic;
    public final ImmutableSet<GateExpansionModelKey<?>> expansions;
    public final boolean lit;
    public final int hash;

    public ModelKeyGate(EnumFacing side, GateDefinition.GateMaterial material, GateDefinition.GateLogic logic, boolean lit, IGateExpansion[] expansions) {
        super(EnumWorldBlockLayer.CUTOUT, GatePluggableModel.INSTANCE, side);
        this.material = material;
        this.logic = logic;
        this.lit = lit;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (IGateExpansion exp : expansions) {
            GateExpansionModelKey<?> key;
            if (exp == null || (key = exp.getRenderModelKey(this.layer)) == null) continue;
            builder.add(key);
        }
        this.expansions = builder.build();
        this.hash = Objects.hash(new Object[]{this.material, this.logic, this.lit, this.expansions});
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelKeyGate other = (ModelKeyGate)obj;
        if (!this.expansions.equals(other.expansions)) {
            return false;
        }
        if (this.logic != other.logic) {
            return false;
        }
        if (this.material != other.material) {
            return false;
        }
        return this.lit == other.lit;
    }
}

