/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.model;

import buildcraft.api.gates.IGateExpansion;
import buildcraft.core.lib.client.model.BakedModelHolder;
import buildcraft.core.lib.client.model.MutableQuad;
import buildcraft.core.lib.utils.MatrixUtils;
import buildcraft.transport.client.model.GatePluggableModel;
import buildcraft.transport.client.model.ModelKeyGate;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gates.ItemGate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ISmartItemModel;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GateItemModel
extends BakedModelHolder
implements ISmartItemModel {
    public static final GateItemModel INSTANCE = new GateItemModel();
    private final Map<ModelKeyGate, GateItemModel> map = Maps.newHashMap();

    public GateItemModel(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format) {
        super(quads, particle, format, GateItemModel.getPluggableTransforms());
    }

    private GateItemModel() {
    }

    @SubscribeEvent
    public void modelBake(ModelBakeEvent event) {
        this.map.clear();
    }

    public GateItemModel handleItemState(ItemStack stack) {
        ModelKeyGate key = this.getState(stack);
        if (!this.map.containsKey(key)) {
            ArrayList quads = Lists.newArrayList();
            List<MutableQuad> mutableQuads = GatePluggableModel.INSTANCE.renderGate(key, DefaultVertexFormats.field_176599_b);
            Matrix4f rotation = MatrixUtils.rotateTowardsFace(EnumFacing.SOUTH);
            Matrix4f matScale = new Matrix4f();
            matScale.setIdentity();
            matScale.setScale(2.0f);
            matScale.setTranslation(new Vector3f(-0.5f, -0.5f, -0.5f));
            Matrix4f translateToItem = new Matrix4f();
            translateToItem.setIdentity();
            translateToItem.setTranslation(new Vector3f(0.0f, 0.0f, -0.4f));
            Matrix4f totalMatrix = new Matrix4f();
            totalMatrix.setIdentity();
            totalMatrix.mul(translateToItem);
            totalMatrix.mul(matScale);
            totalMatrix.mul(rotation);
            for (MutableQuad quad : mutableQuads) {
                quad.transform(totalMatrix);
                quad.colouri(-1);
                quads.add(quad.toUnpacked(DefaultVertexFormats.field_176599_b));
            }
            this.map.put(key, new GateItemModel((ImmutableList<BakedQuad>)ImmutableList.copyOf((Collection)quads), null, DefaultVertexFormats.field_176599_b));
        }
        return this.map.get(key);
    }

    private ModelKeyGate getState(ItemStack stack) {
        GateDefinition.GateMaterial material = ItemGate.getMaterial(stack);
        GateDefinition.GateLogic logic = ItemGate.getLogic(stack);
        Set<IGateExpansion> expansions = ItemGate.getInstalledExpansions(stack);
        return new ModelKeyGate(EnumFacing.UP, material, logic, false, expansions.toArray(new IGateExpansion[0]));
    }
}

