/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.model;

import buildcraft.core.lib.client.model.BCModelHelper;
import buildcraft.core.lib.client.model.BuildCraftBakedModel;
import buildcraft.core.lib.client.model.MutableQuad;
import buildcraft.core.lib.utils.MatrixUtils;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.client.model.FacadePluggableModel;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.ISmartItemModel;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FacadeItemModel
extends BuildCraftBakedModel
implements ISmartItemModel {
    public static final FacadeItemModel INSTANCE = new FacadeItemModel();
    private final Map<ItemFacade.FacadeState, FacadeItemModel> map = Maps.newHashMap();

    public FacadeItemModel(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format) {
        super(quads, particle, format, FacadeItemModel.getBlockTransforms());
    }

    private FacadeItemModel() {
        super(null, null, null);
    }

    @SubscribeEvent
    public void modelBake(ModelBakeEvent event) {
        this.map.clear();
    }

    @Override
    public boolean func_177556_c() {
        return true;
    }

    public FacadeItemModel handleItemState(ItemStack stack) {
        ItemFacade.FacadeState[] states = ItemFacade.getFacadeStates(stack);
        if (states.length == 0) {
            return this;
        }
        if (states.length == 1) {
            if (!this.map.containsKey(states[0])) {
                this.map.put(states[0], this.createFacadeItemModel(states[0]));
            }
            return this.map.get(states[0]);
        }
        int length = states.length;
        long millis = System.currentTimeMillis() / 2500L;
        int index = (int)(millis % (long)length);
        ItemFacade.FacadeState state = states[index];
        if (!this.map.containsKey(state)) {
            this.map.put(state, this.createFacadeItemModel(state));
        }
        return this.map.get(state);
    }

    private FacadeItemModel createFacadeItemModel(ItemFacade.FacadeState state) {
        ArrayList quads = Lists.newArrayList();
        IModel model = state.hollow ? FacadePluggableModel.INSTANCE.modelHollow() : FacadePluggableModel.INSTANCE.modelFilled();
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state.state);
        if (sprite == null) {
            sprite = Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        List bakedQuads = model.bake((IModelState)ModelRotation.X0_Y0, DefaultVertexFormats.field_176599_b, FacadeItemModel.singleTextureFunction(sprite)).func_177550_a();
        Matrix4f rotation = MatrixUtils.rotateTowardsFace(EnumFacing.EAST);
        Matrix4f translateToItem = new Matrix4f();
        translateToItem.setIdentity();
        translateToItem.setTranslation(new Vector3f(0.4f, 0.0f, 0.0f));
        Matrix4f totalMatrix = new Matrix4f();
        totalMatrix.setIdentity();
        totalMatrix.mul(rotation);
        totalMatrix.mul(translateToItem);
        for (BakedQuad quad : bakedQuads) {
            MutableQuad mutable = MutableQuad.create(quad);
            mutable.transform(totalMatrix);
            mutable.colouri(-1);
            BCModelHelper.appendBakeQuads((List<BakedQuad>)quads, DefaultVertexFormats.field_176599_b, mutable);
        }
        return new FacadeItemModel((ImmutableList<BakedQuad>)ImmutableList.copyOf((Collection)quads), sprite, DefaultVertexFormats.field_176599_b);
    }
}

