/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.ISerializable;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.api.power.IRedstoneEngineReceiver;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.transport.ICustomPipeConnection;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.PipeConnectionAPI;
import buildcraft.api.transport.PipeManager;
import buildcraft.api.transport.PipeWire;
import buildcraft.api.transport.pluggable.IFacadePluggable;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.DefaultProps;
import buildcraft.core.internal.IDropControlInventory;
import buildcraft.core.lib.ITileBufferHolder;
import buildcraft.core.lib.TileBuffer;
import buildcraft.core.lib.network.IGuiReturnHandler;
import buildcraft.core.lib.network.ISyncedTile;
import buildcraft.core.lib.network.PacketTileState;
import buildcraft.core.lib.network.base.Packet;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.DefaultPipeConnection;
import buildcraft.transport.FacadePluggable;
import buildcraft.transport.Gate;
import buildcraft.transport.IPipeConnectionForced;
import buildcraft.transport.ISolidSideTile;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipePluggableState;
import buildcraft.transport.PipeRenderState;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.gates.GateFactory;
import buildcraft.transport.gates.GatePluggable;
import buildcraft.transport.pluggable.PlugPluggable;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import com.google.common.base.Throwables;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class TileGenericPipe
extends TileEntity
implements IFluidHandler,
IPipeTile,
ITileBufferHolder,
IDropControlInventory,
ISyncedTile,
ISolidSideTile,
IGuiReturnHandler,
IRedstoneEngineReceiver,
IDebuggable,
IPipeConnection,
ITickable,
IEnergyProvider {
    public boolean initialized = false;
    public final PipeRenderState renderState = new PipeRenderState();
    public final PipePluggableState pluggableState = new PipePluggableState();
    public final CoreState coreState = new CoreState();
    public boolean[] pipeConnectionsBuffer = new boolean[6];
    public Pipe<?> pipe;
    public int redstoneInput;
    public int[] redstoneInputSide = new int[EnumFacing.field_82609_l.length];
    protected boolean deletePipe = false;
    protected boolean sendClientUpdate = false;
    protected boolean blockNeighborChange = false;
    protected int blockNeighborChangedSides = 0;
    protected boolean refreshRenderState = false;
    protected boolean pipeBound = false;
    protected boolean resyncGateExpansions = false;
    protected boolean attachPluggables = false;
    protected SideProperties sideProperties = new SideProperties();
    private TileBuffer[] tileBuffer;
    private int glassColor = -1;

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.glassColor >= 0) {
            nbt.func_74774_a("stainedColor", (byte)this.glassColor);
        }
        for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            String key = "redstoneInputSide[" + i + "]";
            nbt.func_74774_a(key, (byte)this.redstoneInputSide[i]);
        }
        if (this.coreState.pipeId != null) {
            nbt.func_74778_a("pipeId", this.coreState.pipeId);
        } else {
            ResourceLocation loc = this.pipe != null ? (ResourceLocation)Item.field_150901_e.func_177774_c((Object)this.pipe.item) : null;
            String errData = "data=[";
            errData = errData + "pipe=" + (this.pipe == null ? "null" : this.pipe.getClass());
            if (this.pipe != null) {
                errData = errData + ", item=" + this.pipe.item;
                errData = errData + ", class=" + (this.pipe.item == null ? "null" : this.pipe.item.getClass());
                errData = errData + ", id=" + Item.field_150901_e.func_148757_b((Object)this.pipe.item);
            }
            errData = errData + ", loc=" + loc;
            errData = errData + "]";
            if (loc == null) {
                String errLine = "A BuildCraft pipe @ " + this.field_174879_c.toString() + " could not save pipe ID! Please report to developers!";
                BCLog.logger.error(errLine + errData);
            } else {
                String errLine = "A BuildCraft pipe @ " + this.field_174879_c.toString() + " did not have pipe ID, but did have a valid item. Not a fatal error, but please report nonetheless.";
                BCLog.logger.warn(errLine + errData);
                nbt.func_74778_a("pipeId", loc.toString());
            }
        }
        if (this.pipe != null) {
            this.pipe.writeToNBT(nbt);
        }
        this.sideProperties.writeToNBT(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.glassColor = nbt.func_74764_b("stainedColor") ? (int)nbt.func_74771_c("stainedColor") : -1;
        this.redstoneInput = 0;
        for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            String key = "redstoneInputSide[" + i + "]";
            if (nbt.func_74764_b(key)) {
                this.redstoneInputSide[i] = nbt.func_74771_c(key);
                if (this.redstoneInputSide[i] <= this.redstoneInput) continue;
                this.redstoneInput = this.redstoneInputSide[i];
                continue;
            }
            this.redstoneInputSide[i] = 0;
        }
        if (nbt.func_150297_b("pipeId", 8)) {
            this.coreState.pipeId = nbt.func_74779_i("pipeId");
        }
        if (nbt.func_150297_b("pipeId", 99)) {
            int id = nbt.func_74762_e("pipeId");
            Item item = (Item)Item.field_150901_e.func_148754_a(id);
            ResourceLocation loc = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item);
            this.coreState.pipeId = loc == null ? "" : loc.toString();
        }
        if (!StringUtils.func_151246_b((String)this.coreState.pipeId)) {
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(this.coreState.pipeId));
            if (item instanceof ItemPipe) {
                this.pipe = BlockGenericPipe.createPipe((ItemPipe)item);
            } else {
                BCLog.logger.warn(item + " was not an instanceof ItemPipe!" + this.coreState.pipeId);
                this.pipe = null;
            }
        }
        this.bindPipe();
        if (this.pipe != null) {
            this.pipe.readFromNBT(nbt);
        } else {
            BCLog.logger.log(Level.WARN, "Pipe failed to load from NBT at " + this.func_174877_v());
            this.deletePipe = true;
        }
        this.sideProperties.readFromNBT(nbt);
        this.attachPluggables = true;
    }

    public void func_145843_s() {
        this.initialized = false;
        this.tileBuffer = null;
        if (this.pipe != null) {
            this.pipe.invalidate();
        }
        this.sideProperties.invalidate();
        super.func_145843_s();
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.initialized = false;
        this.tileBuffer = null;
        this.bindPipe();
        if (this.pipe != null) {
            this.pipe.validate();
        }
        this.sideProperties.validate(this);
    }

    protected void notifyBlockChanged() {
        this.field_145850_b.func_180496_d(this.func_174877_v(), this.getBlock());
        this.scheduleRenderUpdate();
        this.sendNetworkUpdate();
        if (this.pipe != null) {
            this.pipe.scheduleWireUpdate();
        }
    }

    public void func_73660_a() {
        try {
            if (!this.field_145850_b.field_72995_K) {
                if (this.deletePipe) {
                    this.field_145850_b.func_175698_g(this.func_174877_v());
                }
                if (this.pipe == null || this.coreState.pipeId == null) {
                    return;
                }
                if (!this.initialized) {
                    this.initialize(this.pipe);
                }
            }
            if (this.attachPluggables) {
                this.attachPluggables = false;
                for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
                    if (this.sideProperties.pluggables[i] == null) continue;
                    this.pipe.eventBus.registerHandler(this.sideProperties.pluggables[i]);
                    this.sideProperties.pluggables[i].onAttachedPipe(this, EnumFacing.func_82600_a((int)i));
                }
                this.notifyBlockChanged();
            }
            if (!BlockGenericPipe.isValid(this.pipe)) {
                return;
            }
            this.pipe.updateEntity();
            for (EnumFacing direction : EnumFacing.field_82609_l) {
                PipePluggable p = this.getPipePluggable(direction);
                if (p == null) continue;
                p.update(this, direction);
            }
            if (this.field_145850_b.field_72995_K) {
                if (this.resyncGateExpansions) {
                    this.syncGateExpansions();
                }
                return;
            }
            if (this.blockNeighborChange) {
                for (int i = 0; i < 6; ++i) {
                    if ((this.blockNeighborChangedSides & 1 << i) == 0) continue;
                    this.blockNeighborChangedSides ^= 1 << i;
                    this.computeConnection(EnumFacing.func_82600_a((int)i));
                }
                this.pipe.onNeighborBlockChange(0);
                this.blockNeighborChange = false;
                this.refreshRenderState = true;
            }
            if (this.refreshRenderState) {
                this.refreshRenderState();
                this.refreshRenderState = false;
            }
            if (this.sendClientUpdate) {
                this.sendClientUpdate = false;
                if (!this.field_145850_b.field_72995_K) {
                    Packet updatePacket = this.getBCDescriptionPacket();
                    BuildCraftCore.instance.sendToPlayersNear(updatePacket, this);
                }
            }
        }
        catch (Throwable t) {
            BCLog.logger.warn("CRASH! OH NO!", t);
            Throwables.propagate((Throwable)t);
        }
    }

    public void initializeFromItemMetadata(int i) {
        if (i >= 1 && i <= 16) {
            this.setPipeColor(i - 1 & 0xF);
        } else {
            this.setPipeColor(-1);
        }
    }

    public int getItemMetadata() {
        return this.getPipeColor() >= 0 ? 1 + this.getPipeColor() : 0;
    }

    @Override
    public int getPipeColor() {
        return this.field_145850_b.field_72995_K ? (int)this.renderState.getGlassColor() : this.glassColor;
    }

    public boolean setPipeColor(int color) {
        if (!this.field_145850_b.field_72995_K && color >= -1 && color < 16 && this.glassColor != color) {
            this.glassColor = color;
            this.notifyBlockChanged();
            this.field_145850_b.func_175722_b(this.func_174877_v(), this.getBlock());
            return true;
        }
        return false;
    }

    protected boolean refreshRenderState() {
        boolean bl;
        this.renderState.setGlassColor((byte)this.glassColor);
        for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
            this.renderState.pipeConnectionMatrix.setConnected(enumFacing, this.pipeConnectionsBuffer[enumFacing.ordinal()]);
            if (!this.pipeConnectionsBuffer[enumFacing.ordinal()]) continue;
            BlockPos connected = this.func_174877_v().func_177972_a(enumFacing);
            IBlockState state = this.field_145850_b.func_180495_p(connected);
            Block block = state.func_177230_c();
            ICustomPipeConnection connection = PipeConnectionAPI.getCustomConnection(block);
            if (connection == null) {
                connection = DefaultPipeConnection.INSTANCE;
            }
            this.renderState.setExtension(enumFacing, connection.getExtension(this.field_145850_b, connected, enumFacing, state));
        }
        this.renderState.textureMatrix.setIconIndex(null, this.pipe.getIconIndex(null));
        for (EnumFacing enumFacing : EnumFacing.values()) {
            this.renderState.textureMatrix.setIconIndex(enumFacing, this.pipe.getIconIndex(enumFacing));
        }
        for (PipeWire pipeWire : PipeWire.values()) {
            this.renderState.wireMatrix.setWire(pipeWire, this.pipe.wireSet[pipeWire.ordinal()]);
            for (EnumFacing direction : EnumFacing.field_82609_l) {
                this.renderState.wireMatrix.setWireConnected(pipeWire, direction, this.pipe.isWireConnectedTo(this.getTile(direction), pipeWire, direction));
            }
            boolean lit = this.pipe.signalStrength[pipeWire.ordinal()] > 0;
            this.renderState.wireMatrix.setWireLit(pipeWire, lit);
        }
        for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
            PipePluggable pluggable = this.sideProperties.pluggables[enumFacing.ordinal()];
            if (!(pluggable instanceof FacadePluggable)) continue;
            ItemFacade.FacadeState[] states = ((FacadePluggable)pluggable).states;
            int defaultState = -1;
            int activeState = -1;
            for (int i = 0; i < states.length; ++i) {
                ItemFacade.FacadeState state = states[i];
                if (state.wire == null) {
                    defaultState = i;
                    continue;
                }
                if (this.pipe == null || !this.pipe.isWireActive(state.wire)) continue;
                activeState = i;
                break;
            }
            if (activeState < 0) {
                activeState = defaultState;
            }
            ((FacadePluggable)pluggable).setActiveState(activeState);
        }
        this.pluggableState.setPluggables(this.sideProperties.pluggables);
        boolean bl2 = bl = this.renderState.isDirty() || this.pluggableState.isDirty();
        if (bl) {
            this.sendNetworkUpdate();
            this.renderState.clean();
        }
        return bl;
    }

    public void initialize(Pipe<?> pipe) {
        this.initialized = false;
        this.field_145854_h = this.func_145838_q();
        if (pipe == null) {
            BCLog.logger.log(Level.WARN, "Pipe failed to initialize at {0}, deleting", new Object[]{this.func_174877_v()});
            this.field_145850_b.func_175698_g(this.func_174877_v());
            return;
        }
        this.pipe = pipe;
        for (EnumFacing o : EnumFacing.field_82609_l) {
            TileEntity tile = this.getTile(o);
            if (tile instanceof ITileBufferHolder) {
                ((ITileBufferHolder)tile).blockCreated(o, BuildCraftTransport.genericPipeBlock, this);
            }
            if (!(tile instanceof IPipeTile)) continue;
            ((IPipeTile)tile).scheduleNeighborChange();
        }
        this.bindPipe();
        if (this.coreState.pipeId == null || this.coreState.pipeId.length() <= 0) {
            throw new IllegalStateException("Tried to create a pipe without a pipeID from item " + pipe.item);
        }
        this.computeConnections();
        this.scheduleNeighborChange();
        this.scheduleRenderUpdate();
        if (!pipe.isInitialized()) {
            pipe.initialize();
        }
        this.initialized = true;
    }

    private void bindPipe() {
        if (!this.pipeBound && this.pipe != null) {
            this.pipe.setTile(this);
            this.coreState.pipeId = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)this.pipe.item)).toString();
            this.pipeBound = true;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void scheduleNeighborChange() {
        this.blockNeighborChange = true;
        this.blockNeighborChangedSides = 63;
    }

    public void scheduleNeighborChange(EnumPipePart part) {
        this.blockNeighborChange = true;
        this.blockNeighborChangedSides |= part == EnumPipePart.CENTER ? 63 : 1 << part.ordinal();
    }

    @Override
    public boolean canInjectItems(EnumFacing from) {
        if (this.getPipeType() != IPipeTile.PipeType.ITEM) {
            return false;
        }
        return this.isPipeConnected(from);
    }

    @Override
    public int injectItem(ItemStack payload, boolean doAdd, EnumFacing from, EnumDyeColor color) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof PipeTransportItems && this.isPipeConnected(from) && this.pipe.inputOpen(from)) {
            if (doAdd) {
                Vec3 itemPos = Utils.convertMiddle((Vec3i)this.func_174877_v()).func_178787_e(Utils.convert(from, 0.4));
                TravelingItem pipedItem = TravelingItem.make(itemPos, payload);
                if (pipedItem.isCorrupted()) {
                    return 0;
                }
                pipedItem.color = color;
                ((PipeTransportItems)this.pipe.transport).injectItem(pipedItem, from.func_176734_d());
            }
            return payload.field_77994_a;
        }
        return 0;
    }

    @Override
    public IPipeTile.PipeType getPipeType() {
        if (BlockGenericPipe.isValid(this.pipe)) {
            return ((PipeTransport)this.pipe.transport).getPipeType();
        }
        return null;
    }

    public Packet getBCDescriptionPacket() {
        this.bindPipe();
        this.updateCoreState();
        PacketTileState packet = new PacketTileState(this);
        if (this.pipe != null && this.pipe.transport != null) {
            ((PipeTransport)this.pipe.transport).sendDescriptionPacket();
        }
        packet.addStateForSerialization((byte)0, this.coreState);
        packet.addStateForSerialization((byte)1, this.renderState);
        packet.addStateForSerialization((byte)2, this.pluggableState);
        if (this.pipe instanceof ISerializable) {
            packet.addStateForSerialization((byte)3, (ISerializable)((Object)this.pipe));
        }
        return packet;
    }

    public S35PacketUpdateTileEntity getDescriptionPacket() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("net-type", "desc-packet");
        Packet p = this.getBCDescriptionPacket();
        ByteBuf buf = Unpooled.buffer();
        p.writeData(buf);
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        nbt.func_74773_a("net-data", bytes);
        S35PacketUpdateTileEntity tileUpdate = new S35PacketUpdateTileEntity(this.func_174877_v(), 0, nbt);
        return tileUpdate;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        if (pkt.func_148857_g() == null) {
            throw new RuntimeException("No NBTTag compound! This is a bug!");
        }
        NBTTagCompound nbt = pkt.func_148857_g();
        try {
            if ("desc-packet".equals(nbt.func_74779_i("net-type"))) {
                byte[] bytes = nbt.func_74770_j("net-data");
                ByteBuf data = Unpooled.wrappedBuffer((byte[])bytes);
                PacketTileState p = new PacketTileState();
                p.readData(data);
                p.applyData(this.field_145850_b, null);
            } else {
                BCLog.logger.warn("Recieved a packet with a different type that expected (" + nbt.func_74779_i("net-type") + ")");
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to read a packet! (net-type=\"" + nbt.func_74781_a("net-type") + "\", net-data=\"" + nbt.func_74781_a("net-data") + "\")", t);
        }
    }

    public void sendNetworkUpdate() {
        this.sendClientUpdate = true;
    }

    @Override
    public void blockRemoved(EnumFacing from) {
    }

    public TileBuffer[] getTileCache() {
        if (this.tileBuffer == null && this.pipe != null) {
            this.tileBuffer = TileBuffer.makeBuffer(this.field_145850_b, this.func_174877_v(), ((PipeTransport)this.pipe.transport).delveIntoUnloadedChunks());
        }
        return this.tileBuffer;
    }

    @Override
    public void blockCreated(EnumFacing from, Block block, TileEntity tile) {
        TileBuffer[] cache = this.getTileCache();
        if (cache != null) {
            cache[from.func_176734_d().ordinal()].set(block.func_176223_P(), tile);
        }
    }

    @Override
    public Block getBlock(EnumFacing to) {
        TileBuffer[] cache = this.getTileCache();
        if (cache != null) {
            return cache[to.ordinal()].getBlockState().func_177230_c();
        }
        return null;
    }

    @Override
    public TileEntity getTile(EnumFacing to) {
        return this.getTile(to, false);
    }

    public TileEntity getTile(EnumFacing to, boolean forceUpdate) {
        TileBuffer[] cache = this.getTileCache();
        if (cache != null) {
            return cache[to.ordinal()].getTile(forceUpdate);
        }
        return null;
    }

    protected boolean canPipeConnect_internal(TileEntity with, EnumFacing side) {
        IPipeConnection.ConnectOverride override;
        if (!(this.pipe instanceof IPipeConnectionForced && ((IPipeConnectionForced)((Object)this.pipe)).ignoreConnectionOverrides(side) || !(with instanceof IPipeConnection) || (override = ((IPipeConnection)with).overridePipeConnection(((PipeTransport)this.pipe.transport).getPipeType(), side.func_176734_d())) == IPipeConnection.ConnectOverride.DEFAULT)) {
            return override == IPipeConnection.ConnectOverride.CONNECT;
        }
        if (with instanceof IPipeTile) {
            IPipeTile other = (IPipeTile)with;
            if (other.hasBlockingPluggable(side.func_176734_d())) {
                return false;
            }
            if (other.getPipeColor() >= 0 && this.glassColor >= 0 && other.getPipeColor() != this.glassColor) {
                return false;
            }
            Pipe otherPipe = (Pipe)other.getPipe();
            if (!BlockGenericPipe.isValid(otherPipe)) {
                return false;
            }
            if (!otherPipe.canPipeConnect(this, side.func_176734_d())) {
                return false;
            }
        }
        return this.pipe.canPipeConnect(with, side);
    }

    protected boolean canPipeConnect(TileEntity with, EnumFacing side) {
        if (with == null) {
            return false;
        }
        if (this.hasBlockingPluggable(side)) {
            return false;
        }
        if (!BlockGenericPipe.isValid(this.pipe)) {
            return false;
        }
        if (!with.func_145830_o() && this.func_145830_o()) {
            with.func_145834_a(this.field_145850_b);
        }
        return this.canPipeConnect_internal(with, side);
    }

    @Override
    public boolean hasBlockingPluggable(EnumFacing side) {
        IPipe neighborPipe;
        PipePluggable pluggable = this.getPipePluggable(side);
        if (pluggable == null) {
            return false;
        }
        if (pluggable instanceof IPipeConnection && (neighborPipe = this.getNeighborPipe(side)) != null) {
            IPipeConnection.ConnectOverride override = ((IPipeConnection)((Object)pluggable)).overridePipeConnection(neighborPipe.getTile().getPipeType(), side);
            if (override == IPipeConnection.ConnectOverride.CONNECT) {
                return true;
            }
            if (override == IPipeConnection.ConnectOverride.DISCONNECT) {
                return false;
            }
        }
        return pluggable.isBlocking(this, side);
    }

    protected void computeConnections() {
        for (EnumFacing face : EnumFacing.values()) {
            this.computeConnection(face);
        }
    }

    protected void computeConnection(EnumFacing side) {
        TileBuffer[] cache = this.getTileCache();
        if (cache == null) {
            return;
        }
        this.pipeConnectionsBuffer[side.ordinal()] = this.canPipeConnect(this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side)), side);
    }

    @Override
    public boolean isPipeConnected(EnumFacing with) {
        if (with == null) {
            return false;
        }
        if (this.field_145850_b.field_72995_K) {
            return this.renderState.pipeConnectionMatrix.isConnected(with);
        }
        return this.pipeConnectionsBuffer[with.ordinal()];
    }

    @Override
    public boolean doDrop() {
        if (BlockGenericPipe.isValid(this.pipe)) {
            return this.pipe.doDrop();
        }
        return false;
    }

    public void onChunkUnload() {
        if (this.pipe != null) {
            this.pipe.onChunkUnload();
        }
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.hasBlockingPluggable(from)) {
            return ((IFluidHandler)this.pipe.transport).fill(from, resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.hasBlockingPluggable(from)) {
            return ((IFluidHandler)this.pipe.transport).drain(from, maxDrain, doDrain);
        }
        return null;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.hasBlockingPluggable(from)) {
            return ((IFluidHandler)this.pipe.transport).drain(from, resource, doDrain);
        }
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.hasBlockingPluggable(from)) {
            return ((IFluidHandler)this.pipe.transport).canFill(from, fluid);
        }
        return false;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.hasBlockingPluggable(from)) {
            return ((IFluidHandler)this.pipe.transport).canDrain(from, fluid);
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return null;
    }

    @Override
    public void scheduleRenderUpdate() {
        this.refreshRenderState = true;
    }

    public boolean hasFacade(EnumFacing direction) {
        if (direction == null) {
            return false;
        }
        return this.sideProperties.pluggables[direction.ordinal()] instanceof IFacadePluggable;
    }

    public boolean hasGate(EnumFacing direction) {
        if (direction == null) {
            return false;
        }
        return this.sideProperties.pluggables[direction.ordinal()] instanceof GatePluggable;
    }

    public boolean setPluggable(EnumFacing direction, PipePluggable pluggable) {
        return this.setPluggable(direction, pluggable, null);
    }

    public boolean setPluggable(EnumFacing direction, PipePluggable pluggable, EntityPlayer player) {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            return false;
        }
        if (direction == null) {
            return false;
        }
        if (this.sideProperties.pluggables[direction.ordinal()] != null) {
            this.sideProperties.dropItem(this, direction, player);
            this.pipe.eventBus.unregisterHandler(this.sideProperties.pluggables[direction.ordinal()]);
        }
        this.sideProperties.pluggables[direction.ordinal()] = pluggable;
        if (pluggable != null) {
            this.pipe.eventBus.registerHandler(pluggable);
            pluggable.onAttachedPipe(this, direction);
        }
        this.notifyBlockChanged();
        this.field_145850_b.func_175722_b(this.func_174877_v(), this.getBlock());
        return true;
    }

    protected void updateCoreState() {
    }

    public boolean hasEnabledFacade(EnumFacing direction) {
        return this.hasFacade(direction) && !((FacadePluggable)this.getPipePluggable(direction)).isTransparent();
    }

    public void setGate(Gate gate, int direction) {
        if (this.sideProperties.pluggables[direction] == null) {
            gate.setDirection(EnumFacing.func_82600_a((int)direction));
            this.pipe.gates[direction] = gate;
            this.sideProperties.pluggables[direction] = new GatePluggable(gate);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIconProvider getPipeIcons() {
        if (this.pipe == null) {
            return null;
        }
        return this.pipe.getIconProvider();
    }

    @Override
    public ISerializable getStateInstance(byte stateId) {
        switch (stateId) {
            case 0: {
                return this.coreState;
            }
            case 1: {
                return this.renderState;
            }
            case 2: {
                return this.pluggableState;
            }
            case 3: {
                return (ISerializable)((Object)this.pipe);
            }
        }
        throw new RuntimeException("Unknown state requested: " + stateId + " this is a bug!");
    }

    @Override
    public void afterStateUpdated(byte stateId) {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        switch (stateId) {
            case 0: {
                if (this.pipe != null) break;
                if (this.pipe == null && this.coreState.pipeId != null) {
                    this.initialize(BlockGenericPipe.createPipe((ItemPipe)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(this.coreState.pipeId))));
                }
                if (this.pipe == null) break;
                this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
                break;
            }
            case 1: {
                if (!this.renderState.needsRenderUpdate()) break;
                this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
                this.renderState.clean();
                break;
            }
            case 2: {
                int i;
                PipePluggable[] newPluggables = this.pluggableState.getPluggables();
                for (i = 0; i < EnumFacing.field_82609_l.length; ++i) {
                    PipePluggable old = this.sideProperties.pluggables[i];
                    PipePluggable newer = newPluggables[i];
                    if (old == null && newer == null) continue;
                    if (old != null && newer != null && old.getClass() == newer.getClass()) {
                        if (!newer.requiresRenderUpdate(old)) continue;
                        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
                        break;
                    }
                    this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
                    break;
                }
                this.sideProperties.pluggables = (PipePluggable[])newPluggables.clone();
                for (i = 0; i < EnumFacing.field_82609_l.length; ++i) {
                    PipePluggable pluggable = this.getPipePluggable(EnumFacing.func_82600_a((int)i));
                    if (pluggable != null && pluggable instanceof GatePluggable) {
                        GatePluggable gatePluggable = (GatePluggable)pluggable;
                        Gate gate = this.pipe.gates[i];
                        if (gate != null && gate.logic == gatePluggable.getLogic() && gate.material == gatePluggable.getMaterial()) continue;
                        this.pipe.gates[i] = GateFactory.makeGate(this.pipe, gatePluggable.getMaterial(), gatePluggable.getLogic(), EnumFacing.func_82600_a((int)i));
                        continue;
                    }
                    this.pipe.gates[i] = null;
                }
                this.syncGateExpansions();
                break;
            }
        }
    }

    private void syncGateExpansions() {
        this.resyncGateExpansions = false;
        for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            GatePluggable gatePluggable;
            Gate gate = this.pipe.gates[i];
            if (gate == null || (gatePluggable = (GatePluggable)this.sideProperties.pluggables[i]).getExpansions().length <= 0) continue;
            for (IGateExpansion expansion : gatePluggable.getExpansions()) {
                if (expansion != null) {
                    if (gate.expansions.containsKey((Object)expansion)) continue;
                    gate.addGateExpansion(expansion);
                    continue;
                }
                this.resyncGateExpansions = true;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return DefaultProps.PIPE_CONTENTS_RENDER_DIST * DefaultProps.PIPE_CONTENTS_RENDER_DIST;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public boolean isSolidOnSide(EnumFacing side) {
        if (this.hasPipePluggable(side) && this.getPipePluggable(side).isSolidOnSide(this, side)) {
            return true;
        }
        return BlockGenericPipe.isValid(this.pipe) && this.pipe instanceof ISolidSideTile && ((ISolidSideTile)((Object)this.pipe)).isSolidOnSide(side);
    }

    @Override
    public PipePluggable getPipePluggable(EnumFacing side) {
        if (side == null) {
            return null;
        }
        return this.sideProperties.pluggables[side.ordinal()];
    }

    @Override
    public boolean hasPipePluggable(EnumFacing side) {
        if (side == null) {
            return false;
        }
        return this.sideProperties.pluggables[side.ordinal()] != null;
    }

    public Block getBlock() {
        return this.func_145838_q();
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this;
    }

    @Override
    public void writeGuiData(ByteBuf data) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe instanceof IGuiReturnHandler) {
            ((IGuiReturnHandler)((Object)this.pipe)).writeGuiData(data);
        }
    }

    @Override
    public void readGuiData(ByteBuf data, EntityPlayer sender) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe instanceof IGuiReturnHandler) {
            ((IGuiReturnHandler)((Object)this.pipe)).readGuiData(data, sender);
        }
    }

    private IEnergyHandler internalGetEnergyHandler(EnumFacing side) {
        if (this.hasPipePluggable(side)) {
            PipePluggable pluggable = this.getPipePluggable(side);
            if (pluggable instanceof IEnergyHandler) {
                return (IEnergyHandler)((Object)pluggable);
            }
            if (pluggable.isBlocking(this, side)) {
                return null;
            }
        }
        if (this.pipe instanceof IEnergyHandler) {
            return (IEnergyHandler)((Object)this.pipe);
        }
        return null;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        IEnergyHandler handler = this.internalGetEnergyHandler(from);
        if (handler != null) {
            return handler.canConnectEnergy(from);
        }
        return false;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        IEnergyHandler handler = this.internalGetEnergyHandler(from);
        if (handler instanceof IEnergyReceiver) {
            return ((IEnergyReceiver)handler).receiveEnergy(from, maxReceive, simulate);
        }
        return 0;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        IEnergyHandler handler = this.internalGetEnergyHandler(from);
        if (handler instanceof IEnergyProvider) {
            return ((IEnergyProvider)handler).extractEnergy(from, maxExtract, simulate);
        }
        return 0;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        IEnergyHandler handler = this.internalGetEnergyHandler(from);
        if (handler != null) {
            return handler.getEnergyStored(from);
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        IEnergyHandler handler = this.internalGetEnergyHandler(from);
        if (handler != null) {
            return handler.getMaxEnergyStored(from);
        }
        return 0;
    }

    @Override
    public Block getNeighborBlock(EnumFacing dir) {
        return this.getBlock(dir);
    }

    @Override
    public TileEntity getNeighborTile(EnumFacing dir) {
        return this.getTile(dir);
    }

    @Override
    public IPipe getNeighborPipe(EnumFacing dir) {
        TileEntity neighborTile = this.getTile(dir);
        if (neighborTile instanceof IPipeTile) {
            return ((IPipeTile)neighborTile).getPipe();
        }
        return null;
    }

    @Override
    public IPipe getPipe() {
        return this.pipe;
    }

    @Override
    public boolean canConnectRedstoneEngine(EnumFacing side) {
        if (this.pipe instanceof IRedstoneEngineReceiver) {
            return ((IRedstoneEngineReceiver)((Object)this.pipe)).canConnectRedstoneEngine(side);
        }
        return this.getPipeType() != IPipeTile.PipeType.POWER && this.getPipeType() != IPipeTile.PipeType.STRUCTURE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        TileGenericPipe server = CoreProxy.proxy.getServerTile(this);
        int glassColor = server.getPipeColor();
        if (glassColor >= 0 && glassColor < 16) {
            left.add("");
            left.add("Colour = " + EnumDyeColor.values()[glassColor]);
        }
        if (server.pipe instanceof IDebuggable) {
            ((IDebuggable)((Object)server.pipe)).getDebugInfo(left, right, side);
        }
        if (server.pipe.transport instanceof IDebuggable) {
            ((IDebuggable)server.pipe.transport).getDebugInfo(left, right, side);
        }
        if (server.getPipePluggable(side) != null && server.getPipePluggable(side) instanceof IDebuggable) {
            ((IDebuggable)((Object)server.getPipePluggable(side))).getDebugInfo(left, right, side);
        }
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, EnumFacing with) {
        if (type == IPipeTile.PipeType.POWER && this.hasPipePluggable(with) && this.getPipePluggable(with) instanceof IEnergyHandler) {
            return IPipeConnection.ConnectOverride.CONNECT;
        }
        return IPipeConnection.ConnectOverride.DEFAULT;
    }

    @Override
    public World getWorldBC() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getPosBC() {
        return this.func_174877_v();
    }

    public static class SideProperties {
        PipePluggable[] pluggables = new PipePluggable[EnumFacing.field_82609_l.length];

        public void writeToNBT(NBTTagCompound nbt) {
            for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
                PipePluggable pluggable = this.pluggables[i];
                String key = "pluggable[" + i + "]";
                if (pluggable == null) {
                    nbt.func_82580_o(key);
                    continue;
                }
                NBTTagCompound pluggableData = new NBTTagCompound();
                pluggableData.func_74778_a("pluggableName", PipeManager.getPluggableName(pluggable.getClass()));
                pluggable.writeToNBT(pluggableData);
                nbt.func_74782_a(key, (NBTBase)pluggableData);
            }
        }

        public void readFromNBT(NBTTagCompound nbt) {
            int i;
            for (i = 0; i < EnumFacing.field_82609_l.length; ++i) {
                String key = "pluggable[" + i + "]";
                if (!nbt.func_74764_b(key)) continue;
                try {
                    NBTTagCompound pluggableData = nbt.func_74775_l(key);
                    Class<?> pluggableClass = PipeManager.getPluggableByName(pluggableData.func_74779_i("pluggableName"));
                    if (pluggableClass == null) continue;
                    if (!PipePluggable.class.isAssignableFrom(pluggableClass)) {
                        BCLog.logger.warn("Wrong pluggable class: " + pluggableClass);
                        continue;
                    }
                    PipePluggable pluggable = (PipePluggable)pluggableClass.newInstance();
                    pluggable.readFromNBT(pluggableData);
                    this.pluggables[i] = pluggable;
                    continue;
                }
                catch (Exception e) {
                    BCLog.logger.warn("Failed to load side state");
                    e.printStackTrace();
                }
            }
            for (i = 0; i < EnumFacing.field_82609_l.length; ++i) {
                PipePluggable pluggable = null;
                if (nbt.func_74764_b("facadeState[" + i + "]")) {
                    pluggable = new FacadePluggable(ItemFacade.FacadeState.readArray(nbt.func_150295_c("facadeState[" + i + "]", 10)));
                }
                if (nbt.func_74767_n("plug[" + i + "]")) {
                    pluggable = new PlugPluggable();
                }
                if (pluggable == null) continue;
                this.pluggables[i] = pluggable;
            }
        }

        public void rotateLeft() {
            PipePluggable[] newPluggables = new PipePluggable[EnumFacing.field_82609_l.length];
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                EnumFacing rotated = dir.func_176740_k() == EnumFacing.Axis.Y ? dir : dir.func_176746_e();
                newPluggables[rotated.ordinal()] = this.pluggables[dir.ordinal()];
            }
            this.pluggables = newPluggables;
        }

        public boolean dropItem(TileGenericPipe pipe, EnumFacing direction, EntityPlayer player) {
            boolean result = false;
            PipePluggable pluggable = this.pluggables[direction.ordinal()];
            if (pluggable != null) {
                ItemStack[] stacks;
                pluggable.onDetachedPipe(pipe, direction);
                if (!pipe.func_145831_w().field_72995_K && (stacks = pluggable.getDropItems(pipe)) != null) {
                    for (ItemStack stack : stacks) {
                        Utils.dropTryIntoPlayerInventory(pipe.field_145850_b, pipe.field_174879_c, stack, player);
                    }
                }
                result = true;
            }
            return result;
        }

        public void invalidate() {
            for (PipePluggable p : this.pluggables) {
                if (p == null) continue;
                p.invalidate();
            }
        }

        public void validate(TileGenericPipe pipe) {
            for (EnumFacing d : EnumFacing.field_82609_l) {
                PipePluggable p = this.pluggables[d.ordinal()];
                if (p == null) continue;
                p.validate(pipe, d);
            }
        }
    }

    public static class CoreState
    implements ISerializable,
    Comparable<CoreState> {
        public String pipeId = null;

        @Override
        public void writeData(ByteBuf data) {
            NetworkUtils.writeUTF(data, this.pipeId);
        }

        @Override
        public void readData(ByteBuf data) {
            this.pipeId = NetworkUtils.readUTF(data);
        }

        @Override
        public int compareTo(CoreState o) {
            return 0;
        }
    }
}

