/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.PipeTransportPower;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class PipeToolTipManager {
    private static final Map<Class<? extends Pipe<?>>, String> toolTips = new HashMap();
    private static final Map<Class<? extends Pipe<?>>, String> shiftToolTips = new HashMap();

    private PipeToolTipManager() {
    }

    private static void addTipToList(String tipTag, List<String> tips) {
        String localized;
        if (BCStringUtils.canLocalize(tipTag) && (localized = BCStringUtils.localize(tipTag)) != null) {
            List lines = BCStringUtils.newLineSplitter.splitToList((CharSequence)localized);
            tips.addAll(lines);
        }
    }

    public static void addToolTip(Class<? extends Pipe<?>> pipe, String toolTip) {
        toolTips.put(pipe, toolTip);
    }

    public static void addShiftToolTip(Class<? extends Pipe<?>> pipe, String toolTip) {
        shiftToolTips.put(pipe, toolTip);
    }

    public static List<String> getToolTip(Class<? extends Pipe<?>> pipe, boolean advanced) {
        ArrayList<String> tips = new ArrayList<String>();
        PipeToolTipManager.addTipToList("tip." + pipe.getSimpleName(), tips);
        String tip = toolTips.get(pipe);
        if (tip != null) {
            tips.add(tip);
        }
        if (GuiScreen.func_146272_n()) {
            tip = shiftToolTips.get(pipe);
            if (tip != null) {
                tips.add(EnumChatFormatting.GRAY + tip);
            }
            PipeToolTipManager.addTipToList("tip.shift." + pipe.getSimpleName(), tips);
        }
        return tips;
    }

    static {
        if (!BuildCraftCore.hidePowerNumbers) {
            for (Map.Entry<Class<Pipe<?>>, Integer> pipe : PipeTransportPower.powerCapacities.entrySet()) {
                PipeToolTipManager.addToolTip(pipe.getKey(), String.format("%d RF/t", pipe.getValue()));
                DecimalFormat format = new DecimalFormat();
                format.setMinimumFractionDigits(0);
                format.setMaximumFractionDigits(2);
                switch (PipeTransportPower.lossMode) {
                    case ABSOLUTE: {
                        float f1 = PipeTransportPower.powerLosses.get(pipe.getKey()).floatValue();
                        if (f1 == 0.0f) break;
                        PipeToolTipManager.addShiftToolTip(pipe.getKey(), String.format("Loss: %s RF/pipe", format.format(f1)));
                        break;
                    }
                    case PERCENTAGE: {
                        float f2 = PipeTransportPower.powerResistances.get(pipe.getKey()).floatValue();
                        if (f2 == 0.0f) break;
                        PipeToolTipManager.addShiftToolTip(pipe.getKey(), String.format("Loss: %s%%/pipe", format.format(f2)));
                    }
                }
            }
        }
        if (!BuildCraftCore.hideFluidNumbers) {
            for (Map.Entry<Class<Pipe<?>>, Integer> pipe : PipeTransportFluids.fluidCapacities.entrySet()) {
                PipeToolTipManager.addToolTip(pipe.getKey(), String.format("%d mB/t", pipe.getValue()));
            }
        }
    }
}

