/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.core.ISerializable;
import buildcraft.api.transport.PipeManager;
import buildcraft.api.transport.pluggable.IConnectionMatrix;
import buildcraft.api.transport.pluggable.IPipePluggableState;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.transport.utils.ConnectionMatrix;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.EnumFacing;

public class PipePluggableState
implements ISerializable,
IPipePluggableState,
Comparable<PipePluggableState> {
    private PipePluggable[] pluggables = new PipePluggable[6];
    private final ConnectionMatrix pluggableMatrix = new ConnectionMatrix();
    private boolean isDirty = true;

    public PipePluggable[] getPluggables() {
        return this.pluggables;
    }

    public void setPluggables(PipePluggable[] pluggables) {
        for (int i = 0; i < 6; ++i) {
            if (pluggables[i] == null) {
                if (this.pluggables[i] == null) continue;
                this.isDirty = true;
                continue;
            }
            this.isDirty = this.pluggables[i] == null ? true : (this.pluggables[i].getClass() != pluggables[i].getClass() ? true : true);
        }
        this.pluggables = pluggables;
    }

    @Override
    public void writeData(ByteBuf data) {
        this.pluggableMatrix.clean();
        for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
            this.pluggableMatrix.setConnected(enumFacing, this.pluggables[enumFacing.ordinal()] != null);
        }
        this.pluggableMatrix.writeData(data);
        for (PipePluggable pipePluggable : this.pluggables) {
            if (pipePluggable == null) continue;
            data.writeShort(PipeManager.pipePluggables.indexOf(pipePluggable.getClass()));
            pipePluggable.writeData(data);
        }
    }

    @Override
    public void readData(ByteBuf data) {
        this.pluggableMatrix.readData(data);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (this.pluggableMatrix.isConnected(dir)) {
                PipePluggable old = this.pluggables[dir.ordinal()];
                try {
                    Class<? extends PipePluggable> pc = PipeManager.pipePluggables.get(data.readUnsignedShort());
                    if (this.pluggables[dir.ordinal()] == null || pc != this.pluggables[dir.ordinal()].getClass()) {
                        PipePluggable p;
                        this.pluggables[dir.ordinal()] = p = pc.newInstance();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.pluggables[dir.ordinal()] == null) continue;
                this.pluggables[dir.ordinal()].readData(data);
                continue;
            }
            this.pluggables[dir.ordinal()] = null;
        }
    }

    @Override
    public IConnectionMatrix getPluggableConnections() {
        return this.pluggableMatrix;
    }

    @Override
    public PipePluggable getPluggable(EnumFacing face) {
        if (face == null) {
            return null;
        }
        return this.pluggables[face.ordinal()];
    }

    @Override
    public int compareTo(PipePluggableState o) {
        return 0;
    }

    public void clean() {
        this.isDirty = false;
        this.pluggableMatrix.clean();
    }

    public boolean isDirty() {
        return this.isDirty || this.pluggableMatrix.isDirty();
    }
}

