/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.JavaTools;
import buildcraft.api.facades.FacadeType;
import buildcraft.api.facades.IFacadeItem;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.PipeWire;
import buildcraft.api.transport.pluggable.IPipePluggableItem;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.lib.items.ItemBuildCraft;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.FacadePluggable;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ItemFacade
extends ItemBuildCraft
implements IFacadeItem,
IPipePluggableItem {
    public static final ArrayList<ItemStack> allFacades = new ArrayList();
    public static final ArrayList<ItemStack> allHollowFacades = new ArrayList();
    public static final ArrayList<String> allFacadeIDs = new ArrayList();
    public static final ArrayList<String> blacklistedFacades = new ArrayList();
    private static final Block NULL_BLOCK = null;
    private static final ItemStack NO_MATCH = new ItemStack(NULL_BLOCK, 0, 0);
    private static final Block[] PREVIEW_FACADES = new Block[]{Blocks.field_150344_f, Blocks.field_150417_aV, Blocks.field_150359_w};
    private static int RANDOM_FACADE_ID = -1;

    public ItemFacade() {
        super(BuildCraftTransport.showAllFacadesCreative ? BCCreativeTab.get("facades") : BCCreativeTab.get("main"));
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public String func_77653_i(ItemStack itemstack) {
        switch (this.getFacadeType(itemstack)) {
            case Basic: {
                FacadeState[] states = ItemFacade.getFacadeStates(itemstack);
                String displayName = states.length > 0 ? ItemFacade.getFacadeStateDisplayName(states[0]) : "CORRUPT";
                return super.func_77653_i(itemstack) + ": " + displayName;
            }
            case Phased: {
                return BCStringUtils.localize("item.FacadePhased.name");
            }
        }
        return "";
    }

    @Override
    public String func_77667_c(ItemStack itemstack) {
        return "item.Facade";
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean debug) {
        for (FacadeState state : ItemFacade.getFacadeStates(stack)) {
            if (state == null || state.transparent || state.state == null || Item.func_150898_a((Block)state.state.func_177230_c()) == null) continue;
            Item.func_150898_a((Block)state.state.func_177230_c()).func_77624_a(new ItemStack(state.state.func_177230_c(), 1, state.state.func_177230_c().func_176201_c(state.state)), player, list, debug);
        }
        if (this.getFacadeType(stack) == FacadeType.Phased) {
            String stateString = BCStringUtils.localize("item.FacadePhased.state");
            FacadeState defaultState = null;
            for (FacadeState state : ItemFacade.getFacadeStates(stack)) {
                if (state.wire == null) {
                    defaultState = state;
                    continue;
                }
                list.add(String.format(stateString, state.wire.getColor(), ItemFacade.getFacadeStateDisplayName(state)));
            }
            if (defaultState != null) {
                list.add(1, String.format(BCStringUtils.localize("item.FacadePhased.state_default"), ItemFacade.getFacadeStateDisplayName(defaultState)));
            }
        }
    }

    public static String getFacadeStateDisplayName(FacadeState state) {
        if (state.state == null) {
            return BCStringUtils.localize("item.FacadePhased.state_transparent");
        }
        String s = CoreProxy.proxy.getItemDisplayName(new ItemStack(state.state.func_177230_c(), 1, state.state.func_177230_c().func_176201_c(state.state)));
        if (state.hollow) {
            s = s + " (" + BCStringUtils.localize("item.Facade.state_hollow") + ")";
        }
        return s;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        if (BuildCraftTransport.showAllFacadesCreative) {
            for (ItemStack stack : allFacades) {
                itemList.add(stack);
            }
            for (ItemStack stack : allHollowFacades) {
                itemList.add(stack);
            }
        } else {
            ArrayList<ItemStack> hollowFacades = new ArrayList<ItemStack>();
            for (Block b : PREVIEW_FACADES) {
                if (!ItemFacade.isBlockValidForFacade(b.func_176203_a(0)) || ItemFacade.isBlockBlacklisted(b)) continue;
                ItemStack facade = this.getFacadeForBlock(b.func_176203_a(0));
                itemList.add(facade);
                FacadeState state = ItemFacade.getFacadeStates(facade)[0];
                hollowFacades.add(ItemFacade.getFacade(new FacadeState(state.state, state.wire, true)));
            }
            if (RANDOM_FACADE_ID < 0) {
                RANDOM_FACADE_ID = BuildCraftCore.random.nextInt(allFacades.size());
            }
            itemList.add(allFacades.get(RANDOM_FACADE_ID));
            itemList.addAll(hollowFacades);
            itemList.add(allHollowFacades.get(RANDOM_FACADE_ID));
        }
    }

    public void initialize() {
        for (Object o : Block.field_149771_c) {
            Block b = (Block)o;
            Item item = Item.func_150898_a((Block)b);
            if (item == null || ItemFacade.isBlockBlacklisted(b)) continue;
            this.registerValidFacades(b, item);
        }
    }

    private void registerValidFacades(Block block, Item item) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(16);
        HashSet<IBlockState> states = new HashSet<IBlockState>();
        try {
            if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
                for (CreativeTabs ct : item.getCreativeTabs()) {
                    block.func_149666_a(item, ct, stacks);
                }
            } else {
                for (int i = 0; i < 16; ++i) {
                    try {
                        IBlockState state = block.func_176203_a(i);
                        if (state == null || states.contains(state)) continue;
                        states.add(state);
                        stacks.add(new ItemStack(item, 1, i));
                        continue;
                    }
                    catch (Exception state) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (ItemStack stack : stacks) {
            try {
                if (block.hasTileEntity(block.func_176223_P())) continue;
                try {
                    if (stack.func_82833_r() == null) continue;
                    if (Strings.isNullOrEmpty((String)stack.func_77977_a())) {
                    }
                }
                catch (Throwable t) {}
                continue;
                this.addFacade(stack);
            }
            catch (IndexOutOfBoundsException t) {
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private static boolean isBlockBlacklisted(Block block) {
        String blockName = Utils.getNameForBlock(block);
        if (blockName == null) {
            return true;
        }
        for (String blacklistedBlock : blacklistedFacades) {
            if (!blockName.equals(blacklistedBlock)) continue;
            return true;
        }
        for (String blacklistedBlock : BuildCraftTransport.facadeBlacklist) {
            if (!blockName.equals(JavaTools.stripSurroundingQuotes(blacklistedBlock))) continue;
            return true ^ BuildCraftTransport.facadeTreatBlacklistAsWhitelist;
        }
        return false ^ BuildCraftTransport.facadeTreatBlacklistAsWhitelist;
    }

    public static boolean isTransparentFacade(IBlockState state) {
        Block block = state.func_177230_c();
        return !block.func_176214_u() && !block.func_149662_c();
    }

    private static boolean isBlockValidForFacade(IBlockState state) {
        try {
            Block block = state.func_177230_c();
            if (block instanceof BlockStainedGlass) {
                return true;
            }
            if (!block.func_149730_j() || !block.func_149686_d() || block.hasTileEntity(state)) {
                return false;
            }
            if (block.func_149704_x() != 0.0 || block.func_149665_z() != 0.0 || block.func_149706_B() != 0.0) {
                return false;
            }
            return block.func_149753_y() == 1.0 && block.func_149669_A() == 1.0 && block.func_149693_C() == 1.0;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public static FacadeState[] getFacadeStates(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return new FacadeState[0];
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (!(nbt = ItemFacade.migrate(stack, nbt)).func_74764_b("states")) {
            return new FacadeState[0];
        }
        return FacadeState.readArray(nbt.func_150295_c("states", 10));
    }

    private static NBTTagCompound migrate(ItemStack stack, NBTTagCompound nbt) {
        Block block = null;
        Block blockAlt = null;
        int metadata = 0;
        PipeWire wire = null;
        if (nbt.func_74764_b("id")) {
            block = (Block)Block.field_149771_c.func_148754_a(nbt.func_74762_e("id"));
        } else if (nbt.func_74764_b("name")) {
            block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(nbt.func_74779_i("name")));
        }
        if (nbt.func_74764_b("name_alt")) {
            blockAlt = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(nbt.func_74779_i("name_alt")));
        }
        if (nbt.func_74764_b("meta")) {
            metadata = nbt.func_74762_e("meta");
        }
        int metadataAlt = nbt.func_74764_b("meta_alt") ? nbt.func_74762_e("meta_alt") : stack.func_77952_i() & 0xF;
        if (nbt.func_74764_b("wire")) {
            wire = PipeWire.fromOrdinal(nbt.func_74762_e("wire"));
        }
        if (block != null) {
            FacadeState[] states;
            FacadeState mainState = FacadeState.create(block.func_176203_a(metadata));
            if (blockAlt != null && wire != null) {
                FacadeState altState = FacadeState.create(blockAlt.func_176203_a(metadataAlt), wire);
                states = new FacadeState[]{mainState, altState};
            } else {
                states = new FacadeState[]{mainState};
            }
            NBTTagCompound newNbt = ItemFacade.getFacade(states).func_77978_p();
            stack.func_77982_d(newNbt);
            return newNbt;
        }
        return nbt;
    }

    @Override
    public IBlockState[] getBlockStatesForFacade(ItemStack stack) {
        FacadeState[] states = ItemFacade.getFacadeStates(stack);
        IBlockState[] blocks = new IBlockState[states.length];
        for (int i = 0; i < states.length; ++i) {
            blocks[i] = states[i].state;
        }
        return blocks;
    }

    @Override
    public FacadeType getFacadeType(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return FacadeType.Basic;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (!nbt.func_74764_b("type")) {
            return FacadeType.Basic;
        }
        return FacadeType.fromOrdinal(nbt.func_74762_e("type"));
    }

    @Override
    public boolean doesSneakBypassUse(World world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public void addFacade(ItemStack itemStack) {
        Block block;
        if (itemStack.field_77994_a == 0) {
            itemStack.field_77994_a = 1;
        }
        if ((block = Block.func_149634_a((Item)itemStack.func_77973_b())) == null) {
            return;
        }
        IBlockState bstate = block.func_176203_a(itemStack.func_77952_i());
        if (!ItemFacade.isBlockValidForFacade(bstate)) {
            return;
        }
        String recipeId = "buildcraft:facade{" + Utils.getNameForBlock(block) + "#" + itemStack.func_77952_i() + "}";
        ItemStack facade = this.getFacadeForBlock(bstate);
        ItemStack realStack = itemStack.func_77946_l();
        realStack.func_77964_b(block.func_180651_a(bstate));
        if (!allFacadeIDs.contains(recipeId)) {
            allFacadeIDs.add(recipeId);
            allFacades.add(facade);
            ItemStack facade6 = facade.func_77946_l();
            facade6.field_77994_a = 6;
            FacadeState state = ItemFacade.getFacadeStates(facade6)[0];
            ItemStack facadeHollow = ItemFacade.getFacade(new FacadeState(state.state, state.wire, true));
            allHollowFacades.add(facadeHollow);
            ItemStack facade6Hollow = facadeHollow.func_77946_l();
            facade6Hollow.field_77994_a = 6;
            if (Loader.isModLoaded((String)"BuildCraft|Silicon") && !BuildCraftTransport.facadeForceNonLaserRecipe) {
                BuildcraftRecipeRegistry.assemblyTable.addRecipe(recipeId, 8000, facade6, new ItemStack(BuildCraftTransport.pipeStructureCobblestone, 3), itemStack);
                BuildcraftRecipeRegistry.assemblyTable.addRecipe(recipeId + ":hollow", 8000, facade6Hollow, new ItemStack(BuildCraftTransport.pipeStructureCobblestone, 3), itemStack);
                BuildcraftRecipeRegistry.assemblyTable.addRecipe(recipeId + ":toHollow", 160, facadeHollow, facade);
                BuildcraftRecipeRegistry.assemblyTable.addRecipe(recipeId + ":fromHollow", 160, facade, facadeHollow);
            } else {
                GameRegistry.addShapedRecipe((ItemStack)facade6, (Object[])new Object[]{"t ", "ts", "t ", Character.valueOf('t'), realStack, Character.valueOf('s'), BuildCraftTransport.pipeStructureCobblestone});
                GameRegistry.addShapedRecipe((ItemStack)facade6Hollow, (Object[])new Object[]{"t ", " s", "t ", Character.valueOf('t'), realStack, Character.valueOf('s'), BuildCraftTransport.pipeStructureCobblestone});
            }
        }
    }

    public static void blacklistFacade(String blockName) {
        if (!blacklistedFacades.contains(blockName)) {
            blacklistedFacades.add(blockName);
        }
    }

    @Override
    public ItemStack getFacadeForBlock(IBlockState state) {
        return ItemFacade.getFacade(FacadeState.create(state));
    }

    public static ItemStack getAdvancedFacade(PipeWire wire, IBlockState state, IBlockState stateAlt) {
        return ItemFacade.getFacade(FacadeState.create(state), FacadeState.create(stateAlt, wire));
    }

    public static ItemStack getFacade(FacadeState ... states) {
        if (states == null || states.length == 0) {
            return null;
        }
        boolean basic = states.length == 1 && states[0].wire == null;
        ItemStack stack = new ItemStack((Item)BuildCraftTransport.facadeItem, 1, 0);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("type", (byte)(basic ? FacadeType.Basic : FacadeType.Phased).ordinal());
        nbt.func_74782_a("states", (NBTBase)FacadeState.writeArray(states));
        stack.func_77982_d(nbt);
        return stack;
    }

    @Override
    public PipePluggable createPipePluggable(IPipe pipe, EnumFacing side, ItemStack stack) {
        return new FacadePluggable(ItemFacade.getFacadeStates(stack));
    }

    public class FacadeRecipe
    implements IRecipe {
        public boolean func_77569_a(InventoryCrafting inventorycrafting, World world) {
            Object[] facade = this.getFacadeBlockFromCraftingGrid(inventorycrafting);
            return facade != null && facade[0] != null && ((IBlockState[])facade[0]).length == 1;
        }

        public ItemStack func_77572_b(InventoryCrafting inventorycrafting) {
            Object[] facade = this.getFacadeBlockFromCraftingGrid(inventorycrafting);
            if (facade == null || ((IBlockState[])facade[0]).length != 1) {
                return null;
            }
            IBlockState block = ((IBlockState[])facade[0])[0];
            ItemStack originalFacade = (ItemStack)facade[1];
            if (block == null) {
                return null;
            }
            return this.getNextFacadeItemStack(block, originalFacade);
        }

        private Object[] getFacadeBlockFromCraftingGrid(InventoryCrafting inventorycrafting) {
            ItemStack slotmatch = null;
            int countOfItems = 0;
            for (int i = 0; i < inventorycrafting.func_70302_i_(); ++i) {
                ItemStack slot = inventorycrafting.func_70301_a(i);
                if (slot != null && slot.func_77973_b() == ItemFacade.this && slotmatch == null) {
                    slotmatch = slot;
                    ++countOfItems;
                } else if (slot != null) {
                    slotmatch = NO_MATCH;
                }
                if (countOfItems <= true) continue;
                return null;
            }
            if (slotmatch != null && slotmatch != NO_MATCH) {
                return new Object[]{ItemFacade.this.getBlockStatesForFacade(slotmatch), slotmatch};
            }
            return null;
        }

        private ItemStack getNextFacadeItemStack(IBlockState state, ItemStack originalFacade) {
            IBlockState newState = state;
            if (newState.func_177227_a().contains(BlockQuartz.field_176335_a)) {
                BlockQuartz.EnumType type = (BlockQuartz.EnumType)newState.func_177229_b((IProperty)BlockQuartz.field_176335_a);
                if ("lines".equals(type.toString())) {
                    newState = newState.func_177226_a((IProperty)BlockQuartz.field_176335_a, (Comparable)BlockQuartz.EnumType.func_176794_a((int)((type.func_176796_a() - 1) % 3 + 2)));
                }
            } else {
                for (IProperty prop : state.func_177228_b().keySet()) {
                    if (!prop.func_177701_a().equals("axis")) continue;
                    newState = newState.func_177231_a(prop);
                }
            }
            return ItemFacade.this.getFacadeForBlock(newState);
        }

        public int func_77570_a() {
            return 1;
        }

        public ItemStack func_77571_b() {
            return null;
        }

        public ItemStack[] func_179532_b(InventoryCrafting inv) {
            ItemStack[] itemStack = new ItemStack[inv.func_70302_i_()];
            for (int i = 0; i < itemStack.length; ++i) {
                ItemStack itemstack = inv.func_70301_a(i);
                itemStack[i] = ForgeHooks.getContainerItem((ItemStack)itemstack);
            }
            return itemStack;
        }
    }

    public static class FacadeState {
        public final IBlockState state;
        public final boolean transparent;
        public final boolean hollow;
        public final PipeWire wire;

        public FacadeState(IBlockState state, PipeWire wire) {
            this.state = state;
            this.wire = wire;
            this.transparent = false;
            this.hollow = false;
        }

        public FacadeState(IBlockState state, PipeWire wire, boolean hollow) {
            this.state = state;
            this.wire = wire;
            this.transparent = false;
            this.hollow = hollow;
        }

        public FacadeState(NBTTagCompound nbt) {
            String key = nbt.func_74779_i("block");
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(key));
            if (block == null) {
                throw new NullPointerException("Could not load a block from the key \"" + key + "\"");
            }
            byte metadata = nbt.func_74771_c("metadata");
            this.state = block.func_176203_a((int)metadata);
            this.wire = nbt.func_74764_b("wire") ? PipeWire.fromOrdinal(nbt.func_74771_c("wire")) : null;
            this.transparent = nbt.func_74764_b("transparent") && nbt.func_74767_n("transparent");
            this.hollow = nbt.func_74764_b("hollow") && nbt.func_74767_n("hollow");
        }

        private FacadeState(PipeWire wire) {
            this.state = Blocks.field_150357_h.func_176223_P();
            this.wire = wire;
            this.transparent = true;
            this.hollow = false;
        }

        public static FacadeState create(IBlockState state) {
            return FacadeState.create(state, null);
        }

        public static FacadeState create(IBlockState state, PipeWire wire) {
            return new FacadeState(state, wire);
        }

        public static FacadeState createTransparent(PipeWire wire) {
            return new FacadeState(wire);
        }

        public void writeToNBT(NBTTagCompound nbt) {
            if (this.state != null) {
                nbt.func_74778_a("block", Utils.getNameForBlock(this.state.func_177230_c()));
                nbt.func_74774_a("metadata", (byte)this.state.func_177230_c().func_176201_c(this.state));
            }
            if (this.wire != null) {
                nbt.func_74774_a("wire", (byte)this.wire.ordinal());
            }
            nbt.func_74757_a("transparent", this.transparent);
            nbt.func_74757_a("hollow", this.hollow);
        }

        public static NBTTagList writeArray(FacadeState[] states) {
            if (states == null) {
                return null;
            }
            NBTTagList list = new NBTTagList();
            for (FacadeState state : states) {
                NBTTagCompound stateNBT = new NBTTagCompound();
                state.writeToNBT(stateNBT);
                list.func_74742_a((NBTBase)stateNBT);
            }
            return list;
        }

        public static FacadeState[] readArray(NBTTagList list) {
            if (list == null) {
                return new FacadeState[0];
            }
            int length = list.func_74745_c();
            FacadeState[] states = new FacadeState[length];
            for (int i = 0; i < length; ++i) {
                states[i] = new FacadeState(list.func_150305_b(i));
            }
            return states;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.hollow).append(this.transparent).append((Object)this.state).append((Object)this.wire).build();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FacadeState other = (FacadeState)obj;
            if (this.hollow != other.hollow) {
                return false;
            }
            if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
                return false;
            }
            if (this.transparent != other.transparent) {
                return false;
            }
            return this.wire == other.wire;
        }
    }
}

