/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.power.ILaserTarget;
import buildcraft.api.power.ILaserTargetBlock;
import buildcraft.api.tiles.IControllable;
import buildcraft.api.tiles.IHasWork;
import buildcraft.core.Box;
import buildcraft.core.EntityLaser;
import buildcraft.core.LaserData;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.utils.BlockUtils;
import buildcraft.core.lib.utils.Utils;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;

public class TileLaser
extends TileBuildCraft
implements IHasWork,
IControllable {
    private static final float LASER_OFFSET = 0.125f;
    private static final short POWER_AVERAGING = 100;
    public LaserData laser = new LaserData();
    private final SafeTimeTracker laserTickTracker = new SafeTimeTracker(10L);
    private final SafeTimeTracker searchTracker = new SafeTimeTracker(100L, 100L);
    private final SafeTimeTracker networkTracker = new SafeTimeTracker(20L, 3L);
    private ILaserTarget laserTarget;
    private int powerIndex = 0;
    private short powerAverage = 0;
    private final short[] power = new short[100];

    public TileLaser() {
        this.setBattery(new RFBattery(10000, 250, 0));
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.laser == null) {
            this.laser = new LaserData();
        }
        this.laser.isVisible = false;
        this.laser.head = Utils.convert((Vec3i)this.func_174877_v());
        this.laser.tail = Utils.convert((Vec3i)this.func_174877_v());
        this.laser.isGlowing = true;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.laser.iterateTexture();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.mode == IControllable.Mode.Off) {
            this.removeLaser();
            return;
        }
        if (this.canFindTable()) {
            this.findTable();
        }
        if (!this.isValidTable()) {
            this.removeLaser();
            return;
        }
        if (this.getBattery().getEnergyStored() == 0) {
            this.removeLaser();
            return;
        }
        if (this.laser != null) {
            this.laser.isVisible = true;
            if (this.canUpdateLaser()) {
                this.updateLaser();
            }
        }
        int localPower = this.getBattery().useEnergy(0, this.getMaxPowerSent(), false);
        this.laserTarget.receiveLaserEnergy(localPower);
        if (this.laser != null) {
            this.pushPower(localPower);
        }
        this.onPowerSent(localPower);
        this.sendNetworkUpdate();
    }

    protected int getMaxPowerSent() {
        return 40;
    }

    protected void onPowerSent(int power) {
    }

    protected boolean canFindTable() {
        return this.searchTracker.markTimeIfDelay(this.field_145850_b);
    }

    protected boolean canUpdateLaser() {
        return this.laserTickTracker.markTimeIfDelay(this.field_145850_b);
    }

    protected boolean isValidTable() {
        return this.laserTarget != null && !this.laserTarget.isInvalidTarget() && this.laserTarget.requiresLaserEnergy();
    }

    protected void findTable() {
        int meta = this.func_145832_p();
        BlockPos min = this.func_174877_v().func_177971_a((Vec3i)Utils.vec3i(-5));
        BlockPos max = this.func_174877_v().func_177971_a((Vec3i)Utils.vec3i(5));
        EnumFacing face = EnumFacing.func_82600_a((int)meta);
        if (face.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
            max = max.func_177967_a(face, 5);
        } else {
            min = min.func_177967_a(face, -5);
        }
        LinkedList<ILaserTarget> targets = new LinkedList<ILaserTarget>();
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)min, (BlockPos)max)) {
            ILaserTarget table;
            TileEntity tile;
            if (!(BlockUtils.getBlockState(this.field_145850_b, pos).func_177230_c() instanceof ILaserTargetBlock) || !((tile = this.field_145850_b.func_175625_s(pos)) instanceof ILaserTarget) || !(table = (ILaserTarget)tile).requiresLaserEnergy()) continue;
            targets.add(table);
        }
        if (targets.isEmpty()) {
            return;
        }
        this.laserTarget = (ILaserTarget)targets.get(this.field_145850_b.field_73012_v.nextInt(targets.size()));
    }

    protected void updateLaser() {
        int meta = this.func_145832_p();
        double px = 0.0;
        double py = 0.0;
        double pz = 0.0;
        switch (EnumFacing.func_82600_a((int)meta)) {
            case WEST: {
                px = -0.125;
                break;
            }
            case EAST: {
                px = 0.125;
                break;
            }
            case DOWN: {
                py = -0.125;
                break;
            }
            case UP: {
                py = 0.125;
                break;
            }
            case NORTH: {
                pz = -0.125;
                break;
            }
            default: {
                pz = 0.125;
            }
        }
        Vec3 head = Utils.convertMiddle((Vec3i)this.func_174877_v()).func_72441_c(px, py, pz);
        Vec3 tail = Utils.convert((Vec3i)((TileEntity)this.laserTarget).func_174877_v());
        tail = tail.func_72441_c(0.475 + (this.field_145850_b.field_73012_v.nextDouble() - 0.5) / 5.0, 0.5625, 0.475 + (this.field_145850_b.field_73012_v.nextDouble() - 0.5) / 5.0);
        this.laser.head = head;
        this.laser.tail = tail;
        if (!this.laser.isVisible) {
            this.laser.isVisible = true;
        }
    }

    protected void removeLaser() {
        if (this.powerAverage > 0) {
            this.pushPower(0);
        }
        if (this.laser.isVisible) {
            this.laser.isVisible = false;
            super.sendNetworkUpdate();
        }
    }

    @Override
    public void sendNetworkUpdate() {
        if (this.networkTracker.markTimeIfDelay(this.field_145850_b)) {
            super.sendNetworkUpdate();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
    }

    @Override
    public void readData(ByteBuf stream) {
        this.laser = new LaserData();
        this.laser.readData(stream);
        this.powerAverage = stream.readShort();
    }

    @Override
    public void writeData(ByteBuf stream) {
        this.laser.writeData(stream);
        stream.writeShort((int)this.powerAverage);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.removeLaser();
    }

    @Override
    public boolean hasWork() {
        return this.isValidTable();
    }

    private void pushPower(int received) {
        this.powerAverage = (short)(this.powerAverage - this.power[this.powerIndex]);
        this.powerAverage = (short)(this.powerAverage + received);
        this.power[this.powerIndex] = (short)received;
        ++this.powerIndex;
        if (this.powerIndex == this.power.length) {
            this.powerIndex = 0;
        }
    }

    public ResourceLocation getTexture() {
        double avg = this.powerAverage / 100;
        if (avg <= 10.0) {
            return EntityLaser.LASER_RED;
        }
        if (avg <= 20.0) {
            return EntityLaser.LASER_YELLOW;
        }
        if (avg <= 30.0) {
            return EntityLaser.LASER_GREEN;
        }
        return EntityLaser.LASER_BLUE;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new Box(this).extendToEncompass(this.laser.tail).getBoundingBox();
    }

    @Override
    public boolean acceptsControlMode(IControllable.Mode mode) {
        return mode == IControllable.Mode.On || mode == IControllable.Mode.Off;
    }
}

