/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.BuildCraftSilicon;
import buildcraft.core.lib.items.ItemBuildCraft;
import buildcraft.core.lib.utils.ModelHelper;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemRedstoneChipset
extends ItemBuildCraft {
    public ItemRedstoneChipset() {
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return "item." + Chipset.fromOrdinal(stack.func_77952_i()).getChipsetName();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List itemList) {
        for (Chipset chipset : Chipset.VALUES) {
            itemList.add(chipset.getStack());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (Chipset chipset : Chipset.values()) {
            ModelHelper.registerItemModel(this, chipset.ordinal(), "/" + chipset.name().toLowerCase(Locale.ROOT));
        }
    }

    public void registerItemStacks() {
        for (Chipset chipset : Chipset.VALUES) {
            OreDictionary.registerOre((String)("chipset" + chipset.name().toUpperCase().substring(0, 1) + chipset.name().toLowerCase().substring(1)), (ItemStack)chipset.getStack());
        }
    }

    public static enum Chipset {
        RED,
        IRON,
        GOLD,
        DIAMOND,
        PULSATING,
        QUARTZ,
        COMP,
        EMERALD;

        public static final Chipset[] VALUES;
        private TextureAtlasSprite icon;

        public String getChipsetName() {
            return "redstone_" + this.name().toLowerCase(Locale.ENGLISH) + "_chipset";
        }

        public ItemStack getStack() {
            return this.getStack(1);
        }

        public ItemStack getStack(int qty) {
            return new ItemStack((Item)BuildCraftSilicon.redstoneChipset, qty, this.ordinal());
        }

        public static Chipset fromOrdinal(int ordinal) {
            if (ordinal < 0 || ordinal >= VALUES.length) {
                return RED;
            }
            return VALUES[ordinal];
        }

        static {
            VALUES = Chipset.values();
        }
    }
}

