/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.IStackFilter;
import buildcraft.api.crops.CropManager;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.ResourceIdBlock;
import buildcraft.core.lib.inventory.filters.AggregateFilter;
import buildcraft.core.lib.utils.IBlockFilter;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.robotics.ai.AIRobotFetchAndEquipItemStack;
import buildcraft.robotics.ai.AIRobotGotoSleep;
import buildcraft.robotics.ai.AIRobotPlant;
import buildcraft.robotics.ai.AIRobotSearchAndGotoBlock;
import buildcraft.robotics.boards.BCBoardNBT;
import buildcraft.robotics.statements.ActionRobotFilter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public class BoardRobotPlanter
extends RedstoneBoardRobot {
    private BlockPos blockFound;
    private IStackFilter filter = new IStackFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            return CropManager.isSeed(stack);
        }
    };

    public BoardRobotPlanter(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BCBoardNBT.REGISTRY.get("planter");
    }

    @Override
    public void update() {
        if (this.robot.func_70694_bm() == null) {
            this.startDelegateAI(new AIRobotFetchAndEquipItemStack(this.robot, new AggregateFilter(this.filter, ActionRobotFilter.getGateFilter(this.robot.getLinkedStation()))));
        } else {
            final ItemStack itemStack = this.robot.func_70694_bm();
            IBlockFilter blockFilter = new IBlockFilter(){

                @Override
                public boolean matches(World world, BlockPos pos) {
                    return !BuildCraftAPI.getWorldProperty("replaceable").get(world, pos) && BoardRobotPlanter.this.isPlantable(itemStack, world, pos) && !BoardRobotPlanter.this.robot.getRegistry().isTaken(new ResourceIdBlock(pos));
                }
            };
            this.startDelegateAI(new AIRobotSearchAndGotoBlock(this.robot, true, blockFilter, 1.0));
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchAndGotoBlock) {
            if (ai.success()) {
                this.blockFound = ((AIRobotSearchAndGotoBlock)ai).getBlockFound();
                this.startDelegateAI(new AIRobotPlant(this.robot, this.blockFound));
            } else {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotPlant) {
            this.releaseBlockFound();
        } else if (ai instanceof AIRobotFetchAndEquipItemStack && !ai.success()) {
            this.startDelegateAI(new AIRobotGotoSleep(this.robot));
        }
    }

    private void releaseBlockFound() {
        if (this.blockFound != null) {
            this.robot.getRegistry().release(new ResourceIdBlock(this.blockFound));
            this.blockFound = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPlantable(ItemStack seed, World world, BlockPos pos) {
        World world2 = world;
        synchronized (world2) {
            return CropManager.canSustainPlant(world, seed, pos);
        }
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.blockFound != null) {
            nbt.func_74782_a("blockFound", NBTUtils.writeBlockPos(this.blockFound));
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.func_74764_b("blockFound")) {
            this.blockFound = NBTUtils.readBlockPos(nbt.func_74781_a("blockFound"));
        }
    }
}

