/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.IZone;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.builders.TileConstructionMarker;
import buildcraft.core.builders.BuildingItem;
import buildcraft.core.builders.BuildingSlot;
import buildcraft.core.lib.inventory.filters.ArrayStackFilter;
import buildcraft.core.lib.utils.Utils;
import buildcraft.robotics.ai.AIRobotDisposeItems;
import buildcraft.robotics.ai.AIRobotGotoBlock;
import buildcraft.robotics.ai.AIRobotGotoSleep;
import buildcraft.robotics.ai.AIRobotGotoStationAndLoad;
import buildcraft.robotics.ai.AIRobotRecharge;
import buildcraft.robotics.boards.BCBoardNBT;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3i;
import net.minecraft.world.WorldSettings;

public class BoardRobotBuilder
extends RedstoneBoardRobot {
    private static final int MAX_RANGE_SQ = 12288;
    private TileConstructionMarker markerToBuild;
    private BuildingSlot currentBuildingSlot;
    private List<ItemStack> requirementsToLookFor;
    private int launchingDelay = 0;

    public BoardRobotBuilder(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BCBoardNBT.REGISTRY.get("builder");
    }

    @Override
    public void update() {
        if (this.launchingDelay > 0) {
            --this.launchingDelay;
            return;
        }
        if (this.markerToBuild == null) {
            this.markerToBuild = this.findClosestMarker();
            if (this.markerToBuild == null) {
                if (this.robot.containsItems()) {
                    this.startDelegateAI(new AIRobotDisposeItems(this.robot));
                } else {
                    this.startDelegateAI(new AIRobotGotoSleep(this.robot));
                }
                return;
            }
        }
        if (!this.markerToBuild.needsToBuild()) {
            this.markerToBuild = null;
            this.currentBuildingSlot = null;
            return;
        }
        if (this.currentBuildingSlot == null) {
            this.currentBuildingSlot = this.markerToBuild.bluePrintBuilder.reserveNextSlot(this.robot.field_70170_p);
            if (this.currentBuildingSlot == null) {
                this.launchingDelay = 40;
                return;
            }
        }
        if (this.requirementsToLookFor == null) {
            if (this.robot.containsItems()) {
                this.startDelegateAI(new AIRobotDisposeItems(this.robot));
            }
            this.requirementsToLookFor = this.robot.field_70170_p.func_72912_H().func_76077_q() != WorldSettings.GameType.CREATIVE ? this.currentBuildingSlot.getRequirements(this.markerToBuild.getContext()) : new LinkedList<ItemStack>();
            if (this.requirementsToLookFor == null) {
                this.launchingDelay = 40;
                return;
            }
            if (this.requirementsToLookFor.size() > 4) {
                this.currentBuildingSlot.built = true;
                this.currentBuildingSlot = null;
                this.requirementsToLookFor = null;
                return;
            }
        }
        if (this.requirementsToLookFor.size() > 0) {
            this.startDelegateAI(new AIRobotGotoStationAndLoad(this.robot, new ArrayStackFilter(this.requirementsToLookFor.get(0)), this.requirementsToLookFor.get((int)0).field_77994_a));
            return;
        }
        if (this.requirementsToLookFor.size() == 0) {
            if (this.currentBuildingSlot.stackConsumed == null) {
                this.markerToBuild.bluePrintBuilder.useRequirements(this.robot, this.currentBuildingSlot);
            }
            if (!this.hasEnoughEnergy()) {
                this.startDelegateAI(new AIRobotRecharge(this.robot));
            } else {
                this.startDelegateAI(new AIRobotGotoBlock(this.robot, Utils.convertFloor(this.currentBuildingSlot.getDestination()), 8.0));
            }
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotGotoStationAndLoad) {
            if (ai.success()) {
                this.requirementsToLookFor.remove(0);
            } else {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotGotoBlock) {
            if (this.markerToBuild == null || this.markerToBuild.bluePrintBuilder == null) {
                return;
            }
            if (!this.hasEnoughEnergy()) {
                this.startDelegateAI(new AIRobotRecharge(this.robot));
                return;
            }
            this.robot.getBattery().extractEnergy(this.currentBuildingSlot.getEnergyRequirement(), false);
            this.launchingDelay = this.currentBuildingSlot.getStacksToDisplay().size() * BuildingItem.ITEMS_SPACE;
            this.markerToBuild.bluePrintBuilder.buildSlot(this.robot.field_70170_p, this.markerToBuild, this.currentBuildingSlot, Utils.getVec((Entity)this.robot));
            this.currentBuildingSlot = null;
            this.requirementsToLookFor = null;
        }
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        nbt.func_74768_a("launchingDelay", this.launchingDelay);
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        this.launchingDelay = nbt.func_74762_e("launchingDelay");
    }

    private TileConstructionMarker findClosestMarker() {
        double minDistance = Double.MAX_VALUE;
        TileConstructionMarker minMarker = null;
        IZone zone = this.robot.getZoneToWork();
        for (TileConstructionMarker marker : TileConstructionMarker.currentMarkers) {
            double dz;
            double dy;
            double dx;
            double distance;
            if (marker.func_145831_w() != this.robot.field_70170_p || !marker.needsToBuild() || zone != null && !zone.contains(Utils.convert((Vec3i)marker.func_174877_v())) || !((distance = (dx = this.robot.field_70165_t - (double)marker.func_174877_v().func_177958_n()) * dx + (dy = this.robot.field_70163_u - (double)marker.func_174877_v().func_177956_o()) * dy + (dz = this.robot.field_70161_v - (double)marker.func_174877_v().func_177952_p()) * dz) < minDistance)) continue;
            minMarker = marker;
            minDistance = distance;
        }
        if (minMarker != null && minDistance < 12288.0) {
            return minMarker;
        }
        return null;
    }

    private boolean hasEnoughEnergy() {
        return this.robot.getEnergy() - this.currentBuildingSlot.getEnergyRequirement() > 20000;
    }
}

