/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.transport.IStripesActivator;
import buildcraft.api.transport.IStripesHandler;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.proxy.CoreProxy;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.WorldServer;

public class AIRobotStripesHandler
extends AIRobot
implements IStripesActivator {
    private BlockPos useToBlock;
    private int useCycles = 0;

    public AIRobotStripesHandler(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotStripesHandler(EntityRobotBase iRobot, BlockPos index) {
        this(iRobot);
        this.useToBlock = index;
    }

    @Override
    public void start() {
        this.robot.aimItemAt(this.useToBlock);
        this.robot.setItemActive(true);
    }

    @Override
    public void update() {
        if (this.useToBlock == null) {
            this.setSuccess(false);
            this.terminate();
            return;
        }
        ++this.useCycles;
        if (this.useCycles > 60) {
            ItemStack stack = this.robot.func_70694_bm();
            EnumFacing direction = EnumFacing.NORTH;
            EntityPlayer player = (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.robot.field_70170_p, this.useToBlock).get();
            player.field_70125_A = 0.0f;
            player.field_70177_z = 180.0f;
            for (IStripesHandler handler : PipeManager.stripesHandlers) {
                if (handler.getType() != IStripesHandler.StripesHandlerType.ITEM_USE || !handler.shouldHandle(stack) || !handler.handle(this.robot.field_70170_p, this.useToBlock, direction, stack, player, this)) continue;
                this.robot.setItemInUse(null);
                this.terminate();
                return;
            }
            this.terminate();
        }
    }

    @Override
    public void end() {
        this.robot.setItemActive(false);
    }

    @Override
    public int getEnergyCost() {
        return 15;
    }

    @Override
    public void sendItem(ItemStack stack, EnumFacing direction) {
        InvUtils.dropItems(this.robot.field_70170_p, stack, Utils.getPos((Entity)this.robot));
    }

    @Override
    public void dropItem(ItemStack stack, EnumFacing direction) {
        this.sendItem(stack, direction);
    }
}

