/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.utils.BlockUtils;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fluids.FluidStack;

public class AIRobotPumpBlock
extends AIRobot {
    private BlockPos blockToPump;
    private long waited = 0L;
    private int pumped = 0;

    public AIRobotPumpBlock(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotPumpBlock(EntityRobotBase iRobot, BlockPos iBlockToPump) {
        this(iRobot);
        this.blockToPump = iBlockToPump;
    }

    @Override
    public void start() {
        this.robot.aimItemAt(this.blockToPump);
    }

    @Override
    public void preempt(AIRobot ai) {
        super.preempt(ai);
    }

    @Override
    public void update() {
        if (this.waited < 40L) {
            ++this.waited;
        } else {
            FluidStack fluidStack = BlockUtils.drainBlock(this.robot.field_70170_p, this.blockToPump, false);
            if (fluidStack != null && this.robot.fill(null, fluidStack, true) > 0) {
                BlockUtils.drainBlock(this.robot.field_70170_p, this.blockToPump, true);
            }
            this.terminate();
        }
    }

    @Override
    public int getEnergyCost() {
        return 5;
    }

    @Override
    public boolean success() {
        return this.pumped > 0;
    }
}

