/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.utils.IterableAlgorithmRunner;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.PathFinding;
import buildcraft.core.lib.utils.Utils;
import buildcraft.robotics.ai.AIRobotGoto;
import java.util.LinkedList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;

public class AIRobotGotoBlock
extends AIRobotGoto {
    private PathFinding pathSearch;
    private IterableAlgorithmRunner pathSearchJob;
    private LinkedList<BlockPos> path;
    private double prevDistance = Double.MAX_VALUE;
    private BlockPos finalPos;
    private double maxDistance = 0.0;
    private BlockPos lastBlockInPath;
    private boolean loadedFromNBT;
    private boolean skipLastIfNotSoft;
    private BlockPos lastBlock;

    public AIRobotGotoBlock(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotGotoBlock(EntityRobotBase robot, BlockPos pos) {
        this(robot);
        this.finalPos = pos;
    }

    public AIRobotGotoBlock(EntityRobotBase robot, BlockPos pos, double iMaxDistance) {
        this(robot, pos);
        this.maxDistance = iMaxDistance;
    }

    public AIRobotGotoBlock(EntityRobotBase robot, LinkedList<BlockPos> iPath) {
        this(robot);
        this.path = iPath;
        this.finalPos = this.path.getLast();
        this.setNextInPath();
    }

    public AIRobotGotoBlock(EntityRobotBase robot, BlockPos pos, boolean iSkipLastIfNotSoft) {
        this(robot);
        this.finalPos = pos;
        this.skipLastIfNotSoft = iSkipLastIfNotSoft;
    }

    @Override
    public void start() {
        this.robot.undock();
    }

    @Override
    public void update() {
        if (this.loadedFromNBT) {
            this.setNextInPath();
            this.loadedFromNBT = false;
        }
        if (this.path == null && this.pathSearch == null) {
            this.pathSearch = new PathFinding(this.robot.field_70170_p, new BlockPos((int)Math.floor(this.robot.field_70165_t), (int)Math.floor(this.robot.field_70163_u), (int)Math.floor(this.robot.field_70161_v)), this.finalPos, this.maxDistance);
            this.pathSearchJob = new IterableAlgorithmRunner(this.pathSearch, 50);
            this.pathSearchJob.start();
        } else if (this.path != null && this.next != null) {
            double distance = this.robot.func_70011_f(this.next.field_72450_a, this.next.field_72448_b, this.next.field_72449_c);
            if (!this.robot.isMoving() || distance > this.prevDistance) {
                if (this.path.size() > 0) {
                    this.path.removeFirst();
                }
                this.setNextInPath();
            } else {
                this.prevDistance = this.robot.func_70011_f(this.next.field_72450_a, this.next.field_72448_b, this.next.field_72449_c);
            }
        } else if (this.pathSearchJob.isDone()) {
            this.path = this.pathSearch.getResult();
            if (this.path.size() == 0) {
                this.setSuccess(false);
                this.terminate();
                return;
            }
            this.lastBlockInPath = this.path.getLast();
            this.setNextInPath();
        }
        if (this.path != null && this.path.size() == 0) {
            this.robot.field_70159_w = 0.0;
            this.robot.field_70181_x = 0.0;
            this.robot.field_70179_y = 0.0;
            if (this.lastBlockInPath != null) {
                this.robot.field_70165_t = (float)this.lastBlockInPath.func_177958_n() + 0.5f;
                this.robot.field_70163_u = (float)this.lastBlockInPath.func_177956_o() + 0.5f;
                this.robot.field_70161_v = (float)this.lastBlockInPath.func_177952_p() + 0.5f;
            }
            this.terminate();
        }
    }

    private void setNextInPath() {
        if (this.path != null && this.path.size() > 0) {
            boolean isFirst = this.prevDistance == Double.MAX_VALUE;
            BlockPos next = this.path.getFirst();
            if (isFirst || PathFinding.isFreeForPath(this.robot.field_70170_p, next)) {
                this.lastBlock = next;
                this.setDestination(this.robot, Utils.convertMiddle((Vec3i)next));
                this.prevDistance = Double.MAX_VALUE;
                this.robot.aimItemAt(next);
            } else if (this.skipLastIfNotSoft && this.path.size() == 1) {
                this.lastBlockInPath = this.lastBlock;
            } else {
                this.path = null;
                if (this.pathSearchJob != null) {
                    this.pathSearchJob.terminate();
                    this.robot.field_70159_w = 0.0;
                    this.robot.field_70181_x = 0.0;
                    this.robot.field_70179_y = 0.0;
                }
                this.pathSearch = null;
                this.pathSearchJob = null;
            }
        }
    }

    @Override
    public void end() {
        if (this.pathSearchJob != null) {
            this.pathSearchJob.terminate();
            this.robot.field_70159_w = 0.0;
            this.robot.field_70181_x = 0.0;
            this.robot.field_70179_y = 0.0;
        }
    }

    @Override
    public boolean canLoadFromNBT() {
        return true;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        nbt.func_74782_a("finalPos", NBTUtils.writeBlockPos(this.finalPos));
        nbt.func_74780_a("maxDistance", this.maxDistance);
        nbt.func_74757_a("skipLastIfNotSoft", this.skipLastIfNotSoft);
        if (this.path != null) {
            NBTTagList pathList = new NBTTagList();
            for (BlockPos i : this.path) {
                pathList.func_74742_a(NBTUtils.writeBlockPos(i));
            }
            nbt.func_74782_a("path", (NBTBase)pathList);
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        this.finalPos = NBTUtils.readBlockPos(nbt.func_74781_a("finalPos"));
        this.maxDistance = nbt.func_74769_h("maxDistance");
        this.skipLastIfNotSoft = nbt.func_74767_n("skipLastIfNotSoft");
        if (nbt.func_74764_b("path")) {
            NBTTagList pathList = nbt.func_150295_c("path", 10);
            this.path = new LinkedList();
            for (int i = 0; i < pathList.func_74745_c(); ++i) {
                this.path.add(NBTUtils.readBlockPos(pathList.func_179238_g(i)));
            }
        }
        this.loadedFromNBT = true;
    }
}

