/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.robotics.ai.AIRobotGotoBlock;
import buildcraft.robotics.ai.AIRobotStraightMoveTo;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3i;

public class AIRobotGoAndLinkToDock
extends AIRobot {
    private DockingStation station;

    public AIRobotGoAndLinkToDock(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotGoAndLinkToDock(EntityRobotBase iRobot, DockingStation iStation) {
        this(iRobot);
        this.station = iStation;
    }

    @Override
    public void start() {
        if (this.station == this.robot.getLinkedStation() && this.station == this.robot.getDockingStation()) {
            this.terminate();
        } else if (this.station != null && this.station.takeAsMain(this.robot)) {
            this.startDelegateAI(new AIRobotGotoBlock(this.robot, this.station.getPos().func_177967_a(this.station.side(), 2)));
        } else {
            this.setSuccess(false);
            this.terminate();
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotGotoBlock) {
            if (ai.success()) {
                this.startDelegateAI(new AIRobotStraightMoveTo(this.robot, Utils.convertMiddle((Vec3i)this.station.getPos()).func_178787_e(Utils.convert(this.station.side(), 0.5))));
            } else {
                this.terminate();
            }
        } else if (ai instanceof AIRobotStraightMoveTo) {
            if (ai.success()) {
                this.robot.dock(this.station);
            }
            this.terminate();
        }
    }

    @Override
    public boolean canLoadFromNBT() {
        return true;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.station != null && this.station.index() != null) {
            nbt.func_74782_a("stationIndex", NBTUtils.writeBlockPos(this.station.index()));
            nbt.func_74774_a("stationSide", (byte)this.station.side().ordinal());
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("stationIndex")) {
            BlockPos index = NBTUtils.readBlockPos(nbt.func_74781_a("stationIndex"));
            EnumFacing side = EnumFacing.values()[nbt.func_74771_c("stationSide")];
            this.station = this.robot.getRegistry().getStation(index, side);
        } else {
            this.station = this.robot.getLinkedStation();
        }
    }
}

