/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics;

import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.IRequestProvider;
import buildcraft.api.robots.IRobotRegistry;
import buildcraft.api.robots.ResourceId;
import buildcraft.api.robots.ResourceIdRequest;
import buildcraft.api.robots.RobotManager;
import buildcraft.core.lib.utils.NBTUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class StackRequest {
    private IRequestProvider requester;
    private int slot;
    private ItemStack stack;
    private DockingStation station;
    private BlockPos stationIndex;
    private EnumFacing stationSide;

    public StackRequest(IRequestProvider requester, int slot, ItemStack stack) {
        this.requester = requester;
        this.slot = slot;
        this.stack = stack;
        this.station = null;
    }

    private StackRequest(int slot, ItemStack stack, BlockPos stationIndex, EnumFacing stationSide) {
        this.requester = null;
        this.slot = slot;
        this.stack = stack;
        this.station = null;
        this.stationIndex = stationIndex;
        this.stationSide = stationSide;
    }

    public IRequestProvider getRequester(World world) {
        DockingStation dockingStation;
        if (this.requester == null && (dockingStation = this.getStation(world)) != null) {
            this.requester = dockingStation.getRequestProvider();
        }
        return this.requester;
    }

    public int getSlot() {
        return this.slot;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public DockingStation getStation(World world) {
        if (this.station == null) {
            IRobotRegistry robotRegistry = RobotManager.registryProvider.getRegistry(world);
            this.station = robotRegistry.getStation(this.stationIndex, this.stationSide);
        }
        return this.station;
    }

    public void setStation(DockingStation station) {
        this.station = station;
        this.stationIndex = station.index();
        this.stationSide = station.side();
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("slot", this.slot);
        NBTTagCompound stackNBT = new NBTTagCompound();
        this.stack.func_77955_b(stackNBT);
        nbt.func_74782_a("stack", (NBTBase)stackNBT);
        if (this.station != null) {
            nbt.func_74782_a("stationIndex", NBTUtils.writeBlockPos(this.stationIndex));
            nbt.func_74774_a("stationSide", (byte)this.station.side().ordinal());
        }
    }

    public static StackRequest loadFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("stationIndex")) {
            int slot = nbt.func_74762_e("slot");
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("stack"));
            BlockPos stationIndex = NBTUtils.readBlockPos(nbt.func_74781_a("stationIndex"));
            EnumFacing stationSide = EnumFacing.values()[nbt.func_74771_c("stationSide")];
            return new StackRequest(slot, stack, stationIndex, stationSide);
        }
        return null;
    }

    public ResourceId getResourceId(World world) {
        return this.getStation(world) != null ? new ResourceIdRequest(this.getStation(world), this.slot) : null;
    }
}

