/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics;

import buildcraft.BuildCraftRobotics;
import buildcraft.api.boards.RedstoneBoardNBT;
import buildcraft.api.boards.RedstoneBoardRegistry;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.BCLog;
import buildcraft.robotics.EntityRobot;
import buildcraft.robotics.RoboticsProxy;
import buildcraft.robotics.TileZonePlan;
import buildcraft.robotics.render.RedstoneBoardMeshDefinition;
import buildcraft.robotics.render.RenderRobot;
import buildcraft.robotics.render.RenderZonePlan;
import buildcraft.robotics.render.RobotItemModel;
import buildcraft.robotics.render.RobotStationModel;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RoboticsProxyClient
extends RoboticsProxy {
    public static Map<String, IBakedModel> robotModel = new HashMap<String, IBakedModel>();
    public static IBakedModel defaultRobotModel;

    @SubscribeEvent
    public void onPostBake(ModelBakeEvent event) {
        event.modelRegistry.func_82595_a((Object)new ModelResourceLocation("buildcraftrobotics:robot", "inventory"), (Object)RobotItemModel.create());
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        event.map.func_174942_a(EntityRobot.ROBOT_BASE);
        for (RedstoneBoardNBT<?> board : RedstoneBoardRegistry.instance.getAllBoardNBTs()) {
            if (!(board instanceof RedstoneBoardRobotNBT)) continue;
            RedstoneBoardRobotNBT robotBoard = (RedstoneBoardRobotNBT)board;
            ResourceLocation texture = robotBoard.getRobotTexture();
            event.map.func_174942_a(texture);
        }
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Post event) {
        try {
            robotModel.clear();
            defaultRobotModel = null;
            IModel robotModelBase = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("buildcraftrobotics:robot"));
            if (robotModelBase instanceof IRetexturableModel) {
                defaultRobotModel = ((IRetexturableModel)robotModelBase).retexture(ImmutableMap.of((Object)"all", (Object)EntityRobot.ROBOT_BASE.toString())).bake(robotModelBase.getDefaultState(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
                for (RedstoneBoardNBT<?> board : RedstoneBoardRegistry.instance.getAllBoardNBTs()) {
                    if (!(board instanceof RedstoneBoardRobotNBT)) continue;
                    RedstoneBoardRobotNBT robotBoard = (RedstoneBoardRobotNBT)board;
                    ResourceLocation texture = robotBoard.getRobotTexture();
                    robotModel.put(board.getID(), (IBakedModel)((IRetexturableModel)robotModelBase).retexture(ImmutableMap.of((Object)"all", (Object)texture.toString())).bake(robotModelBase.getDefaultState(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter()));
                }
            } else {
                BCLog.logger.error("Robot model is not an instance of IRetexturableModel! This is not good news!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void preInit() {
        ModelLoader.setCustomModelResourceLocation((Item)BuildCraftRobotics.robotItem, (int)0, (ModelResourceLocation)new ModelResourceLocation("buildcraftrobotics:robot", "inventory"));
        RenderingRegistry.registerEntityRenderingHandler(EntityRobot.class, (IRenderFactory)new IRenderFactory<EntityRobot>(){

            public Render<? super EntityRobot> createRenderFor(RenderManager manager) {
                return new RenderRobot(manager);
            }
        });
    }

    @Override
    public void init() {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178080_a((Item)BuildCraftRobotics.redstoneBoard, (ItemMeshDefinition)new RedstoneBoardMeshDefinition());
        ClientRegistry.bindTileEntitySpecialRenderer(TileZonePlan.class, (TileEntitySpecialRenderer)new RenderZonePlan());
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)RobotStationModel.INSTANCE);
    }
}

