/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics;

import buildcraft.BuildCraftRobotics;
import buildcraft.api.boards.RedstoneBoardNBT;
import buildcraft.api.boards.RedstoneBoardRegistry;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.events.RobotEvent;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.lib.items.ItemBuildCraft;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.robotics.EntityRobot;
import buildcraft.robotics.RobotStationPluggable;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Pipe;
import cofh.api.energy.IEnergyContainerItem;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRobot
extends ItemBuildCraft
implements IEnergyContainerItem {
    public ItemRobot() {
        super(BCCreativeTab.get("boards"));
        this.func_77625_d(1);
    }

    public int getItemStackLimit(ItemStack stack) {
        NBTTagCompound cpt = ItemRobot.getNBT(stack);
        RedstoneBoardRobotNBT boardNBT = ItemRobot.getRobotNBT(cpt);
        if (boardNBT != RedstoneBoardRegistry.instance.getEmptyRobotBoard()) {
            return 1;
        }
        return 16;
    }

    public EntityRobot createRobot(ItemStack stack, World world) {
        try {
            NBTTagCompound nbt = ItemRobot.getNBT(stack);
            RedstoneBoardRobotNBT robotNBT = ItemRobot.getRobotNBT(nbt);
            if (robotNBT == RedstoneBoardRegistry.instance.getEmptyRobotBoard()) {
                return null;
            }
            EntityRobot robot = new EntityRobot(world, robotNBT);
            robot.getBattery().setEnergy(ItemRobot.getEnergy(nbt));
            return robot;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static RedstoneBoardRobotNBT getRobotNBT(ItemStack stack) {
        return ItemRobot.getRobotNBT(ItemRobot.getNBT(stack));
    }

    public static int getEnergy(ItemStack stack) {
        return ItemRobot.getEnergy(ItemRobot.getNBT(stack));
    }

    public ResourceLocation getTextureRobot(ItemStack stack) {
        return ItemRobot.getRobotNBT(stack).getRobotTexture();
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean advanced) {
        NBTTagCompound cpt = ItemRobot.getNBT(stack);
        RedstoneBoardRobotNBT boardNBT = ItemRobot.getRobotNBT(cpt);
        if (boardNBT != RedstoneBoardRegistry.instance.getEmptyRobotBoard()) {
            boardNBT.addInformation(stack, player, list, advanced);
            int energy = ItemRobot.getEnergy(cpt);
            int pct = energy * 100 / 100000;
            String enInfo = pct + "% " + BCStringUtils.localize("tip.gate.charged");
            if (energy == 100000) {
                enInfo = BCStringUtils.localize("tip.gate.fullcharge");
            } else if (energy == 0) {
                enInfo = BCStringUtils.localize("tip.gate.nocharge");
            }
            enInfo = (pct >= 80 ? EnumChatFormatting.GREEN : (pct >= 50 ? EnumChatFormatting.YELLOW : (pct >= 30 ? EnumChatFormatting.GOLD : (pct >= 20 ? EnumChatFormatting.RED : EnumChatFormatting.DARK_RED)))) + enInfo;
            list.add(enInfo);
        }
    }

    public static ItemStack createRobotStack(RedstoneBoardRobotNBT board, int energy) {
        ItemStack robot = new ItemStack(BuildCraftRobotics.robotItem);
        NBTTagCompound boardCpt = new NBTTagCompound();
        board.createBoard(boardCpt);
        NBTUtils.getItemData(robot).func_74782_a("board", (NBTBase)boardCpt);
        NBTUtils.getItemData(robot).func_74768_a("energy", energy);
        return robot;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        itemList.add(ItemRobot.createRobotStack(RedstoneBoardRegistry.instance.getEmptyRobotBoard(), 0));
        for (RedstoneBoardNBT<?> boardNBT : RedstoneBoardRegistry.instance.getAllBoardNBTs()) {
            if (!(boardNBT instanceof RedstoneBoardRobotNBT)) continue;
            RedstoneBoardRobotNBT robotNBT = (RedstoneBoardRobotNBT)boardNBT;
            itemList.add(ItemRobot.createRobotStack(robotNBT, 0));
            itemList.add(ItemRobot.createRobotStack(robotNBT, 100000));
        }
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        NBTTagCompound cpt = ItemRobot.getNBT(container);
        if (ItemRobot.getRobotNBT(cpt) == RedstoneBoardRegistry.instance.getEmptyRobotBoard()) {
            return 0;
        }
        int currentEnergy = ItemRobot.getEnergy(cpt);
        int energyReceived = Math.min(100000 - currentEnergy, maxReceive);
        if (!simulate) {
            ItemRobot.setEnergy(cpt, currentEnergy + energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        NBTTagCompound cpt = ItemRobot.getNBT(container);
        if (ItemRobot.getRobotNBT(cpt) == RedstoneBoardRegistry.instance.getEmptyRobotBoard()) {
            return 0;
        }
        int currentEnergy = ItemRobot.getEnergy(cpt);
        int energyExtracted = Math.min(currentEnergy, maxExtract);
        if (!simulate) {
            ItemRobot.setEnergy(cpt, currentEnergy - energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return ItemRobot.getEnergy(container);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        if (ItemRobot.getRobotNBT(container) == RedstoneBoardRegistry.instance.getEmptyRobotBoard()) {
            return 0;
        }
        return 100000;
    }

    public boolean func_180614_a(ItemStack currentItem, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            Block b = world.func_180495_p(pos).func_177230_c();
            if (!(b instanceof BlockGenericPipe)) {
                return false;
            }
            Pipe<?> pipe = BlockGenericPipe.getPipe((IBlockAccess)world, pos);
            if (pipe == null) {
                return false;
            }
            PipePluggable pluggable = pipe.container.getPipePluggable(side);
            if (pluggable instanceof RobotStationPluggable) {
                RobotStationPluggable robotPluggable = (RobotStationPluggable)pluggable;
                DockingStation station = robotPluggable.getStation();
                if (!station.isTaken()) {
                    RedstoneBoardRobotNBT robotNBT = ItemRobot.getRobotNBT(currentItem);
                    if (robotNBT == RedstoneBoardRegistry.instance.getEmptyRobotBoard()) {
                        return true;
                    }
                    EntityRobot robot = ((ItemRobot)currentItem.func_77973_b()).createRobot(currentItem, world);
                    RobotEvent.Place robotEvent = new RobotEvent.Place(robot, player);
                    MinecraftForge.EVENT_BUS.post((Event)robotEvent);
                    if (robotEvent.isCanceled()) {
                        return true;
                    }
                    if (robot != null && robot.getRegistry() != null) {
                        robot.setUniqueRobotId(robot.getRegistry().getNextRobotId());
                        float px = (float)pos.func_177958_n() + 0.5f + (float)side.func_82601_c() * 0.5f;
                        float py = (float)pos.func_177956_o() + 0.5f + (float)side.func_96559_d() * 0.5f;
                        float pz = (float)pos.func_177952_p() + 0.5f + (float)side.func_82599_e() * 0.5f;
                        robot.func_70107_b(px, py, pz);
                        station.takeAsMain(robot);
                        robot.dock(robot.getLinkedStation());
                        world.func_72838_d((Entity)robot);
                        if (!player.field_71075_bZ.field_75098_d) {
                            --player.func_71045_bC().field_77994_a;
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static NBTTagCompound getNBT(ItemStack stack) {
        NBTTagCompound cpt = NBTUtils.getItemData(stack);
        if (!cpt.func_74764_b("board")) {
            RedstoneBoardRegistry.instance.getEmptyRobotBoard().createBoard(cpt);
        }
        return cpt;
    }

    private static RedstoneBoardRobotNBT getRobotNBT(NBTTagCompound cpt) {
        NBTTagCompound boardCpt = cpt.func_74775_l("board");
        return (RedstoneBoardRobotNBT)RedstoneBoardRegistry.instance.getRedstoneBoard(boardCpt);
    }

    private static int getEnergy(NBTTagCompound cpt) {
        return cpt.func_74762_e("energy");
    }

    private static void setEnergy(NBTTagCompound cpt, int energy) {
        cpt.func_74768_a("energy", energy);
    }
}

