/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics;

import buildcraft.BuildCraftRobotics;
import buildcraft.api.boards.RedstoneBoardNBT;
import buildcraft.api.boards.RedstoneBoardRegistry;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;

public class ImplRedstoneBoardRegistry
extends RedstoneBoardRegistry {
    private HashMap<String, BoardFactory> boards = new HashMap();
    private RedstoneBoardRobotNBT emptyRobotBoardNBT;

    @Override
    public void registerBoardType(RedstoneBoardNBT<?> redstoneBoardNBT, int energyCost) {
        if (BuildCraftRobotics.blacklistedRobots.contains(redstoneBoardNBT.getID())) {
            return;
        }
        BoardFactory factory = new BoardFactory();
        factory.boardNBT = redstoneBoardNBT;
        factory.energyCost = energyCost;
        this.boards.put(redstoneBoardNBT.getID(), factory);
    }

    @Override
    public void registerBoardClass(RedstoneBoardNBT<?> redstoneBoardNBT, float probability) {
        this.registerBoardType(redstoneBoardNBT, Math.round(160000.0f / probability));
    }

    @Override
    public void setEmptyRobotBoard(RedstoneBoardRobotNBT redstoneBoardNBT) {
        this.emptyRobotBoardNBT = redstoneBoardNBT;
    }

    @Override
    public RedstoneBoardRobotNBT getEmptyRobotBoard() {
        return this.emptyRobotBoardNBT;
    }

    @Override
    public RedstoneBoardNBT<?> getRedstoneBoard(NBTTagCompound nbt) {
        return this.getRedstoneBoard(nbt.func_74779_i("id"));
    }

    @Override
    public RedstoneBoardNBT<?> getRedstoneBoard(String id) {
        BoardFactory factory = this.boards.get(id);
        if (factory != null) {
            return factory.boardNBT;
        }
        return this.emptyRobotBoardNBT;
    }

    @Override
    public Collection<RedstoneBoardNBT<?>> getAllBoardNBTs() {
        ArrayList result = new ArrayList();
        for (BoardFactory f : this.boards.values()) {
            result.add(f.boardNBT);
        }
        return result;
    }

    @Override
    public int getEnergyCost(RedstoneBoardNBT<?> board) {
        return this.boards.get((Object)board.getID()).energyCost;
    }

    private static class BoardFactory {
        public RedstoneBoardNBT<?> boardNBT;
        public int energyCost;

        private BoardFactory() {
        }
    }
}

