/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.tile;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftFactory;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IComplexRefineryRecipeManager;
import buildcraft.api.tiles.IControllable;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.tiles.IHasWork;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.fluids.Tank;
import buildcraft.core.lib.fluids.TankManager;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class TileDistiller
extends TileBuildCraft
implements IFluidHandler,
IHasWork,
IControllable,
IDebuggable,
IInventory {
    private final Tank in;
    private final Tank outGas;
    private final Tank outLiquid;
    private final TankManager<Tank> manager;
    private final SafeTimeTracker networkTimeTracker = new SafeTimeTracker(BuildCraftCore.updateFactor);
    private IComplexRefineryRecipeManager.IDistilationRecipe currentRecipe;
    private int sleep = 0;
    private int lateSleep = 0;
    private long lastCraftTick = -1L;
    @SideOnly(value=Side.CLIENT)
    private boolean hasCraftedRecently;

    public TileDistiller() {
        this.in = new Tank("in", 1000, this);
        this.outGas = new Tank("outGas", 1000, this);
        this.outLiquid = new Tank("outLiquid", 1000, this);
        this.manager = new TankManager(new Tank[]{this.in, this.outGas, this.outLiquid});
        this.mode = IControllable.Mode.On;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.manager.deserializeNBT(nbt.func_74775_l("tanks"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74782_a("tanks", (NBTBase)this.manager.serializeNBT());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readData(ByteBuf stream) {
        this.manager.readData(stream);
        this.sleep = stream.readInt();
        this.hasCraftedRecently = stream.readBoolean();
    }

    @Override
    public void writeData(ByteBuf stream) {
        this.manager.writeData(stream);
        stream.writeInt(this.sleep);
        stream.writeBoolean(this.field_145850_b.func_82737_E() - this.lastCraftTick < 30L);
    }

    @SideOnly(value=Side.CLIENT)
    public Tank getInputTank() {
        return this.in;
    }

    @SideOnly(value=Side.CLIENT)
    public Tank getOutputTankGas() {
        return this.outGas;
    }

    @SideOnly(value=Side.CLIENT)
    public Tank getOutputTankLiquid() {
        return this.outLiquid;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasCraftedRecently() {
        return this.hasCraftedRecently;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.networkTimeTracker.markTimeIfDelay(this.field_145850_b)) {
            this.sendNetworkUpdate();
        }
        this.craft();
        this.export();
    }

    private void craft() {
        this.checkRecipe();
        if (this.mode == IControllable.Mode.On && this.hasWork()) {
            if (this.sleep > 0) {
                --this.sleep;
                return;
            }
            this.distill();
        }
    }

    private void export() {
        this.exportGas();
        this.exportLiquid();
    }

    private void exportGas() {
        if (this.outGas.getFluidAmount() <= 0) {
            return;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state == null || state.func_177230_c() != BuildCraftFactory.distillerBlock) {
            return;
        }
        EnumFacing exportDir = EnumFacing.UP;
        this.exportFluid(this.outGas, exportDir);
    }

    private void exportLiquid() {
        if (this.outLiquid.getFluidAmount() <= 0) {
            return;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state == null || state.func_177230_c() != BuildCraftFactory.distillerBlock) {
            return;
        }
        EnumFacing exportDir = EnumFacing.DOWN;
        this.exportFluid(this.outLiquid, exportDir);
    }

    private void exportFluid(Tank from, EnumFacing exportDir) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(exportDir));
        if (!(tile instanceof IPipeTile)) {
            return;
        }
        if (!(tile instanceof IFluidHandler)) {
            return;
        }
        IFluidHandler fluid = (IFluidHandler)tile;
        if (!fluid.canFill(exportDir.func_176734_d(), from.getFluidType())) {
            return;
        }
        FluidStack stack = from.drain(20, true);
        int filled = fluid.fill(exportDir.func_176734_d(), stack, true);
        if (filled < stack.amount) {
            FluidStack back = stack.copy();
            back.amount -= filled;
            from.fill(back, true);
        }
    }

    private void checkRecipe() {
        if (this.currentRecipe == null) {
            this.currentRecipe = BuildcraftRecipeRegistry.complexRefinery.getDistilationRegistry().getRecipeForInput(this.in.getFluid());
            if (this.currentRecipe != null) {
                this.resetSleep();
            }
            return;
        }
        if (!this.currentRecipe.in().equals((Object)this.in.getFluid())) {
            this.currentRecipe = null;
        }
    }

    private void distill() {
        FluidStack stack = this.in.drain(this.currentRecipe.in().amount, true);
        if (stack.amount < this.currentRecipe.in().amount) {
            this.in.fill(stack, true);
        } else {
            this.outGas.fill(this.currentRecipe.outGas(), true);
            this.outLiquid.fill(this.currentRecipe.outLiquid(), true);
            this.resetSleep();
            this.lastCraftTick = this.field_145850_b.func_82737_E();
        }
    }

    private void resetSleep() {
        double multiplier = this.in.getCapacity() - this.in.getFluidAmount();
        multiplier /= (double)this.in.getCapacity();
        if ((multiplier *= 3.0) < 1.0) {
            multiplier = 1.0;
        }
        this.sleep = this.currentRecipe.ticks() * (int)multiplier;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (from == null || from.func_176740_k() == EnumFacing.Axis.Y) {
            return 0;
        }
        if (BuildcraftRecipeRegistry.complexRefinery.getDistilationRegistry().getRecipeForInput(resource) == null) {
            return 0;
        }
        return this.in.fill(resource, doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (!this.canDrain(from, resource.getFluid())) {
            return null;
        }
        if (from == EnumFacing.DOWN) {
            if (this.outLiquid.getFluid().equals((Object)resource)) {
                return this.outLiquid.drain(resource.amount, doDrain);
            }
        } else if (from == EnumFacing.UP && this.outGas.getFluid().equals((Object)resource)) {
            return this.outGas.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (from == EnumFacing.DOWN) {
            return this.outLiquid.drain(maxDrain, doDrain);
        }
        if (from == EnumFacing.UP) {
            return this.outGas.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (from == null || from.func_176740_k() == EnumFacing.Axis.Y) {
            return false;
        }
        return this.in.fill(new FluidStack(fluid, 1), false) == 1;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        if (from == EnumFacing.DOWN) {
            return this.outLiquid.drain(1, false) != null;
        }
        if (from == EnumFacing.UP) {
            return this.outGas.drain(1, false) != null;
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (from == null) {
            return new FluidTankInfo[0];
        }
        if (from == EnumFacing.DOWN) {
            return new FluidTankInfo[]{this.outLiquid.getInfo()};
        }
        if (from == EnumFacing.UP) {
            return new FluidTankInfo[]{this.outGas.getInfo()};
        }
        return new FluidTankInfo[]{this.in.getInfo()};
    }

    @Override
    public boolean acceptsControlMode(IControllable.Mode mode) {
        return mode == IControllable.Mode.On || mode == IControllable.Mode.Off;
    }

    @Override
    public boolean hasWork() {
        return this.hasWork(true);
    }

    private boolean hasWork(boolean care) {
        if (this.currentRecipe == null) {
            return false;
        }
        boolean ret = !care || this.in.getFluidAmount() >= this.currentRecipe.in().amount;
        ret &= this.outGas.isEmpty() || this.outGas.getFluid().equals((Object)this.currentRecipe.outGas());
        ret &= this.outGas.getCapacity() - this.outGas.getFluidAmount() >= this.currentRecipe.outGas().amount;
        ret &= this.outLiquid.isEmpty() || this.outLiquid.getFluid().equals((Object)this.currentRecipe.outLiquid());
        return ret &= this.outLiquid.getCapacity() - this.outLiquid.getFluidAmount() >= this.currentRecipe.outLiquid().amount;
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        Tank[] tanks = new Tank[]{this.in, this.outGas, this.outLiquid};
        left.add("");
        left.add("Sleep = " + this.sleep);
        for (Tank t : tanks) {
            left.add(StringUtils.capitalize((String)t.getTankName()) + ":");
            left.add(" " + t.getFluidAmount() + "/" + t.getCapacity() + "mB");
            left.add(" " + (t.getFluid() == null ? "empty" : t.getFluidType().getLocalizedName(t.getFluid())));
        }
    }

    public int func_70302_i_() {
        return 3;
    }

    public ItemStack func_70301_a(int index) {
        return null;
    }

    public ItemStack func_70298_a(int index, int count) {
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (this.func_94041_b(index, stack)) {
            // empty if block
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }
}

