/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.gui;

import buildcraft.core.lib.gui.GuiAdvancedInterface;
import buildcraft.factory.gui.ContainerHeatExchange;
import buildcraft.factory.tile.TileHeatExchange;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class GuiHeatExchanger
extends GuiAdvancedInterface {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftfactory:textures/gui/heat_exchanger.png");
    private final TileHeatExchange heatExchange;
    private int inCoolableTicks;
    private int inHeatableTicks;
    private int outCooledTicks;
    private int outHeatedTicks;
    private int craftTicks;

    public GuiHeatExchanger(EntityPlayer player, TileHeatExchange heatExchange) {
        super(new ContainerHeatExchange(player, heatExchange), heatExchange, TEXTURE);
        this.heatExchange = heatExchange;
        this.field_146999_f = 176;
        this.field_147000_g = 171;
    }

    public void func_73876_c() {
        super.func_73876_c();
        --this.inCoolableTicks;
        --this.inHeatableTicks;
        --this.outCooledTicks;
        --this.outHeatedTicks;
        --this.craftTicks;
        boolean crafted = this.heatExchange.hasCraftedRecently();
        if (crafted) {
            this.craftTicks = 20;
        }
        if (this.heatExchange.getInputCoolable().getFluidAmount() > 0 || crafted) {
            this.inCoolableTicks = 20;
        }
        if (this.heatExchange.getInputHeatable().getFluidAmount() > 0 || crafted) {
            this.inHeatableTicks = 20;
        }
        if (this.heatExchange.getOutputCooled().getFluidAmount() > 0 || crafted) {
            this.outCooledTicks = 20;
        }
        if (this.heatExchange.getOutputHeated().getFluidAmount() > 0 || crafted) {
            this.outHeatedTicks = 20;
        }
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        super.func_146976_a(f, mouseX, mouseY);
        if (this.heatExchange != null) {
            this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
            if (this.craftTicks > 0) {
                this.func_73729_b(this.field_147003_i + 61, this.field_147009_r + 11, 176, 71, 54, 71);
            } else {
                if (this.inCoolableTicks > 0) {
                    this.func_73729_b(this.field_147003_i + 61, this.field_147009_r + 41, 176, 30, 11, 11);
                }
                if (this.inHeatableTicks > 0) {
                    this.func_73729_b(this.field_147003_i + 79, this.field_147009_r + 67, 194, 56, 11, 11);
                }
                if (this.outCooledTicks > 0) {
                    this.func_73729_b(this.field_147003_i + 104, this.field_147009_r + 41, 219, 30, 11, 11);
                }
                if (this.outHeatedTicks > 0) {
                    this.func_73729_b(this.field_147003_i + 86, this.field_147009_r + 15, 201, 4, 11, 11);
                }
            }
        }
    }
}

