/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.gui;

import buildcraft.core.lib.gui.GuiAdvancedInterface;
import buildcraft.factory.gui.ContainerDistiller;
import buildcraft.factory.tile.TileDistiller;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class GuiDistiller
extends GuiAdvancedInterface {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftfactory:textures/gui/distiller.png");
    private final TileDistiller distiller;
    private int inTicks;
    private int outGasTicks;
    private int outLiquidTicks;
    private int craftTicks;

    public GuiDistiller(EntityPlayer player, TileDistiller distiller) {
        super(new ContainerDistiller(player, distiller), distiller, TEXTURE);
        this.distiller = distiller;
        this.field_146999_f = 176;
        this.field_147000_g = 161;
    }

    public void func_73876_c() {
        super.func_73876_c();
        --this.inTicks;
        --this.outGasTicks;
        --this.outLiquidTicks;
        --this.craftTicks;
        boolean crafted = this.distiller.hasCraftedRecently();
        if (crafted) {
            this.craftTicks = 20;
        }
        if (this.distiller.getInputTank().getFluidAmount() > 0 || crafted) {
            this.inTicks = 20;
        }
        if (this.distiller.getOutputTankGas().getFluidAmount() > 0 || crafted) {
            this.outGasTicks = 20;
        }
        if (this.distiller.getOutputTankLiquid().getFluidAmount() > 0 || crafted) {
            this.outLiquidTicks = 20;
        }
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        super.func_146976_a(f, mouseX, mouseY);
        if (this.distiller != null) {
            this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
            if (this.craftTicks > 0) {
                this.func_73729_b(this.field_147003_i + 61, this.field_147009_r + 12, 212, 0, 36, 57);
            } else {
                if (this.inTicks > 0) {
                    this.func_73729_b(this.field_147003_i + 61, this.field_147009_r + 35, 176, 23, 12, 11);
                }
                if (this.outGasTicks > 0) {
                    this.func_73729_b(this.field_147003_i + 89, this.field_147009_r + 13, 204, 1, 8, 11);
                }
                if (this.outLiquidTicks > 0) {
                    this.func_73729_b(this.field_147003_i + 89, this.field_147009_r + 57, 204, 45, 8, 11);
                }
            }
        }
    }
}

