/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.fluids.Tank;
import buildcraft.core.lib.fluids.TankManager;
import buildcraft.core.lib.utils.BlockUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileTank
extends TileBuildCraft
implements IFluidHandler,
IDebuggable {
    public final Tank tank = new Tank("tank", 16000, this);
    public final TankManager<Tank> tankManager = new TankManager(new Tank[]{this.tank});
    public boolean hasUpdate = false;
    public boolean hasNetworkUpdate = false;
    public SafeTimeTracker tracker = new SafeTimeTracker(2 * BuildCraftCore.updateFactor);
    private int prevLightValue = 0;
    private int cachedComparatorOverride = 0;

    @Override
    public void initialize() {
        super.initialize();
        this.updateComparators();
    }

    public void updateComparators() {
        int co = this.calculateComparatorInputOverride();
        TileTank uTank = this.getBottomTank();
        while (uTank != null) {
            uTank.cachedComparatorOverride = co;
            uTank.hasUpdate = true;
            uTank = TileTank.getTankAbove(uTank);
        }
    }

    public void onBlockBreak() {
        if (!this.tank.isEmpty()) {
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidSpilledEvent(this.tank.getFluid(), this.field_145850_b, this.field_174879_c));
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isNotReady()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            int lightValue = this.getFluidLightLevel();
            if (this.prevLightValue != lightValue) {
                this.prevLightValue = lightValue;
                this.field_145850_b.func_175653_a(EnumSkyBlock.BLOCK, this.field_174879_c, lightValue);
            }
            return;
        }
        if (this.tank.getFluid() != null) {
            this.moveFluidBelow();
        }
        if (this.hasUpdate) {
            this.field_145850_b.func_180496_d(this.field_174879_c, this.field_145854_h);
            BlockUtils.onComparatorUpdate(this.field_145850_b, this.field_174879_c, this.func_145838_q());
            this.hasUpdate = false;
        }
        if (this.hasNetworkUpdate && this.tracker.markTimeIfDelay(this.field_145850_b)) {
            this.sendNetworkUpdate();
            this.hasNetworkUpdate = false;
        }
    }

    @Override
    public void writeData(ByteBuf data) {
        this.tankManager.writeData(data);
    }

    @Override
    public void readData(ByteBuf stream) {
        this.tankManager.readData(stream);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.tankManager.readFromNBT(data);
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.tankManager.writeToNBT(data);
    }

    public TileTank getBottomTank() {
        TileTank below;
        if (this.isNotReady()) {
            return null;
        }
        TileTank lastTank = this;
        while ((below = TileTank.getTankBelow(lastTank)) != null) {
            lastTank = below;
        }
        return lastTank;
    }

    public TileBuildCraft getTopTank() {
        TileTank above;
        if (this.isNotReady()) {
            return null;
        }
        TileTank lastTank = this;
        while ((above = TileTank.getTankAbove(lastTank)) != null) {
            lastTank = above;
        }
        return lastTank;
    }

    public static TileTank getTankBelow(TileBuildCraft tile) {
        TileEntity below = tile.getTile(EnumFacing.DOWN);
        if (below instanceof TileTank) {
            if (!below.func_145830_o()) {
                return null;
            }
            return (TileTank)below;
        }
        return null;
    }

    public static TileTank getTankAbove(TileBuildCraft tile) {
        TileEntity above = tile.getTile(EnumFacing.UP);
        if (above instanceof TileTank) {
            if (!above.func_145830_o()) {
                return null;
            }
            return (TileTank)above;
        }
        return null;
    }

    public void moveFluidBelow() {
        if (this.isNotReady()) {
            return;
        }
        TileTank below = TileTank.getTankBelow(this);
        if (below == null) {
            return;
        }
        int oldComparator = this.getComparatorInputOverride();
        int used = below.tank.fill(this.tank.getFluid(), true);
        if (used > 0) {
            this.hasNetworkUpdate = true;
            below.hasNetworkUpdate = true;
            if (oldComparator != this.calculateComparatorInputOverride()) {
                this.updateComparators();
            }
            this.tank.drain(used, true);
        }
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (this.isNotReady()) {
            return 0;
        }
        if (resource == null) {
            return 0;
        }
        FluidStack resourceCopy = resource.copy();
        int totalUsed = 0;
        TileTank tankToFill = this.getBottomTank();
        FluidStack liquid = tankToFill.tank.getFluid();
        if (liquid != null && liquid.amount > 0 && !liquid.isFluidEqual(resourceCopy)) {
            return 0;
        }
        int oldComparator = this.getComparatorInputOverride();
        while (tankToFill != null && resourceCopy.amount > 0) {
            int used = tankToFill.tank.fill(resourceCopy, doFill);
            resourceCopy.amount -= used;
            if (used > 0) {
                tankToFill.hasNetworkUpdate = true;
            }
            totalUsed += used;
            tankToFill = TileTank.getTankAbove(tankToFill);
        }
        if (oldComparator != this.calculateComparatorInputOverride()) {
            this.updateComparators();
        }
        return totalUsed;
    }

    public FluidStack drain(EnumFacing from, int maxEmpty, boolean doDrain) {
        if (this.isNotReady()) {
            return null;
        }
        TileTank bottom = this.getBottomTank();
        bottom.hasNetworkUpdate = true;
        int oldComparator = this.getComparatorInputOverride();
        FluidStack output = bottom.tank.drain(maxEmpty, doDrain);
        if (oldComparator != this.calculateComparatorInputOverride()) {
            this.updateComparators();
        }
        return output;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (this.isNotReady()) {
            return null;
        }
        if (resource == null) {
            return null;
        }
        TileTank bottom = this.getBottomTank();
        if (!resource.isFluidEqual(bottom.tank.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidTankInfo[] getTankInfo(EnumFacing direction) {
        if (this.isNotReady()) {
            return new FluidTankInfo[0];
        }
        FluidTank compositeTank = new FluidTank(this.tank.getCapacity());
        TileTank tile = this.getBottomTank();
        if (tile == null || tile.tank.getFluid() == null) {
            return new FluidTankInfo[]{compositeTank.getInfo()};
        }
        compositeTank.setFluid(tile.tank.getFluid().copy());
        int capacity = tile.tank.getCapacity();
        tile = TileTank.getTankAbove(tile);
        while (tile != null) {
            FluidStack liquid = tile.tank.getFluid();
            if (liquid != null && liquid.amount != 0) {
                if (!compositeTank.getFluid().isFluidEqual(liquid)) break;
                compositeTank.getFluid().amount += liquid.amount;
            }
            capacity += tile.tank.getCapacity();
            tile = TileTank.getTankAbove(tile);
        }
        compositeTank.setCapacity(capacity);
        return new FluidTankInfo[]{compositeTank.getInfo()};
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (this.isNotReady()) {
            return false;
        }
        Fluid tankFluid = this.getBottomTank().tank.getFluidType();
        return tankFluid == null || tankFluid == fluid;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        if (this.isNotReady()) {
            return false;
        }
        Fluid tankFluid = this.getBottomTank().tank.getFluidType();
        return tankFluid != null && tankFluid == fluid;
    }

    public int getFluidLightLevel() {
        if (this.isNotReady()) {
            return 0;
        }
        FluidStack tankFluid = this.tank.getFluid();
        return tankFluid == null || tankFluid.amount == 0 ? 0 : tankFluid.getFluid().getLuminosity(tankFluid);
    }

    public int calculateComparatorInputOverride() {
        if (this.isNotReady()) {
            return 0;
        }
        FluidTankInfo[] info = this.getTankInfo(null);
        if (info.length > 0 && info[0] != null && info[0].fluid != null) {
            return info[0].fluid.amount * 15 / info[0].capacity;
        }
        return 0;
    }

    public int getComparatorInputOverride() {
        return this.cachedComparatorOverride;
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("");
        left.add(this.tank.getFluidAmount() + "/" + this.tank.getCapacity() + "mB");
        left.add(this.tank.getFluid() == null ? "empty" : this.tank.getFluidType().getLocalizedName(this.tank.getFluid()));
    }
}

