/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.BuildCraftCore;
import buildcraft.api.enums.EnumEnergyStage;
import buildcraft.api.enums.EnumEngineType;
import buildcraft.api.tools.IToolWrench;
import buildcraft.core.PowerMode;
import buildcraft.core.lib.engines.TileEngineBase;
import buildcraft.core.lib.utils.BCStringUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.FakePlayer;

public class TileEngineCreative
extends TileEngineBase {
    private PowerMode powerMode = PowerMode.M2;

    public TileEngineCreative() {
        this.energyStage = EnumEnergyStage.BLACK;
    }

    @Override
    protected EnumEnergyStage computeEnergyStage() {
        return EnumEnergyStage.BLACK;
    }

    @Override
    public EnumEngineType getEngineType() {
        return EnumEngineType.CREATIVE;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, EnumFacing side) {
        if (!this.func_145831_w().field_72995_K) {
            Item equipped;
            Item item = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
            if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(player, this.field_174879_c)) {
                this.powerMode = this.powerMode.getNext();
                this.energy = 0;
                if (!(player instanceof FakePlayer)) {
                    if (BuildCraftCore.hidePowerNumbers) {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.pipe.power.iron.mode.numberless", new Object[]{BCStringUtils.localize("chat.pipe.power.iron.level." + this.powerMode.maxPower)}));
                    } else {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.pipe.power.iron.mode", new Object[]{this.powerMode.maxPower}));
                    }
                }
                this.sendNetworkUpdate();
                ((IToolWrench)equipped).wrenchUsed(player, this.field_174879_c);
                return true;
            }
        }
        return !player.func_70093_af();
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.powerMode = PowerMode.fromId(data.func_74771_c("mode"));
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74774_a("mode", (byte)this.powerMode.ordinal());
    }

    @Override
    public void readData(ByteBuf stream) {
        super.readData(stream);
        this.powerMode = PowerMode.fromId(stream.readUnsignedByte());
    }

    @Override
    public void writeData(ByteBuf stream) {
        super.writeData(stream);
        stream.writeByte(this.powerMode.ordinal());
    }

    @Override
    public void updateHeat() {
    }

    @Override
    public float getPistonSpeed() {
        return 0.02f * (float)(this.powerMode.ordinal() + 1);
    }

    @Override
    public void engineUpdate() {
        super.engineUpdate();
        if (this.isRedstonePowered) {
            this.addEnergy(this.getIdealOutput());
        }
    }

    @Override
    public boolean isBurning() {
        return this.isRedstonePowered;
    }

    @Override
    public int getMaxEnergy() {
        return this.getIdealOutput();
    }

    @Override
    public int getIdealOutput() {
        return this.powerMode.maxPower;
    }
}

