/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.core.statements.BCStatement;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TriggerFluidContainer
extends BCStatement
implements ITriggerExternal {
    public State state;

    public TriggerFluidContainer(State state) {
        super("buildcraft:fluid." + state.name().toLowerCase(Locale.ROOT), "buildcraft.fluid." + state.name().toLowerCase(Locale.ROOT));
        this.setBuildCraftLocation("core", "triggers/trigger_liquidcontainer_" + state.name().toLowerCase(Locale.ROOT));
        this.state = state;
    }

    @Override
    public int maxParameters() {
        return this.state == State.Contains || this.state == State.Space ? 1 : 0;
    }

    @Override
    public String getDescription() {
        return BCStringUtils.localize("gate.trigger.fluid." + this.state.name().toLowerCase(Locale.ROOT));
    }

    @Override
    public boolean isTriggerActive(TileEntity tile, EnumFacing side, IStatementContainer statementContainer, IStatementParameter[] parameters) {
        if (tile instanceof IFluidHandler) {
            FluidTankInfo[] liquids;
            IFluidHandler container = (IFluidHandler)tile;
            FluidStack searchedFluid = null;
            if (parameters != null && parameters.length >= 1 && parameters[0] != null && parameters[0].getItemStack() != null) {
                searchedFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)parameters[0].getItemStack());
            }
            if (searchedFluid != null) {
                searchedFluid.amount = 1;
            }
            if ((liquids = container.getTankInfo(side)) == null || liquids.length == 0) {
                return false;
            }
            switch (this.state) {
                case Empty: {
                    for (FluidTankInfo c : liquids) {
                        if (c == null || c.fluid == null || c.fluid.amount <= 0 || searchedFluid != null && !searchedFluid.isFluidEqual(c.fluid)) continue;
                        return false;
                    }
                    return true;
                }
                case Contains: {
                    for (FluidTankInfo c : liquids) {
                        if (c == null || c.fluid == null || c.fluid.amount <= 0 || searchedFluid != null && !searchedFluid.isFluidEqual(c.fluid)) continue;
                        return true;
                    }
                    return false;
                }
                case Space: {
                    if (searchedFluid == null) {
                        for (FluidTankInfo c : liquids) {
                            if (c == null || c.fluid != null && c.fluid.amount >= c.capacity) continue;
                            return true;
                        }
                        return false;
                    }
                    return container.fill(side, searchedFluid, false) > 0;
                }
                case Full: {
                    if (searchedFluid == null) {
                        for (FluidTankInfo c : liquids) {
                            if (c == null || c.fluid != null && c.fluid.amount >= c.capacity) continue;
                            return false;
                        }
                        return true;
                    }
                    return container.fill(side, searchedFluid, false) <= 0;
                }
            }
        }
        return false;
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return new StatementParameterItemStack();
    }

    public static enum State {
        Empty,
        Contains,
        Space,
        Full;

    }
}

