/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.proxy;

import buildcraft.BuildCraftCore;
import buildcraft.core.EntityLaser;
import buildcraft.core.TileMarker;
import buildcraft.core.TilePathMarker;
import buildcraft.core.client.BuildCraftStateMapper;
import buildcraft.core.client.RenderTickListener;
import buildcraft.core.lib.EntityResizableCuboid;
import buildcraft.core.lib.client.render.RenderResizableCuboid;
import buildcraft.core.lib.config.DetailedConfigOption;
import buildcraft.core.lib.engines.RenderEngine;
import buildcraft.core.lib.engines.TileEngineBase;
import buildcraft.core.lib.utils.ICustomStateMapper;
import buildcraft.core.lib.utils.IModelRegister;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.render.RenderLaser;
import buildcraft.core.render.RenderMarker;
import buildcraft.core.render.RenderPathMarker;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class CoreProxyClient
extends CoreProxy {
    private LinkedList<Block> blocksToRegisterRenderersFor = new LinkedList();
    private LinkedList<Item> itemsToRegisterRenderersFor = new LinkedList();

    @Override
    public Object getClient() {
        return FMLClientHandler.instance().getClient();
    }

    @Override
    public World getClientWorld() {
        return FMLClientHandler.instance().getClient().field_71441_e;
    }

    @Override
    public void removeEntity(Entity entity) {
        super.removeEntity(entity);
        if (entity.field_70170_p.field_72995_K) {
            ((WorldClient)entity.field_70170_p).func_73028_b(entity.func_145782_y());
        }
    }

    @Override
    public String getItemDisplayName(ItemStack stack) {
        if (stack.func_77973_b() == null) {
            return "";
        }
        return stack.func_82833_r();
    }

    @Override
    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)RenderTickListener.INSTANCE);
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        IReloadableResourceManager reloadable = (IReloadableResourceManager)resourceManager;
        reloadable.func_110542_a((IResourceManagerReloadListener)DetailedConfigOption.ReloadListener.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEngineBase.class, (TileEntitySpecialRenderer)new RenderEngine());
        ClientRegistry.bindTileEntitySpecialRenderer(TilePathMarker.class, (TileEntitySpecialRenderer)new RenderPathMarker());
        ClientRegistry.bindTileEntitySpecialRenderer(TileMarker.class, (TileEntitySpecialRenderer)new RenderMarker());
        RenderingRegistry.registerEntityRenderingHandler(EntityResizableCuboid.class, (Render)RenderResizableCuboid.INSTANCE);
        RenderingRegistry.registerEntityRenderingHandler(EntityLaser.class, (Render)new RenderLaser());
        for (Block block : this.blocksToRegisterRenderersFor) {
            if (block instanceof IModelRegister) {
                ((IModelRegister)block).registerModels();
                continue;
            }
            IBlockState defaultState = block.func_176223_P();
            ArrayListMultimap metaStateMap = ArrayListMultimap.create();
            HashMap stateTypeMap = Maps.newHashMap();
            for (IBlockState iBlockState : block.func_176194_O().func_177619_a()) {
                String type = BuildCraftStateMapper.getPropertyString(iBlockState);
                stateTypeMap.put(iBlockState, type);
                metaStateMap.put((Object)block.func_180651_a(iBlockState), (Object)iBlockState);
            }
            for (Map.Entry entry : metaStateMap.asMap().entrySet()) {
                Collection blockStates = (Collection)entry.getValue();
                if (blockStates.isEmpty()) continue;
                if (blockStates.contains(defaultState)) {
                    this.registerBlockItemModel(defaultState, (Integer)entry.getKey(), (String)stateTypeMap.get(defaultState));
                    continue;
                }
                IBlockState state = (IBlockState)blockStates.iterator().next();
                this.registerBlockItemModel(state, (Integer)entry.getKey(), (String)stateTypeMap.get(state));
            }
        }
        for (Item item : this.itemsToRegisterRenderersFor) {
            if (!(item instanceof IModelRegister)) continue;
            ((IModelRegister)item).registerModels();
        }
    }

    private void registerBlockItemModel(IBlockState state, int meta, String type) {
        Block block = state.func_177230_c();
        ModelResourceLocation location = new ModelResourceLocation(Utils.getNameForBlock(block).replace("|", ""), type.toLowerCase());
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(Item.func_150898_a((Block)block), meta, location);
    }

    @Override
    public String playerName() {
        return FMLClientHandler.instance().getClient().field_71439_g.getDisplayNameString();
    }

    @Override
    public EntityPlayer getPlayerFromNetHandler(INetHandler handler) {
        if (handler instanceof NetHandlerPlayServer) {
            return super.getPlayerFromNetHandler(handler);
        }
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void postRegisterBlock(Block block) {
        this.blocksToRegisterRenderersFor.add(block);
        if (block instanceof ICustomStateMapper) {
            ((ICustomStateMapper)block).setCusomStateMappers();
        } else {
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)BuildCraftStateMapper.INSTANCE);
        }
    }

    @Override
    public void postRegisterItem(Item item) {
        this.itemsToRegisterRenderersFor.add(item);
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public <T extends TileEntity> T getServerTile(T source) {
        TileEntity t;
        Chunk c;
        WorldServer w;
        if (BuildCraftCore.useServerDataOnClient && Minecraft.func_71410_x().func_71356_B() && source.func_145831_w().field_72995_K && (w = DimensionManager.getWorld((int)source.func_145831_w().field_73011_w.func_177502_q())) != null && w.func_72863_F() != null && (c = w.func_175726_f(source.func_174877_v())) != null && (t = c.func_177424_a(source.func_174877_v(), Chunk.EnumCreateEntityType.CHECK)) != null && t.getClass().equals(source.getClass())) {
            return (T)t;
        }
        return source;
    }

    @Override
    public InputStream getStreamForResource(ResourceLocation location) {
        try {
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(location);
            return resource.func_110527_b();
        }
        catch (IOException e) {
            return null;
        }
    }
}

