/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.list;

import buildcraft.api.lists.ListMatchHandler;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.list.ListOreDictionaryCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ListMatchHandlerOreDictionary
extends ListMatchHandler {
    private int getUppercaseCount(String s) {
        int j = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isUpperCase(s.codePointAt(i))) continue;
            ++j;
        }
        return j;
    }

    @Override
    public boolean matches(ListMatchHandler.Type type, ItemStack stack, ItemStack target, boolean precise) {
        block8: {
            Set<Integer> stackIds;
            String[] oreNames;
            int[] matchesIds;
            block7: {
                int[] oreIds = OreDictionary.getOreIDs((ItemStack)stack);
                if (oreIds.length == 0) {
                    if (type == ListMatchHandler.Type.TYPE) {
                        return StackHelper.isMatchingItem(stack, target, false, false);
                    }
                    return false;
                }
                matchesIds = OreDictionary.getOreIDs((ItemStack)target);
                oreNames = new String[oreIds.length];
                for (int i = 0; i < oreIds.length; ++i) {
                    oreNames[i] = OreDictionary.getOreName((int)oreIds[i]);
                }
                if (type != ListMatchHandler.Type.CLASS) break block7;
                for (int i : oreIds) {
                    for (int j : matchesIds) {
                        if (i != j) continue;
                        return true;
                    }
                }
                break block8;
            }
            String s = this.getBestOreString(oreNames);
            if (s == null || (stackIds = ListOreDictionaryCache.INSTANCE.getListOfPartialMatches(type == ListMatchHandler.Type.MATERIAL ? ListOreDictionaryCache.getMaterial(s) : ListOreDictionaryCache.getType(s))) == null) break block8;
            for (int j : stackIds) {
                for (int k : matchesIds) {
                    if (j != k) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isValidSource(ListMatchHandler.Type type, ItemStack stack) {
        if (OreDictionary.getOreIDs((ItemStack)stack).length > 0) {
            return true;
        }
        return type == ListMatchHandler.Type.TYPE && stack.func_77981_g();
    }

    private String getBestOreString(String[] oreIds) {
        String s = null;
        int suc = 0;
        for (String st : oreIds) {
            int suct = this.getUppercaseCount(st);
            if (s != null && suct <= suc) continue;
            s = st;
            suc = suct;
        }
        return s;
    }

    @Override
    public List<ItemStack> getClientExamples(ListMatchHandler.Type type, ItemStack stack) {
        int[] oreIds = OreDictionary.getOreIDs((ItemStack)stack);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (oreIds.length == 0) {
            if (type == ListMatchHandler.Type.TYPE) {
                ArrayList tempStack = new ArrayList();
                stack.func_77973_b().func_150895_a(stack.func_77973_b(), CreativeTabs.field_78026_f, tempStack);
                for (ItemStack is : tempStack) {
                    if (is.func_77973_b() != stack.func_77973_b()) continue;
                    stacks.add(is);
                }
            }
            return stacks;
        }
        String[] oreNames = new String[oreIds.length];
        for (int i = 0; i < oreIds.length; ++i) {
            oreNames[i] = OreDictionary.getOreName((int)oreIds[i]);
        }
        if (type == ListMatchHandler.Type.CLASS) {
            for (String s : oreNames) {
                stacks.addAll(OreDictionary.getOres((String)s));
            }
        } else {
            Set<Integer> stackIds;
            String s = this.getBestOreString(oreNames);
            if (s != null && (stackIds = ListOreDictionaryCache.INSTANCE.getListOfPartialMatches(type == ListMatchHandler.Type.MATERIAL ? ListOreDictionaryCache.getMaterial(s) : ListOreDictionaryCache.getType(s))) != null) {
                for (int j : stackIds) {
                    stacks.addAll(OreDictionary.getOres((String)OreDictionary.getOreName((int)j)));
                }
            }
        }
        ArrayList<ItemStack> wildcard = new ArrayList<ItemStack>();
        for (ItemStack is : stacks) {
            if (is == null || is.func_77952_i() != Short.MAX_VALUE || !is.func_77981_g()) continue;
            wildcard.add(is);
        }
        for (ItemStack is : wildcard) {
            ArrayList wll = new ArrayList();
            is.func_77973_b().func_150895_a(is.func_77973_b(), CreativeTabs.field_78026_f, wll);
            if (wll.size() <= 0) continue;
            stacks.remove(is);
            stacks.addAll(wll);
        }
        return stacks;
    }
}

